#!/bin/bash
# Disable TCP timestamp response. The remote host responding with a TCP
# timestamp can be used to approximate the remote host's uptime, potentially
# adding to further attacks.
set -e

trap Clean_up HUP INT QUIT TERM ERR EXIT

SCRIPT_NAME=$(basename "${0%.sh}")

SYSCTL_CONF=${1:-"/etc/sysctl.conf"}
GEN003600=./GEN003600.sh

# IPv4 options
${GEN003600} ${SYSCTL_CONF} "net.ipv4.tcp_timestamps" 0

