function initLocalization(errorCode){
    var errorKey = "errors."+ errorCode;
    var getLocaleStrings = "/SAAS/API/1.0/REST/admin/localize?patternString=" + errorKey + ",layout.copyright,layout.patentslink,layout.buildVersion";
    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function() {
        if (this.readyState == 4 && this.status == 200) {
            if (this.responseText === '{}'){
                return;
            }
            var localeMap = JSON.parse(this.responseText),
                localeStrings = {
                    'errorMessage' : localeMap[errorKey],
                    'footerText':  localeMap['layout.copyright'],
                    'layout.patentslink': localeMap['layout.patentslink'],
                    'layout.buildVersion': localeMap['layout.buildVersion']

                },
                loadLocalization = function(localeStrings){
                    for (var elementId in localeStrings){
                        if (!localeStrings.hasOwnProperty(elementId) || !localeStrings[elementId]) {
                            continue;
                        }
                        if (document.getElementById(elementId) && document.getElementById(elementId).innerHTML  !== localeStrings[elementId]){

                            // Form footer text as VMware product + copyright + refer url
                            if(elementId == 'footerText' && localeMap['layout.buildVersion'] && localeStrings['layout.patentslink']){
                                localeMap['layout.buildVersion'] = localeMap['layout.buildVersion'].replace(' {0}', '. ');
                                localeStrings[elementId] = localeMap['layout.buildVersion'] + localeStrings[elementId] +
                                    ' <a href="'+ localeStrings['layout.patentslink'] +'">'+ localeStrings['layout.patentslink']+'</a>';
                            }

                            document.getElementById(elementId).innerHTML  = localeStrings[elementId];
                        }
                    }
                }
            loadLocalization(localeStrings);
        }
    };
    xhttp.open("GET", getLocaleStrings, true);
    xhttp.send();
}