<%@ page isErrorPage = "true"%>
<%@ page pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<!DOCTYPE html>
<html>

<c:set var="loc" value="<%=request.getLocale().getLanguage() %>"/>
<c:set var="status" value="<%=response.getStatus() %>"/>

<fmt:setLocale value="${loc}" />
<fmt:setBundle basename="ErrorMessage" var="msg"/>

<fmt:message var="errTxt" key="${status}" bundle="${msg}"/>
<c:if test='${fn:startsWith(errTxt, "??")}'>
    <fmt:message var="errMsg" key="error" bundle="${msg}"/>
    <c:set var="errTxt" value="${status} : ${errMsg}"/>
</c:if>

    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <meta content="text/css" http-equiv="content-style-type">
        <meta name="author" content="VMware, Inc.">
        <meta http-equiv="Pragma" content="no-cache">
        <meta http-equiv="Cache-Control" content="no-cache,no-store">
        <meta http-equiv="expires" content="Tue, 20 Aug 1996 14:25:27 GMT">
        <title>Identity Manager</title>
        <link rel="shortcut icon" href="/img/favicon.ico" type="image/x-icon">
        <link rel="stylesheet" type="text/css" href="/error/css/base.css"/>
    </head>
    <body class="horizon one-col">

        <div class="admin-header">
            <div class="admin-header-inner">
                <div class="admin-header-org">Identity Manager</div>
            </div>
        </div>

        <div class="content clearfix">
            <div class="content-inner">
                <div class="error-message clearfix">
                    <div class="float-l ico-16 ico-error"></div>
                    <div class="text">
                      ${errTxt}
                    </div>
                </div>
            </div>
        </div>

        <div class="footer clear">
            <div class="footer-inner">
                <div class="footer-text">
                    <fmt:message key="footer" bundle="${msg}"/>
                </div>
            </div>
        </div>
    </body>
</html>
