#!/usr/bin/env bash

lang=$( echo "$1" | tr "[A-Z]" "[a-z]" )

    case "$lang" in
        aar|aa) echo "Afar" ;;
        abk|ab) echo "Abkhazian" ;;
        ace) echo "Achinese" ;;
        ach) echo "Acoli" ;;
        ada) echo "Adangme" ;;
        ady) echo "Adyghe; Adygei" ;;
        afa) echo "Afro-Asiatic languages" ;;
        afh) echo "Afrihili" ;;
        afr|af) echo "Afrikaans" ;;
        ain) echo "Ainu" ;;
        aka|ak) echo "Akan" ;;
        akk) echo "Akkadian" ;;
        alb|sqi|sq) echo "Albanian" ;;
        ale) echo "Aleut" ;;
        alg) echo "Algonquian languages" ;;
        alt) echo "Southern Altai" ;;
        amh|am) echo "Amharic" ;;
        ang) echo "English, Old (ca.450-1100)" ;;
        anp) echo "Angika" ;;
        apa) echo "Apache languages" ;;
        ara|ar) echo "Arabic" ;;
        arc) echo "Official Aramaic (700-300 BCE); Imperial Aramaic (700-300 BCE)" ;;
        arg|an) echo "Aragonese" ;;
        arm|hye|hy) echo "Armenian" ;;
        arn) echo "Mapudungun; Mapuche" ;;
        arp) echo "Arapaho" ;;
        art) echo "Artificial languages" ;;
        arw) echo "Arawak" ;;
        asm|as) echo "Assamese" ;;
        ast) echo "Asturian; Bable; Leonese; Asturleonese" ;;
        ath) echo "Athapascan languages" ;;
        aus) echo "Australian languages" ;;
        ava|av) echo "Avaric" ;;
        ave|ae) echo "Avestan" ;;
        awa) echo "Awadhi" ;;
        aym|ay) echo "Aymara" ;;
        aze|az) echo "Azerbaijani" ;;
        bad) echo "Banda languages" ;;
        bai) echo "Bamileke languages" ;;
        bak|ba) echo "Bashkir" ;;
        bal) echo "Baluchi" ;;
        bam|bm) echo "Bambara" ;;
        ban) echo "Balinese" ;;
        baq|eus|eu) echo "Basque" ;;
        bas) echo "Basa" ;;
        bat) echo "Baltic languages" ;;
        bej) echo "Beja; Bedawiyet" ;;
        bel|be) echo "Belarusian" ;;
        bem) echo "Bemba" ;;
        ben|bn) echo "Bengali" ;;
        ber) echo "Berber languages" ;;
        bho) echo "Bhojpuri" ;;
        bih|bh) echo "Bihari languages" ;;
        bik) echo "Bikol" ;;
        bin) echo "Bini; Edo" ;;
        bis|bi) echo "Bislama" ;;
        bla) echo "Siksika" ;;
        bnt) echo "Bantu languages" ;;
        tib|bod|bo) echo "Tibetan" ;;
        bos|bs) echo "Bosnian" ;;
        bra) echo "Braj" ;;
        bre|br) echo "Breton" ;;
        btk) echo "Batak languages" ;;
        bua) echo "Buriat" ;;
        bug) echo "Buginese" ;;
        bul|bg) echo "Bulgarian" ;;
        bur|mya|my) echo "Burmese" ;;
        byn) echo "Blin; Bilin" ;;
        cad) echo "Caddo" ;;
        cai) echo "Central American Indian languages" ;;
        car) echo "Galibi Carib" ;;
        cat|ca) echo "Catalan; Valencian" ;;
        cau) echo "Caucasian languages" ;;
        ceb) echo "Cebuano" ;;
        cel) echo "Celtic languages" ;;
        cze|ces|cs) echo "Czech" ;;
        cha|ch) echo "Chamorro" ;;
        chb) echo "Chibcha" ;;
        che|ce) echo "Chechen" ;;
        chg) echo "Chagatai" ;;
        chi|zho|zh) echo "Chinese" ;;
        chk) echo "Chuukese" ;;
        chm) echo "Mari" ;;
        chn) echo "Chinook jargon" ;;
        cho) echo "Choctaw" ;;
        chp) echo "Chipewyan; Dene Suline" ;;
        chr) echo "Cherokee" ;;
        chu|cu) echo "Church Slavic; Old Slavonic; Church Slavonic; Old Bulgarian; Old Church Slavonic" ;;
        chv|cv) echo "Chuvash" ;;
        chy) echo "Cheyenne" ;;
        cmc) echo "Chamic languages" ;;
        cop) echo "Coptic" ;;
        cor|kw) echo "Cornish" ;;
        cos|co) echo "Corsican" ;;
        cpe) echo "Creoles and pidgins, English based" ;;
        cpf) echo "Creoles and pidgins, French-based" ;;
        cpp) echo "Creoles and pidgins, Portuguese-based" ;;
        cre|cr) echo "Cree" ;;
        crh) echo "Crimean Tatar; Crimean Turkish" ;;
        crp) echo "Creoles and pidgins" ;;
        csb) echo "Kashubian" ;;
        cus) echo "Cushitic languages" ;;
        wel|cym|cy) echo "Welsh" ;;
        cze|ces|cs) echo "Czech" ;;
        dak) echo "Dakota" ;;
        dan|da) echo "Danish" ;;
        dar) echo "Dargwa" ;;
        day) echo "Land Dayak languages" ;;
        del) echo "Delaware" ;;
        den) echo "Slave (Athapascan)" ;;
        ger|deu|de) echo "German" ;;
        dgr) echo "Dogrib" ;;
        din) echo "Dinka" ;;
        div|dv) echo "Divehi; Dhivehi; Maldivian" ;;
        doi) echo "Dogri" ;;
        dra) echo "Dravidian languages" ;;
        dsb) echo "Lower Sorbian" ;;
        dua) echo "Duala" ;;
        dum) echo "Dutch, Middle (ca.1050-1350)" ;;
        dut|nld|nl) echo "Dutch; Flemish" ;;
        dyu) echo "Dyula" ;;
        dzo|dz) echo "Dzongkha" ;;
        efi) echo "Efik" ;;
        egy) echo "Egyptian (Ancient)" ;;
        eka) echo "Ekajuk" ;;
        gre|ell|el) echo "Greek, Modern (1453-)" ;;
        elx) echo "Elamite" ;;
        eng|en) echo "English" ;;
        enm) echo "English, Middle (1100-1500)" ;;
        epo|eo) echo "Esperanto" ;;
        est|et) echo "Estonian" ;;
        baq|eus|eu) echo "Basque" ;;
        ewe|ee) echo "Ewe" ;;
        ewo) echo "Ewondo" ;;
        fan) echo "Fang" ;;
        fao|fo) echo "Faroese" ;;
        per|fas|fa) echo "Persian" ;;
        fat) echo "Fanti" ;;
        fij|fj) echo "Fijian" ;;
        fil) echo "Filipino; Pilipino" ;;
        fin|fi) echo "Finnish" ;;
        fiu) echo "Finno-Ugrian languages" ;;
        fon|Fon) echo "fon" ;;
        fre|fra|fr) echo "French" ;;
        fre|fra|fr) echo "French" ;;
        frm) echo "French, Middle (ca.1400-1600)" ;;
        fro) echo "French, Old (842-ca.1400)" ;;
        frr) echo "Northern Frisian" ;;
        frs) echo "Eastern Frisian" ;;
        fry|fy) echo "Western Frisian" ;;
        ful|ff) echo "Fulah" ;;
        fur) echo "Friulian" ;;
        gaa|Ga) echo "ga" ;;
        gay) echo "Gayo" ;;
        gba) echo "Gbaya" ;;
        gem) echo "Germanic languages" ;;
        geo|kat|ka) echo "Georgian" ;;
        ger|deu|de) echo "German" ;;
        gez) echo "Geez" ;;
        gil) echo "Gilbertese" ;;
        gla|gd) echo "Gaelic; Scottish Gaelic" ;;
        gle|ga) echo "Irish" ;;
        glg|gl) echo "Galician" ;;
        glv|gv) echo "Manx" ;;
        gmh) echo "German, Middle High (ca.1050-1500)" ;;
        goh) echo "German, Old High (ca.750-1050)" ;;
        gon) echo "Gondi" ;;
        gor) echo "Gorontalo" ;;
        got) echo "Gothic" ;;
        grb) echo "Grebo" ;;
        grc) echo "Greek, Ancient (to 1453)" ;;
        gre|ell|el) echo "Greek, Modern (1453-)" ;;
        grn|gn) echo "Guarani" ;;
        gsw) echo "Swiss German; Alemannic; Alsatian" ;;
        guj|gu) echo "Gujarati" ;;
        gwi) echo "Gwich'in" ;;
        hai) echo "Haida" ;;
        hat|ht) echo "Haitian; Haitian Creole" ;;
        hau|ha) echo "Hausa" ;;
        haw) echo "Hawaiian" ;;
        heb|he) echo "Hebrew" ;;
        her|hz) echo "Herero" ;;
        hil) echo "Hiligaynon" ;;
        him) echo "Himachali languages; Western Pahari languages" ;;
        hin|hi) echo "Hindi" ;;
        hit) echo "Hittite" ;;
        hmo|ho) echo "Hiri Motu" ;;
        hrv|hr) echo "Croatian" ;;
        hsb) echo "Upper Sorbian" ;;
        hun|hu) echo "Hungarian" ;;
        hup) echo "Hupa" ;;
        arm|hye|hy) echo "Armenian" ;;
        iba) echo "Iban" ;;
        ibo|ig) echo "Igbo" ;;
        ice|isl|is) echo "Icelandic" ;;
        ido|io) echo "Ido" ;;
        iii|ii) echo "Sichuan Yi; Nuosu" ;;
        ijo) echo "Ijo languages" ;;
        iku|iu) echo "Inuktitut" ;;
        ile|ie) echo "Interlingue; Occidental" ;;
        ilo) echo "Iloko" ;;
        ina|ia) echo "Interlingua (International Auxiliary Language Association)" ;;
        inc) echo "Indic languages" ;;
        ind|id) echo "Indonesian" ;;
        ine) echo "Indo-European languages" ;;
        inh) echo "Ingush" ;;
        ipk|ik) echo "Inupiaq" ;;
        ira) echo "Iranian languages" ;;
        iro) echo "Iroquoian languages" ;;
        ice|isl|is) echo "Icelandic" ;;
        ita|it) echo "Italian" ;;
        jav|jv) echo "Javanese" ;;
        jbo) echo "Lojban" ;;
        jpn|ja) echo "Japanese" ;;
        jpr) echo "Judeo-Persian" ;;
        jrb) echo "Judeo-Arabic" ;;
        kaa) echo "Kara-Kalpak" ;;
        kab) echo "Kabyle" ;;
        kac) echo "Kachin; Jingpho" ;;
        kal|kl) echo "Kalaallisut; Greenlandic" ;;
        kam) echo "Kamba" ;;
        kan|kn) echo "Kannada" ;;
        kar) echo "Karen languages" ;;
        kas|ks) echo "Kashmiri" ;;
        geo|kat|ka) echo "Georgian" ;;
        kau|kr) echo "Kanuri" ;;
        kaw) echo "Kawi" ;;
        kaz|kk) echo "Kazakh" ;;
        kbd) echo "Kabardian" ;;
        kha) echo "Khasi" ;;
        khi) echo "Khoisan languages" ;;
        khm|km) echo "Central Khmer" ;;
        kho) echo "Khotanese; Sakan" ;;
        kik|ki) echo "Kikuyu; Gikuyu" ;;
        kin|rw) echo "Kinyarwanda" ;;
        kir|ky) echo "Kirghiz; Kyrgyz" ;;
        kmb) echo "Kimbundu" ;;
        kok) echo "Konkani" ;;
        kom|kv) echo "Komi" ;;
        kon|kg) echo "Kongo" ;;
        kor|ko) echo "Korean" ;;
        kos) echo "Kosraean" ;;
        kpe) echo "Kpelle" ;;
        krc) echo "Karachay-Balkar" ;;
        krl) echo "Karelian" ;;
        kro) echo "Kru languages" ;;
        kru) echo "Kurukh" ;;
        kua|kj) echo "Kuanyama; Kwanyama" ;;
        kum) echo "Kumyk" ;;
        kur|ku) echo "Kurdish" ;;
        kut) echo "Kutenai" ;;
        lad) echo "Ladino" ;;
        lah) echo "Lahnda" ;;
        lam) echo "Lamba" ;;
        lao|lo) echo "Lao" ;;
        lat|la) echo "Latin" ;;
        lav|lv) echo "Latvian" ;;
        lez) echo "Lezghian" ;;
        lim|li) echo "Limburgan; Limburger; Limburgish" ;;
        lin|ln) echo "Lingala" ;;
        lit|lt) echo "Lithuanian" ;;
        lol) echo "Mongo" ;;
        loz) echo "Lozi" ;;
        ltz|lb) echo "Luxembourgish; Letzeburgesch" ;;
        lua) echo "Luba-Lulua" ;;
        lub|lu) echo "Luba-Katanga" ;;
        lug|lg) echo "Ganda" ;;
        lui) echo "Luiseno" ;;
        lun) echo "Lunda" ;;
        luo) echo "Luo (Kenya and Tanzania)" ;;
        lus) echo "Lushai" ;;
        mac|mkd|mk) echo "Macedonian" ;;
        mad) echo "Madurese" ;;
        mag) echo "Magahi" ;;
        mah|mh) echo "Marshallese" ;;
        mai) echo "Maithili" ;;
        mak) echo "Makasar" ;;
        mal|ml) echo "Malayalam" ;;
        man) echo "Mandingo" ;;
        mao|mri|mi) echo "Maori" ;;
        map) echo "Austronesian languages" ;;
        mar|mr) echo "Marathi" ;;
        mas) echo "Masai" ;;
        may|msa|ms) echo "Malay" ;;
        mdf) echo "Moksha" ;;
        mdr) echo "Mandar" ;;
        men) echo "Mende" ;;
        mga) echo "Irish, Middle (900-1200)" ;;
        mic) echo "Mi'kmaq; Micmac" ;;
        min) echo "Minangkabau" ;;
        mis) echo "Uncoded languages" ;;
        mac|mkd|mk) echo "Macedonian" ;;
        mkh) echo "Mon-Khmer languages" ;;
        mlg|mg) echo "Malagasy" ;;
        mlt|mt) echo "Maltese" ;;
        mnc) echo "Manchu" ;;
        mni) echo "Manipuri" ;;
        mno) echo "Manobo languages" ;;
        moh) echo "Mohawk" ;;
        mon|mn) echo "Mongolian" ;;
        mos) echo "Mossi" ;;
        mao|mri|mi) echo "Maori" ;;
        may|msa|ms) echo "Malay" ;;
        mul) echo "Multiple languages" ;;
        mun) echo "Munda languages" ;;
        mus) echo "Creek" ;;
        mwl) echo "Mirandese" ;;
        mwr) echo "Marwari" ;;
        bur|mya|my) echo "Burmese" ;;
        myn) echo "Mayan languages" ;;
        myv) echo "Erzya" ;;
        nah) echo "Nahuatl languages" ;;
        nai) echo "North American Indian languages" ;;
        nap) echo "Neapolitan" ;;
        nau|na) echo "Nauru" ;;
        nav|nv) echo "Navajo; Navaho" ;;
        nbl|nr) echo "Ndebele, South; South Ndebele" ;;
        nde|nd) echo "Ndebele, North; North Ndebele" ;;
        ndo|ng) echo "Ndonga" ;;
        nds) echo "Low German; Low Saxon; German, Low; Saxon, Low" ;;
        nep|ne) echo "Nepali" ;;
        new) echo "Nepal Bhasa; Newari" ;;
        nia) echo "Nias" ;;
        nic) echo "Niger-Kordofanian languages" ;;
        niu) echo "Niuean" ;;
        dut|nld|nl) echo "Dutch; Flemish" ;;
        nno|nn) echo "Norwegian Nynorsk; Nynorsk, Norwegian" ;;
        nob|nb) echo "Bokmal, Norwegian; Norwegian Bokmal" ;;
        nog) echo "Nogai" ;;
        non) echo "Norse, Old" ;;
        nor|no) echo "Norwegian" ;;
        nqo) echo "N'Ko" ;;
        nso) echo "Pedi; Sepedi; Northern Sotho" ;;
        nub) echo "Nubian languages" ;;
        nwc) echo "Classical Newari; Old Newari; Classical Nepal Bhasa" ;;
        nya|ny) echo "Chichewa; Chewa; Nyanja" ;;
        nym) echo "Nyamwezi" ;;
        nyn) echo "Nyankole" ;;
        nyo) echo "Nyoro" ;;
        nzi) echo "Nzima" ;;
        oci|oc) echo "Occitan (post 1500)" ;;
        oji|oj) echo "Ojibwa" ;;
        ori|or) echo "Oriya" ;;
        orm|om) echo "Oromo" ;;
        osa) echo "Osage" ;;
        oss|os) echo "Ossetian; Ossetic" ;;
        ota) echo "Turkish, Ottoman (1500-1928)" ;;
        oto) echo "Otomian languages" ;;
        paa) echo "Papuan languages" ;;
        pag) echo "Pangasinan" ;;
        pal) echo "Pahlavi" ;;
        pam) echo "Pampanga; Kapampangan" ;;
        pan|pa) echo "Panjabi; Punjabi" ;;
        pap) echo "Papiamento" ;;
        pau) echo "Palauan" ;;
        peo) echo "Persian, Old (ca.600-400 B.C.)" ;;
        per|fas|fa) echo "Persian" ;;
        phi) echo "Philippine languages" ;;
        phn) echo "Phoenician" ;;
        pli|pi) echo "Pali" ;;
        pol|pl) echo "Polish" ;;
        pon) echo "Pohnpeian" ;;
        por|pt) echo "Portuguese" ;;
        pra) echo "Prakrit languages" ;;
        pro) echo "Provencal, Old (to 1500);Occitan, Old (to 1500)" ;;
        pus|ps) echo "Pushto; Pashto" ;;
        que|qu) echo "Quechua" ;;
        raj) echo "Rajasthani" ;;
        rap) echo "Rapanui" ;;
        rar) echo "Rarotongan; Cook Islands Maori" ;;
        roa) echo "Romance languages" ;;
        roh|rm) echo "Romansh" ;;
        rom) echo "Romany" ;;
        rum|ron|ro) echo "Romanian; Moldavian; Moldovan" ;;
        rum|ron|ro) echo "Romanian; Moldavian; Moldovan" ;;
        run|rn) echo "Rundi" ;;
        rup) echo "Aromanian; Arumanian; Macedo-Romanian" ;;
        rus|ru) echo "Russian" ;;
        sad) echo "Sandawe" ;;
        sag|sg) echo "Sango" ;;
        sah) echo "Yakut" ;;
        sai) echo "South American Indian languages" ;;
        sal) echo "Salishan languages" ;;
        sam) echo "Samaritan Aramaic" ;;
        san|sa) echo "Sanskrit" ;;
        sas) echo "Sasak" ;;
        sat) echo "Santali" ;;
        scn) echo "Sicilian" ;;
        sco) echo "Scots" ;;
        sel) echo "Selkup" ;;
        sem) echo "Semitic languages" ;;
        sga) echo "Irish, Old (to 900)" ;;
        sgn) echo "Sign Languages" ;;
        shn) echo "Shan" ;;
        sid) echo "Sidamo" ;;
        sin|si) echo "Sinhala; Sinhalese" ;;
        sio) echo "Siouan languages" ;;
        sit) echo "Sino-Tibetan languages" ;;
        sla) echo "Slavic languages" ;;
        slo|slk|sk) echo "Slovak" ;;
        slo|slk|sk) echo "Slovak" ;;
        slv|sl) echo "Slovenian" ;;
        sma) echo "Southern Sami" ;;
        sme|se) echo "Northern Sami" ;;
        smi) echo "Sami languages" ;;
        smj) echo "Lule Sami" ;;
        smn) echo "Inari Sami" ;;
        smo|sm) echo "Samoan" ;;
        sms) echo "Skolt Sami" ;;
        sna|sn) echo "Shona" ;;
        snd|sd) echo "Sindhi" ;;
        snk) echo "Soninke" ;;
        sog) echo "Sogdian" ;;
        som|so) echo "Somali" ;;
        son) echo "Songhai languages" ;;
        sot|st) echo "Sotho, Southern" ;;
        spa|es) echo "Spanish; Castilian" ;;
        alb|sqi|sq) echo "Albanian" ;;
        srd|sc) echo "Sardinian" ;;
        srn) echo "Sranan Tongo" ;;
        srp|sr) echo "Serbian" ;;
        srr) echo "Serer" ;;
        ssa) echo "Nilo-Saharan languages" ;;
        ssw|ss) echo "Swati" ;;
        suk) echo "Sukuma" ;;
        sun|su) echo "Sundanese" ;;
        sus) echo "Susu" ;;
        sux) echo "Sumerian" ;;
        swa|sw) echo "Swahili" ;;
        swe|sv) echo "Swedish" ;;
        syc) echo "Classical Syriac" ;;
        syr) echo "Syriac" ;;
        tah|ty) echo "Tahitian" ;;
        tai) echo "Tai languages" ;;
        tam|ta) echo "Tamil" ;;
        tat|tt) echo "Tatar" ;;
        tel|te) echo "Telugu" ;;
        tem) echo "Timne" ;;
        ter) echo "Tereno" ;;
        tet) echo "Tetum" ;;
        tgk|tg) echo "Tajik" ;;
        tgl|tl) echo "Tagalog" ;;
        tha|th) echo "Thai" ;;
        tib|bod|bo) echo "Tibetan" ;;
        tig) echo "Tigre" ;;
        tir|ti) echo "Tigrinya" ;;
        tiv|Tiv) echo "tiv" ;;
        tkl) echo "Tokelau" ;;
        tlh) echo "Klingon; tlhIngan-Hol" ;;
        tli) echo "Tlingit" ;;
        tmh) echo "Tamashek" ;;
        tog) echo "Tonga (Nyasa)" ;;
        ton|to) echo "Tonga (Tonga Islands)" ;;
        tpi) echo "Tok Pisin" ;;
        tsi) echo "Tsimshian" ;;
        tsn|tn) echo "Tswana" ;;
        tso|ts) echo "Tsonga" ;;
        tuk|tk) echo "Turkmen" ;;
        tum) echo "Tumbuka" ;;
        tup) echo "Tupi languages" ;;
        tur|tr) echo "Turkish" ;;
        tut) echo "Altaic languages" ;;
        tvl) echo "Tuvalu" ;;
        twi|tw) echo "Twi" ;;
        tyv) echo "Tuvinian" ;;
        udm) echo "Udmurt" ;;
        uga) echo "Ugaritic" ;;
        uig|ug) echo "Uighur; Uyghur" ;;
        ukr|uk) echo "Ukrainian" ;;
        umb) echo "Umbundu" ;;
        und) echo "Undetermined" ;;
        urd|ur) echo "Urdu" ;;
        uzb|uz) echo "Uzbek" ;;
        vai|Vai) echo "vai" ;;
        ven|ve) echo "Venda" ;;
        vie|vi) echo "Vietnamese" ;;
        vol|vo) echo "Volapük" ;;
        vot) echo "Votic" ;;
        wak) echo "Wakashan languages" ;;
        wal) echo "Wolaitta; Wolaytta" ;;
        war) echo "Waray" ;;
        was) echo "Washo" ;;
        wel|cym|cy) echo "Welsh" ;;
        wen) echo "Sorbian languages" ;;
        wln|wa) echo "Walloon" ;;
        wol|wo) echo "Wolof" ;;
        xal) echo "Kalmyk; Oirat" ;;
        xho|xh) echo "Xhosa" ;;
        yao|Yao) echo "yao" ;;
        yap) echo "Yapese" ;;
        yid|yi) echo "Yiddish" ;;
        yor|yo) echo "Yoruba" ;;
        ypk) echo "Yupik languages" ;;
        zap) echo "Zapotec" ;;
        zbl) echo "Blissymbols; Blissymbolics; Bliss" ;;
        zen) echo "Zenaga" ;;
        zha|za) echo "Zhuang; Chuang" ;;
        chi|zho|zh) echo "Chinese" ;;
        znd) echo "Zande languages" ;;
        zul|zu) echo "Zulu" ;;
        zun) echo "Zuni" ;;
        zza) echo "Zaza; Dimili; Dimli; Kirdki; Kirmanjki; Zazaki" ;;
        *) echo "unknown language" ; exit 1 ;;
    esac

exit 0
