#!/usr/bin/env python

# Copyright 2009 VMware, Inc.  All rights reserved.
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
# 


import sys
import os
import sys
import time
import getopt

# For VAs installed with Python 2.7.9 or higher version, it verifies
# SSL certificates in "strict" mode. See PR 1732391 for details.
# Disable SSL verification for sfcb on those target systems.
import ssl
try:
    _create_unverified_https_context = ssl._create_unverified_context
except AttributeError:
    # Legacy Python that doesn't verify HTTPS certificates by default
    pass
else:
    # Handle target environment that doesn't support HTTPS verification
    ssl._create_default_https_context = _create_unverified_https_context

sys.path.append("/opt/vmware/lib/python/site-packages/")
import pywbem

CIM_SERVER_URL = 'https://localhost:5489'
DEFAULT_CIM_NAMESPACE = 'root/cimv2'
SFCB_CERT_FILE    = '/opt/vmware/etc/sfcb/client.pem'
SFCB_KEY_FILE     = '/opt/vmware/etc/sfcb/file.pem'

#
# get cim connection to local sfcb
#
def getCIMConnection (url, namespace):
    cred = {}
    cred ['cert_file'] = SFCB_CERT_FILE
    cred ['key_file'] = SFCB_KEY_FILE
    cliconn = pywbem.WBEMConnection (url, None, namespace, cred)
    return cliconn

def getDefaultCIMConnection ():
    return getCIMConnection (CIM_SERVER_URL, DEFAULT_CIM_NAMESPACE)


def invokeNonStaticMethod (namespace, className, methodName):
  cliconn = getCIMConnection (CIM_SERVER_URL, namespace)
  if cliconn != None:
    insts = cliconn.EnumerateInstanceNames(className)
    for inst in insts:
      rettuple = cliconn.InvokeMethod(methodName, inst)
      return rettuple

def invokeStaticMethod (namespace, className, methodName):
  cliconn = getCIMConnection (CIM_SERVER_URL, namespace)
  if cliconn != None:
    rettuple = cliconn.InvokeMethod(methodName,
                                    pywbem.CIMClassName(className,
                                                        None,
                                                        namespace,
                                                       ))
    return rettuple
