#!/usr/bin/env python

# Copyright 2009-2011 VMware, Inc.  All rights reserved.
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
from __future__ import print_function

import sys
import os
import sys
import time
import getopt

sys.path.append("/opt/vmware/lib/python/site-packages/")

LOG_ERROR   = "ERROR"
LOG_WARNING = "warning"
LOG_INFO    = "info"

#
# log file support
#
class logfile:
    """Maintain a log file"""

    def __init__(self, logfile):
        self.file = logfile
        d = os.path.dirname(logfile)
        if ( not os.path.exists(d) ):
            # consider the race between os.path.exists() and os.makedirs(), catch except is necessary
            try:
                os.makedirs(d)
            except OSError:
                pass

    def message(self, level, msg, stdout = False):
        msg = msg.strip()
        if stdout:
            print (msg)
            #
            # simulate a line buffered mode by flushing stdout after
            # every log message.
            #
            sys.stdout.flush()

        if self.file:
            #
            # DD/MM/YYYY HH:MM:SS [info] message
            #
            st = time.strftime("%d/%m/%Y %H:%M:%S") + \
                                " [" + level + "] " "[process id: %d" % (os.getpid(), ) + "] " + msg + "\n"
            try:
                fd = open(self.file, "a")
                fd.write(st)
                fd.close()
            except Exception as errmsg:
                # if there is an exeception writing to log file let's ignore it
                # this shouldn't happen
                print ("Unable to write to log file (%s): %s", ( self.file, str(errmsg) ))

