drop table "SrmServer";

alter table "Vm" add column "biosUuid" varchar(128) not null default('');
alter table "Vm" alter column "biosUuid" drop default;

drop table "ProtectedVmMonth";

create table "ProtectedUuidMonth" (
    "id" integer primary key not null,
    "name" varchar(128) not null,
    "biosUuid" varchar(128) not null,
    "year" integer not null,
    "month" integer not null
  );
create sequence "s_ProtectedUuidMonth_id";
create unique index "ProtectedUuidMonth_biosUuid_year_month" on "ProtectedUuidMonth" ("biosUuid","year","month");

drop view "SampleToLicense";        -- betweenco depends on this

drop function if exists betweenco(timestamp, timestamp, timestamp); -- May have been created as a fix to 3.2 (PR 1144058)
create function betweenco(timestamp, timestamp, timestamp) returns boolean as
    'select $1 >= $2 and $1 < $3'
    language SQL immutable;

create view "SampleToLicense" as
    select c."vcServerId", s.id "sampleId", s."collectionId", c.start, s."vmId",
    v."reportExclusionReason",
    vh.id "vmhId", vh."hostId",
    hh.id "hhId", hh."licenseId",
    l."licenseCategoryId",
    lc.billable
    from "Sample" s, "Collection" c, "Vm" v, "VmHistory" vh, "Host" h, "HostHistory" hh, "License" l, "LicenseCategory" lc
    where s."collectionId" = c.id and s."vmId" = v.id and v.id = vh."vmId" and betweenco(c.start, vh.time, vh."nextTime")
    and v."hostId" = h.id and hh."hostId" = h.id and betweenco(c.start, hh.time, hh."nextTime")
    and hh."licenseId" = l.id
    and l."licenseCategoryId" = lc.id;

alter table "Collection" drop column stop;

alter table "VcServer" add column "meter" boolean not null default(true);
alter table "VcServer" alter column "meter" drop default;

create table "SrmVcPair" (
    "id" integer primary key not null,
    "vcServerId1" integer not null,
    "vcServerId2" integer not null
  );
create sequence "s_SrmVcPair_id";

alter table "SrmVcPair" add constraint "SrmVcPairFK33" foreign key ("vcServerId1") references "VcServer"("id");
alter table "SrmVcPair" add constraint "SrmVcPairFK34" foreign key ("vcServerId2") references "VcServer"("id");
create unique index "SrmVcPair_vcServerId1" on "SrmVcPair" ("vcServerId1");
create unique index "SrmVcPair_vcServerId2" on "SrmVcPair" ("vcServerId2");

drop view "VmHostHistory";

alter table "VmHistory" alter column "guestFullName" type varchar(1000);

alter table "Provider" add column "partnerId" varchar(128) not null default('');
alter table "Provider" add column "contractNum" varchar(128) not null default('');
alter table "Provider" add column "siteId" varchar(128) not null default('');

create table "VcacServer" (
    "id" integer primary key not null,
    "active" boolean not null,
    "host" varchar(128) not null,
    "userName" varchar(128) not null,
    "password" varchar(128) not null,
    "changed" timestamp not null
  );
create sequence "s_VcacServer_id";
-- indexes on VcacServer
create unique index "VcacServer_host" on "VcacServer" ("host");

create table "VcacMonth" (
    "id" integer primary key not null,
    "vcacServerId" integer not null,
    "year" integer not null,
    "month" integer not null,
    "maxValue" integer not null
  );
create sequence "s_VcacMonth_id";
alter table "VcacMonth" add constraint "VcacMonthFK8" foreign key ("vcacServerId") references "VcacServer"("id");
create unique index "VcacMonth_vcacServerId_year_month" on "VcacMonth" ("vcacServerId","year","month");

alter table "ReportSet" add column "toVsppPortal" boolean not null default(false);

alter table "VcdServer" add column "serialNumber" varchar(128) not null default('');

drop view "MonthlyNewVmCount";
drop table "VmMonth";
drop table "HostMonth";

alter table "Provider" add column "portalUserName" varchar(128) not null default('');
alter table "Provider" add column "portalPassword" varchar(128) not null default('');

update "SchemaInfo" set version = 13, "migrationDone" = false where "migrationDone" = true;
