drop table "ZimbraSample";
delete from "ZimbraServer" where variant = 1;
drop table "ZimbraEdition";
alter table "ZimbraServer" drop column variant;
alter table "ZimbraServer" rename to "HorizonServer";
alter table "HorizonSample" rename column "zimbraServerId" to "horizonServerId";
alter sequence "s_ZimbraServer_id" rename to "s_HorizonServer_id";
-- DesktoneServer
create table "DesktoneServer" (
    "id" integer primary key not null,
    "active" boolean not null,
    "host" varchar(128) not null,
    "userName" varchar(128) not null,
    "password" varchar(128) not null,
    "changed" timestamp not null
  );
create sequence "s_DesktoneServer_id";
-- indexes on DesktoneServer
create unique index "DesktoneServer_host" on "DesktoneServer" ("host");
create table "DesktoneMonth" (
    "id" integer primary key not null,
    "desktoneServerId" integer not null,
    "year" integer not null,
    "month" integer not null,
    "desktopQuota" integer not null,
	"sessionQuota" integer not null
  );
create sequence "s_DesktoneMonth_id";
alter table "DesktoneMonth" add constraint "DesktoneMonthFK7" foreign key ("desktoneServerId") references "DesktoneServer"("id");
create unique index "DesktoneMonth_desktoneServerId_year_month" on "DesktoneMonth" ("desktoneServerId","year","month");

alter table "VmHistory" add column "vmMemRes" integer not null default(0);
alter table "VmHistory" add column "powerState" integer not null default(1);
alter table "VmHistory" add column "vsanKBytes" bigint not null default 0;
alter table "VmHistory" alter column "vsanKBytes" drop default;
alter table "VmHistory" drop column "nicCount";

alter table "VmHistory" add constraint "VmHistoryFK13" foreign key ("hostId") references "Host"("id");
alter table "VmHistory" add constraint "VmHistoryFK14" foreign key ("vmId") references "Vm"("id");

drop table "VmEvent";

drop view "SampleToLicense";
alter table "Vm" drop column "hostId";

drop view "VcopsMonth";

alter table "VcServer" drop column "monitor";

alter table "HostHistory" add column nsx boolean not null default false;
alter table "HostHistory" alter column nsx drop default;
alter table "HostHistory" rename column "dnsName" to "name";

alter table "HostLatest" rename column "dnsName" to name;


CREATE VIEW "VmHistoryToLicense" AS
  SELECT
    v.id          "vmId",
    v."reportExclusionReason",
    vh.id         "vmhId",
    vh."hostId",
    vh."powerState",
    vh.time       "vhTime",
    vh."nextTime" "vhNextTime",
    vh."vmMemSize",
    vh."vmMemRes",
    vh."vsanKBytes",
    vh."cpuCount",
    hh.id         "hhId",
    hh."licenseId",
    hh.time       "hhTime",
    hh."nextTime" "hhNextTime",
    hh.nsx,
    l."licenseCategoryId",
    lc.name       "licenseCategory",
    l.name        "licenseName",
    lc.billable,
    greatest(vh.time, hh.time)                            "intervalStart",
    least(vh."nextTime", hh."nextTime", now()::timestamp) "intervalEnd"
  FROM "Vm" v
    left join "VmHistory"       vh on v.id = vh."vmId"
    left join "Host"            h  on vh."hostId" = h.id
    left join "HostHistory"     hh on h.id = hh."hostId"
    left join "License"         l  on hh."licenseId" = l.id
    left join "LicenseCategory" lc on l."licenseCategoryId" = lc.id
  WHERE (vh.time, vh."nextTime") OVERLAPS (hh.time, hh."nextTime");

CREATE FUNCTION "vm_history"(timestamp, timestamp, license_ids int[])
    RETURNS SETOF "VmHistoryToLicense" AS $BODY$
select * from "VmHistoryToLicense" vhl
    where vhl."reportExclusionReason" is null
    and (vhl."vhTime", vhl."vhNextTime") overlaps ($1, $2)
    and (vhl."hhTime", vhl."hhNextTime") overlaps ($1, $2)
    and (array_length(license_ids, 1) is null) or (vhl."licenseId" = any (license_ids))
$BODY$
    LANGUAGE sql;

CREATE FUNCTION "billable_vm_history"(timestamp, timestamp, license_ids int[], all_power_states boolean)
    RETURNS SETOF "VmHistoryToLicense" AS $BODY$
select * from vm_history($1, $2, $3) vhl
    where vhl.billable = true and (all_power_states = true or vhl."powerState" = 1)
$BODY$
    LANGUAGE sql;

CREATE FUNCTION billing_memory("VmHistoryToLicense")
    RETURNS int AS $BODY$
    select greatest($1."vmMemSize" / 2, $1."vmMemRes")
$BODY$
    LANGUAGE sql IMMUTABLE;

CREATE FUNCTION interval_seconds("VmHistoryToLicense", "startTime" timestamp, "endTime" timestamp)
    RETURNS double precision AS $BODY$
    select extract(epoch from least($1."intervalStart", $3, now()) - greatest($1."intervalEnd", $2))
$BODY$
    LANGUAGE sql IMMUTABLE;

-- Takes a VmHistoryToLicense row, clamps the time and nextTime to the reporting period, and computes and
-- caps the billing memory.
CREATE FUNCTION billing_memory_capped("VmHistoryToLicense", timestamp, timestamp, int)
    RETURNS double precision AS $BODY$
    select (interval_seconds($1, $2, $3)  / 3600) * capped(billing_memory($1), $4)
$BODY$
    LANGUAGE sql IMMUTABLE;

-- Takes a VmHistoryToLicense row, clamps the time and nextTime to the reporting period, and computes and
-- caps the billing memory.
CREATE FUNCTION billing_memory("VmHistoryToLicense", timestamp, timestamp)
    RETURNS double precision AS $BODY$
    select (interval_seconds($1, $2, $3)  / 3600) * billing_memory($1)
$BODY$
    LANGUAGE sql IMMUTABLE;

create function customer_summary(timestamp, timestamp, int, license_ids int[])
  returns table(id int, "customerName" varchar, billable boolean, "licenseCategory" varchar, "licenseName" varchar,
    sbm double precision, sbmc double precision)
  as $BODY$
select c.id, c.name "customerName",
    vhl.billable, vhl."licenseCategory", vhl."licenseName",
    sum(billing_memory(vhl, $1, $2)) sbm,
    sum(billing_memory_capped(vhl, $1, $2, $3)) sbmc
from billable_vm_history($1, $2, license_ids, false) vhl
left join "CustomerVm" cv on cv."vmId" = vhl."vmId"
left join "Customer" c on c.id = cv."customerId"
group by c.id, c.name, vhl.billable, vhl."licenseCategory", vhl."licenseName"
$BODY$
    language sql;

create function vm_counts_by_vc(timestamp, timestamp, license_ids int[])
  returns table("vcServerId" int, count bigint)
  as $BODY$
select vm."vcServerId", count(distinct vm.id)
from billable_vm_history($1, $2, license_ids, false) bvh
join "Vm" vm on vm.id = bvh."vmId"
group by vm."vcServerId"
having count(distinct vm.id) > 0
$BODY$
    language sql;

create function vm_counts_by_vcd(timestamp, timestamp, license_ids int[])
  returns table("vcdServerId" int, count bigint)
  as $BODY$
select vsc."vcdServerId", count(distinct bvh."vmId")
from billable_vm_history($1, $2, license_ids, false) bvh
join "CustomerVm" cv on cv."vmId" = bvh."vmId"
join "VcdServerCustomer" vsc on vsc."customerId" = cv."customerId"
group by vsc."vcdServerId"
having count(distinct bvh."vmId") > 0
$BODY$
    language sql;

alter table "LicenseSet" add column
  "addNewHere" boolean not null default(false);

alter table "User" add column
  "username" varchar(100) not null default('admin');
alter table "User" alter column "username" drop default;

alter table "Customer" add column
  "providerId" integer not null default(1);
alter table "Customer" alter column "providerId" drop default;
alter table "Customer" add constraint "CustomerFKproviderId" foreign key ("providerId") references "Provider"("id");

drop table "VcopsVmCollection";
create table "VcopsVmCollection" (
    "id" integer primary key not null,
    "vmId" integer not null,
    "timestamp" timestamp not null,
    "vcopsLicenseNameId" integer not null
  );

drop table "VcimServer";
drop sequence "s_VcimServer_id";

alter table "VcServer" add column port integer not null default 443;
alter table "VcServer" alter column port drop default;

update "SchemaInfo" set version = 14, "migrationDone" = false where "migrationDone" = true;

alter table "CollectionSettings" drop column "intervalMinutes";

create table "ReportSettings" (
    "id" integer primary key not null,
    "perVmMemCapMb" integer not null,
    "vcopsInPremierPlus" boolean not null
  );
insert into "ReportSettings" values(1, 24 * 1024, true);

alter table "Vm" drop column discovered;

drop index "SrmVcPair_vcServerId2";

create table "VcSrm" (
    "id" integer primary key not null,
    "vcServerId" integer not null,
    "srmHostname" varchar(128) not null
  );
create sequence "s_VcSrm_id";
-- indexes on VcSrm
create unique index "VcSrm_vcServerId" on "VcSrm" ("vcServerId");
alter table "VcSrm" add constraint "VcSrmFK29" foreign key ("vcServerId") references "VcServer"("id");

alter table "VcdServerCustomer" drop column "vdcId";

create table "VcdVdcInfo" (
    "id" integer primary key not null,
    "vcdServerId" integer not null,
    "time" timestamp not null,
    "orgName" varchar(128) not null,
    "orgId" varchar(128) not null,
    "vdcName" varchar(128) not null,
    "vdcId" varchar(128) not null,
    "numVapps" integer not null,
    "numVms" integer not null
  );
create sequence "s_VcdVdcInfo_id";
alter table "VcdVdcInfo" add constraint "VcdVdcInfoFK11" foreign key ("vcdServerId") references "VcdServer"("id");

alter table "Collection" drop column "vcServerId";
alter table "Collection" drop column "ok";
alter table "Collection" add column "errors" varchar(10000);

create table "Bundle" (
    "id" integer not null,
    "name" varchar(128) not null,
    "points" integer not null
  );
create table "Product" (
    "id" integer not null,
    "name" varchar(128) not null,
    "separable" boolean not null
  );
create table "ProductInBundle" (
    "bundleId" integer not null,
    "productId" integer not null
  );
create table "SeparateProduct" (
    "productId" integer not null
  );

insert into "Bundle" values(1, 'Standard',        5);
insert into "Bundle" values(2, 'Premier',         7);
insert into "Bundle" values(3, 'Premier-X',       10);
insert into "Bundle" values(4, 'Premier Plus',    10);
insert into "Bundle" values(5, 'Premier-X Plus',  13);

insert into "Product" values(1, 'vSphere Enterprise',         false);
insert into "Product" values(2, 'vSphere Enterprise Plus',    false);
insert into "Product" values(3, 'NSX',                        true);
insert into "Product" values(4, 'vCenter Operations Manager', true);

insert into "ProductInBundle" values(1, 1); -- bundle ID, product ID

insert into "ProductInBundle" values(2, 2);

insert into "ProductInBundle" values(3, 1);
insert into "ProductInBundle" values(3, 2);
insert into "ProductInBundle" values(3, 3);

insert into "ProductInBundle" values(4, 1);
insert into "ProductInBundle" values(4, 2);
insert into "ProductInBundle" values(4, 4);

insert into "ProductInBundle" values(5, 2);
insert into "ProductInBundle" values(5, 3);
insert into "ProductInBundle" values(5, 4);

alter table "VcopsServer" add column "licenseNameId" integer not null default(1);
alter table "VcopsServer" alter column "licenseNameId" drop default;

create table "NsxServer" (
    "id" integer primary key not null,
    "active" boolean not null,
    "vcServerId" integer not null,
    "host" varchar(128) not null,
    "version" varchar(128) not null,
    "userName" varchar(128) not null,
    "password" varchar(128) not null,
    "changed" timestamp not null
  );
create sequence "s_NsxServer_id";
-- indexes on NsxServer
create unique index "NsxServerHost" on "NsxServer" ("host");

-- indexes on VcopsVmCollection
create index "VcopsVmCollection_timestamp" on "VcopsVmCollection" ("timestamp");
create table "VcopsLicenseName" (
    "id" integer primary key not null,
    "name" varchar(128) not null
  );
create sequence "s_VcopsLicenseName_id";
insert into "VcopsLicenseName" values(nextval('"s_VcopsLicenseName_id"'), 'Not yet discovered'); -- Must be ID 1

alter table "VcopsVmCollection" add constraint "VcopsVmCollectionFK24" foreign key ("vcopsLicenseNameId") references "VcopsLicenseName"("id");
alter table "VcopsServer" add constraint "VcopsServerFK25" foreign key ("licenseNameId") references "VcopsLicenseName"("id");

update "LicenseCategory" set name = 'vCAN' where name = 'VSPP';

create view "AllHostnames" as
      select host from "DesktoneServer"
union select host from "HorizonServer"
union select host from "LdapServer"
union select host from "NsxServer"
union select host from "VcacServer"
union select host from "VcdServer"
union select host from "VcopsServer"
union select host from "VcServer";
