-- This script is to prepare the schema for migration from UM 3.4.0 to UM 3.5.0

--Mark migration started
UPDATE "SchemaInfo" SET version = 15, "migrationDone" = false;

--Cleanup functions, views, tables and sequences
DROP FUNCTION IF EXISTS vm_history(timestamp without time zone,timestamp without time zone,integer[]);
DROP FUNCTION IF EXISTS billable_vm_history(timestamp without time zone,timestamp without time zone,integer[],boolean);
DROP FUNCTION IF EXISTS billing_memory("VmHistoryToLicense");
DROP FUNCTION IF EXISTS billing_memory_capped("VmHistoryToLicense",timestamp without time zone,timestamp without time zone,integer);
DROP FUNCTION IF EXISTS billing_memory("VmHistoryToLicense",timestamp without time zone,timestamp without time zone);
DROP FUNCTION IF EXISTS customer_summary(timestamp, timestamp, int, license_ids int[]);
DROP FUNCTION IF EXISTS interval_seconds("VmHistoryToLicense",timestamp without time zone,timestamp without time zone);
DROP FUNCTION IF EXISTS vm_counts_by_vc(timestamp, timestamp, license_ids int[]);
DROP FUNCTION IF EXISTS vm_counts_by_vcd(timestamp, timestamp, license_ids int[]);

DROP VIEW IF EXISTS "AllHostnames";
DROP VIEW IF EXISTS "HostLatest";
DROP VIEW IF EXISTS "LicenseHostCount";
DROP VIEW IF EXISTS "HostLatestHistory";
DROP VIEW IF EXISTS "SampleToLicense";
DROP VIEW IF EXISTS "VcopsMonth";
DROP VIEW IF EXISTS "VmHistoryToLicense";
DROP VIEW IF EXISTS "VmLatestHistoryId";

DROP TABLE IF EXISTS "HorizonSample";
DROP TABLE IF EXISTS "HorizonServer";
DROP TABLE IF EXISTS "Sample";
DROP TABLE IF EXISTS "VcimServer";
DROP TABLE IF EXISTS "VmEvent";
DROP TABLE IF EXISTS "ZimbraEdition";
DROP TABLE IF EXISTS "ZimbraServer";
DROP TABLE IF EXISTS "ZimbraSample";

DROP SEQUENCE IF EXISTS "s_AggSample_id";
DROP SEQUENCE IF EXISTS "s_HorizonSample_id";
DROP SEQUENCE IF EXISTS "s_HorizonServer_id";
DROP SEQUENCE IF EXISTS "s_HostMonth_id";
DROP SEQUENCE IF EXISTS "s_ProtectedVmMonth_id";
DROP SEQUENCE if exists "s_Sample_id";
DROP SEQUENCE IF EXISTS "s_SrmServer_id";
DROP SEQUENCE IF EXISTS "s_VcimServer_id";
DROP SEQUENCE IF EXISTS "s_VmMonth_id";
DROP SEQUENCE IF EXISTS "s_VmEvent_id";
DROP SEQUENCE IF EXISTS "s_ZimbraEdition_id";
DROP SEQUENCE IF EXISTS "s_ZimbraSample_id";
DROP SEQUENCE IF EXISTS "s_ZimbraServer_id";