#!/bin/bash

# This script manage JMX connection to Tomcat server. Please note that JMX connection will be
#  open to port 'jmxport' and will be unsecure: no ssl, no authentication.
# If you need secure connection please refer to https://tomcat.apache.org/tomcat-8.0-doc/monitoring.html#Enabling_JMX_Remote
# and change this script acordingly

# JMX PORT. Please chnage JMX port value if you don't like it.
jmxport=9003

echo "Configuring JMX"
source `dirname $0`/umsetenv.sh

enablejmx() {
   echo "Enabling JMX"

   # Clean up JMX settings
   sed -i '/com.sun.management.jmxremote/d' $TOMCAT_HOME/conf/tomcat.conf

   hostip=`/sbin/ifconfig | /usr/bin/grep 'inet addr:'| /usr/bin/grep -v '127.0.0.1' | /usr/bin/cut -d: -f2 | /usr/bin/awk '{ print $1}'`

   # Write the new LMX setting. If you need to change ssl and authentication settings, please update the next line.
   echo "CATALINA_OPTS=-Dcom.sun.management.jmxremote -Dcom.sun.management.jmxremote.port=$jmxport -Djava.rmi.server.hostname=$hostip -Dcom.sun.management.jmxremote.ssl=false -Dcom.sun.management.jmxremote.authenticate=false" >> $TOMCAT_HOME/conf/tomcat.conf

   service tomcat restart
}

disablejmx() {
   echo "Disabling JMX"

   # Clean up JMX settings
   sed -i '/com.sun.management.jmxremote/d' $TOMCAT_HOME/conf/tomcat.conf

   service tomcat restart
}

status() {
   portres=`netstat -lnptu | grep $jmxport`
   if [[ -z "$portres" ]]
   then
      echo "vCloud Usage Meter JMX is not running"
   else
      echo "vCloud Usage Meter JMX is running"
   fi
}


case "$1" in
        enable)
                echo 'This script is deprecated because it enabled JMX on the Tomcat server and this poses security risks. Do you want to continue(y/n)?'
                read shouldContinue

                if [ "$shouldContinue" == "n" ]; then
                    echo Exiting
                    exit
                fi

                enablejmx
                ;;
        disable)
                disablejmx
                ;;
        status)
                status
                ;;
        *)
                echo $"Usage: $0 {enable|disable|status}"
                exit 1
                ;;
esac
