/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.win32;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.hyperic.sigar.SigarLoader;
import org.hyperic.sigar.win32.LocaleInfo;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Win32;
import org.hyperic.sigar.win32.Win32Exception;

public class Pdh
extends Win32 {
    public static final int VALID_DATA = 0;
    public static final int NO_INSTANCE = -2147481647;
    public static final int NO_COUNTER = -1073738823;
    public static final int NO_OBJECT = -1073738824;
    public static final int NO_MACHINE = -2147481648;
    public static final int BAD_COUNTERNAME = -1073738816;
    public static final String PERFLIB_KEY = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Perflib";
    public static final long PERF_TYPE_NUMBER = 0L;
    public static final long PERF_TYPE_COUNTER = 1024L;
    public static final long PERF_TYPE_TEXT = 2048L;
    public static final long PERF_TYPE_ZERO = 3072L;
    private long query = Pdh.pdhOpenQuery();
    private String hostname = null;
    private static Map counters = null;
    private static final String DELIM = "\\";

    public Pdh() throws Win32Exception {
    }

    public Pdh(String hostName) throws Win32Exception {
        this();
        this.hostname = hostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void close() throws Win32Exception {
        if (this.query != -1L) {
            Pdh.pdhCloseQuery(this.query);
            this.query = -1L;
        }
    }

    public static void enableTranslation() throws Win32Exception {
        if (counters != null) {
            return;
        }
        if (LocaleInfo.isEnglish()) {
            return;
        }
        counters = Pdh.getEnglishPerflibCounterMap();
    }

    public static Map getEnglishPerflibCounterMap() throws Win32Exception {
        LocaleInfo locale = new LocaleInfo(9);
        return Pdh.getPerflibCounterMap(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getPerflibCounterMap(LocaleInfo locale) throws Win32Exception {
        String path = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Perflib\\" + locale.getPerflibLangId();
        RegistryKey key = RegistryKey.LocalMachine.openSubKey(path);
        PerflibCounterMap counters = new PerflibCounterMap();
        try {
            key.getMultiStringValue("Counter", counters);
        }
        finally {
            key.close();
        }
        return counters.map;
    }

    public static String getCounterName(int index) throws Win32Exception {
        String name = Pdh.pdhLookupPerfName(index).trim();
        return name;
    }

    public double getSingleValue(String path) throws Win32Exception {
        return this.getRawValue(path);
    }

    public double getRawValue(String path) throws Win32Exception {
        return this.getValue(path, false);
    }

    public double getFormattedValue(String path) throws Win32Exception {
        return this.getValue(path, true);
    }

    private static int[] getCounterIndex(String englishName) {
        if (counters == null) {
            return null;
        }
        return (int[])counters.get(englishName.toLowerCase());
    }

    private static String getCounterName(String englishName) throws Win32Exception {
        int[] ix = Pdh.getCounterIndex(englishName);
        if (ix == null) {
            return englishName;
        }
        String name = Pdh.getCounterName(ix[0]);
        return name;
    }

    public static String translate(String path) throws Win32Exception {
        if (counters == null) {
            return path;
        }
        StringBuffer trans = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(path, DELIM);
        int num = tok.countTokens();
        if (num == 3) {
            String hostname = tok.nextToken();
            trans.append(DELIM).append(DELIM).append(hostname);
        }
        String object = tok.nextToken();
        String instance = null;
        int ix = object.indexOf(40);
        if (ix != -1) {
            instance = object.substring(ix);
            object = object.substring(0, ix);
        }
        trans.append(DELIM).append(Pdh.getCounterName(object));
        if (instance != null) {
            trans.append(instance);
        }
        String counter = tok.nextToken();
        trans.append(DELIM);
        int[] cix = Pdh.getCounterIndex(counter);
        if (cix != null) {
            if (cix.length == 1) {
                counter = Pdh.getCounterName(cix[0]);
            } else {
                for (int i = 0; i < cix.length; ++i) {
                    String name = Pdh.getCounterName(cix[i]);
                    if (Pdh.validate(trans + name) != 0) continue;
                    counter = name;
                    break;
                }
            }
        }
        trans.append(counter);
        return trans.toString();
    }

    private long addPdhCounter(String path, boolean format) throws Win32Exception {
        long counter;
        try {
            counter = Pdh.pdhAddCounter(this.query, Pdh.translate(path));
        }
        catch (Win32Exception e) {
            counter = Pdh.pdhAddCounter(this.query, Pdh.translate(path + "/sec"));
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getValue(String path, boolean format) throws Win32Exception {
        if (this.hostname != null) {
            Pdh.pdhConnectMachine(this.hostname);
        }
        long counter = this.addPdhCounter(path, format);
        try {
            double d = Pdh.pdhGetValue(this.query, counter, format);
            return d;
        }
        finally {
            Pdh.pdhRemoveCounter(counter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription(String path) throws Win32Exception {
        long counter = Pdh.pdhAddCounter(this.query, Pdh.translate(path));
        try {
            String string = Pdh.pdhGetDescription(counter);
            return string;
        }
        finally {
            Pdh.pdhRemoveCounter(counter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCounterType(String path) throws Win32Exception {
        long counter = Pdh.pdhAddCounter(this.query, Pdh.translate(path));
        try {
            long l = Pdh.pdhGetCounterType(counter);
            return l;
        }
        finally {
            Pdh.pdhRemoveCounter(counter);
        }
    }

    public static String[] getInstances(String path) throws Win32Exception {
        String[] instances = Pdh.pdhGetInstances(Pdh.getCounterName(path));
        HashMap<String, InstanceIndex> names = new HashMap<String, InstanceIndex>(instances.length);
        for (int i = 0; i < instances.length; ++i) {
            InstanceIndex ix = (InstanceIndex)names.get(instances[i]);
            if (ix == null) {
                ix = new InstanceIndex();
                names.put(instances[i], ix);
                continue;
            }
            ++ix.index;
            instances[i] = instances[i] + "#" + ix.index;
        }
        return instances;
    }

    public static String[] getKeys(String path) throws Win32Exception {
        return Pdh.pdhGetKeys(Pdh.getCounterName(path));
    }

    public static String[] getObjects() throws Win32Exception {
        return Pdh.pdhGetObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getFormattedValues(Collection paths) throws Win32Exception {
        String path;
        if (this.hostname != null) {
            Pdh.pdhConnectMachine(this.hostname);
        }
        HashMap<String, Double> res = new HashMap<String, Double>();
        HashMap<String, Long> counters = new HashMap<String, Long>();
        Iterator pathsIt = paths.iterator();
        while (pathsIt.hasNext()) {
            path = (String)pathsIt.next();
            try {
                counters.put(path, new Long(Pdh.pdhAddCounter(this.query, Pdh.translate(path))));
            }
            catch (Win32Exception ex) {}
        }
        if (counters.size() > 0) {
            try {
                Pdh.pdhCollectQueryDataOverSecond(this.query);
                pathsIt = paths.iterator();
                while (pathsIt.hasNext()) {
                    try {
                        path = (String)pathsIt.next();
                        Long c = (Long)counters.get(path);
                        if (c == null) continue;
                        double val = Pdh.pdhGetFormattedValue(c);
                        res.put(path, new Double(val));
                    }
                    catch (Exception ex) {}
                }
            }
            finally {
                Iterator countersIt = counters.values().iterator();
                while (countersIt.hasNext()) {
                    try {
                        Long counter = (Long)countersIt.next();
                        Pdh.pdhRemoveCounter(counter);
                    }
                    catch (Win32Exception ex) {}
                }
            }
        }
        return res;
    }

    public static final native int validate(String var0);

    private static final native void pdhConnectMachine(String var0) throws Win32Exception;

    private static final native long pdhOpenQuery() throws Win32Exception;

    private static final native void pdhCloseQuery(long var0) throws Win32Exception;

    private static final native long pdhAddCounter(long var0, String var2) throws Win32Exception;

    private static final native void pdhRemoveCounter(long var0) throws Win32Exception;

    private static final native double pdhGetValue(long var0, long var2, boolean var4) throws Win32Exception;

    private static final native String pdhGetDescription(long var0) throws Win32Exception;

    private static final native long pdhGetCounterType(long var0) throws Win32Exception;

    private static final native String[] pdhGetInstances(String var0) throws Win32Exception;

    private static final native String[] pdhGetKeys(String var0) throws Win32Exception;

    private static final native String[] pdhGetObjects() throws Win32Exception;

    private static final native String pdhLookupPerfName(int var0) throws Win32Exception;

    private static final native int pdhLookupPerfIndex(String var0) throws Win32Exception;

    private static final native void pdhCollectQueryDataOverSecond(long var0) throws Win32Exception;

    private static final native double pdhGetFormattedValue(long var0) throws Win32Exception;

    public static void main(String[] args) {
        Pdh pdh = null;
        String objectName = null;
        String partialName = null;
        boolean showValues = false;
        boolean showInstances = false;
        boolean showKeys = false;
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                int idx;
                if (args[i].equals("-h") || args[i].equals("-help") || args[i].equals("--help")) {
                    System.out.println("Usage: Pdh [OPTION]");
                    System.out.println("Show information from the Windows PDH");
                    System.out.println("");
                    System.out.println("    --object=NAME    only print info on this object");
                    System.out.println("    --contains=NAME  only print info on objects that");
                    System.out.println("                     contain this substring");
                    System.out.println("-i, --instance       show instances [default=no]");
                    System.out.println("-k, --keys           show keys [default=no]");
                    System.out.println("-v, --values         include key values [default=no]");
                    System.out.println("-h, --help           display help and exit");
                    return;
                }
                if (args[i].equals("-v") || args[i].equals("--values")) {
                    showKeys = true;
                    showValues = true;
                    continue;
                }
                if (args[i].equals("-i") || args[i].equals("--instances")) {
                    showInstances = true;
                    continue;
                }
                if (args[i].equals("-k") || args[i].equals("--keys")) {
                    showKeys = true;
                    continue;
                }
                if (args[i].startsWith("--contains=")) {
                    idx = args[i].indexOf("=");
                    partialName = args[i].substring(idx + 1);
                    continue;
                }
                if (args[i].startsWith("--object=")) {
                    idx = args[i].indexOf("=");
                    objectName = args[i].substring(idx + 1);
                    continue;
                }
                System.out.println("Unknown option: " + args[i]);
                System.out.println("Use --help for usage information");
                return;
            }
        }
        try {
            String[] objects;
            pdh = new Pdh();
            if (partialName != null) {
                ArrayList<String> matching = new ArrayList<String>();
                String[] allObjects = Pdh.getObjects();
                for (int i = 0; i < allObjects.length; ++i) {
                    if (allObjects[i].toUpperCase().indexOf(partialName.toUpperCase()) == -1) continue;
                    matching.add(allObjects[i]);
                }
                objects = matching.toArray(new String[0]);
            } else {
                objects = objectName != null ? new String[]{objectName} : Pdh.getObjects();
            }
            for (int o = 0; o < objects.length; ++o) {
                String[] keys;
                System.out.println(objects[o]);
                try {
                    keys = Pdh.getKeys(objects[o]);
                }
                catch (Win32Exception e) {
                    System.err.println("Unable to get keys for object=" + objects[o] + " Reason: " + e.getMessage());
                    continue;
                }
                int pad = Pdh.getLongestKey(keys);
                String[] instances = Pdh.getInstances(objects[o]);
                if (instances.length == 0) {
                    if (!showKeys) continue;
                    for (int k = 0; k < keys.length; ++k) {
                        if (showValues) {
                            double val;
                            String query = DELIM + objects[o] + DELIM + keys[k];
                            try {
                                val = pdh.getRawValue(query);
                            }
                            catch (Win32Exception e) {
                                System.err.println("Unable to get value for  key=" + query + " Reason: " + e.getMessage());
                                continue;
                            }
                            String out = Pdh.pad(keys[k], pad, ' ');
                            System.out.println("  " + out + " = " + val);
                            continue;
                        }
                        System.out.println("  " + keys[k]);
                    }
                    continue;
                }
                if (!showInstances) continue;
                for (int i = 0; i < instances.length; ++i) {
                    System.out.println("  " + instances[i]);
                    if (!showKeys) continue;
                    for (int k = 0; k < keys.length; ++k) {
                        if (showValues) {
                            double val;
                            String query = DELIM + objects[o] + "(" + instances[i] + ")" + DELIM + keys[k];
                            try {
                                val = pdh.getRawValue(query);
                            }
                            catch (Win32Exception e) {
                                System.err.println("Unable to get value for key=" + query + " Reason: " + e.getMessage());
                                continue;
                            }
                            String out = Pdh.pad(keys[k], pad, ' ');
                            System.out.println("    " + out + " = " + val);
                            continue;
                        }
                        System.out.println("    " + keys[k]);
                    }
                }
            }
            pdh.close();
        }
        catch (Win32Exception e) {
            System.err.println("Unable to dump PDH data: " + e.getMessage());
            return;
        }
    }

    private static String pad(String value, int length, char ch) {
        StringBuffer padder = new StringBuffer(value);
        if (value.length() < length) {
            for (int i = 0; i < length - value.length(); ++i) {
                padder.append(ch);
            }
        }
        return padder.toString();
    }

    private static int getLongestKey(String[] keys) {
        int longest = 0;
        for (int i = 0; i < keys.length; ++i) {
            int len = keys[i].length();
            if (len <= longest) continue;
            longest = len;
        }
        return longest;
    }

    static {
        String prop = "sigar.pdh.enableTranslation";
        if (SigarLoader.IS_WIN32 && !"false".equals(System.getProperty("sigar.pdh.enableTranslation"))) {
            try {
                Pdh.enableTranslation();
            }
            catch (Exception e) {
                System.err.println("sigar.pdh.enableTranslation: " + e.getMessage());
            }
        }
    }

    private static final class InstanceIndex {
        long index = 0L;

        private InstanceIndex() {
        }
    }

    private static class PerflibCounterMap
    extends ArrayList {
        private Map map = new HashMap();
        private String index = null;

        private PerflibCounterMap() {
        }

        public boolean add(Object o) {
            if (this.index == null) {
                this.index = (String)o;
                return true;
            }
            String name = ((String)o).trim().toLowerCase();
            int[] ix = (int[])this.map.get(name);
            if (ix == null) {
                ix = new int[1];
            } else {
                int[] cur = ix;
                ix = new int[cur.length + 1];
                System.arraycopy(cur, 0, ix, 1, cur.length);
            }
            ix[0] = Integer.parseInt(this.index);
            this.map.put(name, ix);
            this.index = null;
            return true;
        }
    }
}

