/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentConfigException;
import org.hyperic.hq.agent.KeystoreCredentialsManager;
import org.hyperic.util.security.KeystoreConfig;

public class AgentKeystoreConfig
extends KeystoreConfig {
    private static final String DEFAULT_SSL_KEYSTORE_ALIAS = "hq";
    private static final String SSL_KEYSTORE_ALIAS = "agent.keystore.alias";
    private final Log log = LogFactory.getLog(AgentKeystoreConfig.class);
    private boolean acceptUnverifiedCertForPlugins;
    private char[] userDefaultPassword;

    public AgentKeystoreConfig() {
        String propFile = System.getProperty("agent.propFile", AgentConfig.DEFAULT_PROPFILE);
        try {
            AgentConfig cfg = AgentConfig.newInstance(propFile);
            this.init(cfg.getBootProperties());
        }
        catch (IOException exc) {
            this.log.error((Object)("Error: " + exc), (Throwable)exc);
            return;
        }
        catch (AgentConfigException exc) {
            this.log.error((Object)("Agent properties error: " + exc.getMessage()), (Throwable)exc);
            return;
        }
    }

    public AgentKeystoreConfig(AgentConfig cfg) {
        this(cfg.getBootProperties());
    }

    public AgentKeystoreConfig(Properties bootProperties) {
        this.init(bootProperties);
    }

    private void init(Properties bootProperties) {
        this.userDefaultPassword = bootProperties.getProperty("agent.keystore.password").toCharArray();
        super.setFilePath(bootProperties.getProperty("agent.keystore.path"));
        super.setAlias(bootProperties.getProperty(SSL_KEYSTORE_ALIAS, DEFAULT_SSL_KEYSTORE_ALIAS));
        super.setClientCertificateAlias(bootProperties.getProperty("agent.keystore.client.certificate.alias", "agent"));
        super.setServerCertificateAlias(bootProperties.getProperty("agent.keystore.server.certificate.alias", "epops_server"));
        super.setHqDefault(AgentConfig.PROP_KEYSTORE_PATH[1].equals(this.getFilePath()));
        String prop = bootProperties.getProperty("accept.unverified.certificates");
        this.acceptUnverifiedCertForPlugins = Boolean.parseBoolean(prop);
        super.setKeyCN("EP Ops Agent");
    }

    public char[] getFilePassword() throws IOException {
        char[] pass = null;
        String filePath = this.getFilePath();
        if (filePath != null) {
            pass = KeystoreCredentialsManager.getInstance().getKeystorePassword(new File(filePath), this.userDefaultPassword);
        }
        return pass;
    }

    public boolean isAcceptUnverifiedCert() {
        return this.acceptUnverifiedCertForPlugins;
    }
}

