/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.hyperic.hq.plugin.system.NetConnectionData;
import org.hyperic.sigar.NetConnection;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;

public class NetstatData {
    public static final String LABEL_PROTO = "Proto";
    public static final String LABEL_LADDR = "Local Address";
    public static final String LABEL_RADDR = "Foreign Address";
    public static final String LABEL_STATE = "State";
    private boolean _isNumericHosts = true;
    private boolean _isNumericPorts = false;
    private boolean _wantPid = false;
    private int _flags = 241;
    private List _connections;

    public void populate(SigarProxy sigar) throws SigarException {
        this._connections = new ArrayList();
        NetConnection[] connections = sigar.getNetConnectionList(this._flags);
        for (int i = 0; i < connections.length; ++i) {
            NetConnectionData data = new NetConnectionData(sigar, connections[i], this._isNumericHosts, this._isNumericPorts);
            if (this._wantPid) {
                data.lookupProcessInfo(sigar);
            }
            this._connections.add(data);
        }
    }

    public List getConnections() {
        return this._connections;
    }

    public void setIsNumeric(boolean isNumeric) {
        this._isNumericHosts = this._isNumericPorts = isNumeric;
    }

    public void setIsNumericHosts(boolean isNumeric) {
        this._isNumericHosts = isNumeric;
    }

    public void setIsNumericPorts(boolean isNumeric) {
        this._isNumericPorts = isNumeric;
    }

    public boolean wantPid() {
        return this._wantPid;
    }

    public void setWantPid(boolean wantPid) {
        this._wantPid = wantPid;
    }

    public int getFlags() {
        return this._flags;
    }

    public void setFlags(int flags) {
        this._flags = flags;
    }

    public void setFlags(String flags) {
        this.setFlags(new String[]{flags});
    }

    public void setFlags(String[] args) {
        int proto_flags = 0;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            int j = 0;
            block12: while (j < arg.length()) {
                switch (arg.charAt(j++)) {
                    case '-': {
                        continue block12;
                    }
                    case 'l': {
                        this._flags &= 0xFFFFFFFE;
                        this._flags |= 2;
                        continue block12;
                    }
                    case 'a': {
                        this._flags |= 3;
                        continue block12;
                    }
                    case 'n': {
                        this.setIsNumeric(true);
                        continue block12;
                    }
                    case 'p': {
                        this._wantPid = true;
                        continue block12;
                    }
                    case 't': {
                        proto_flags |= 0x10;
                        continue block12;
                    }
                    case 'u': {
                        proto_flags |= 0x20;
                        continue block12;
                    }
                    case 'w': {
                        proto_flags |= 0x40;
                        continue block12;
                    }
                    case 'x': {
                        proto_flags |= 0x80;
                        continue block12;
                    }
                }
            }
        }
        if (proto_flags != 0) {
            this._flags &= 0xFFFFFF0F;
            this._flags |= proto_flags;
        }
    }

    public void print(PrintStream out) {
        String header = "Proto\tLocal Address\tForeign Address\tState";
        out.println("Proto\tLocal Address\tForeign Address\tState");
        List connections = this.getConnections();
        for (int i = 0; i < connections.size(); ++i) {
            NetConnectionData data = (NetConnectionData)connections.get(i);
            String conn = data.getProtocol() + "\t" + data.getFormattedLocalAddress() + "\t" + data.getFormattedRemoteAddress() + "\t" + data.getFormattedState() + "\t" + data.getFormattedProcessName();
            out.println(conn);
        }
    }

    public static void main(String[] args) throws Exception {
        Sigar sigar = new Sigar();
        NetstatData data = new NetstatData();
        if (args.length != 0) {
            data.setFlags(args);
        }
        data.populate((SigarProxy)sigar);
        data.print(System.out);
        sigar.close();
    }
}

