/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentConfigException;

public class AgentStartupCallback {
    private final Log _log = LogFactory.getLog(AgentStartupCallback.class);
    private Socket _startupSock;

    public AgentStartupCallback(AgentConfig config) throws AgentConfigException, IOException {
        int sPort = config.getNotifyUpPort();
        if (sPort != -1) {
            this.connectToPort(sPort);
        } else {
            this._log.debug((Object)"Agent startup callback is disabled (port not set)");
            this._startupSock = null;
        }
    }

    private void connectToPort(int sPort) throws IOException {
        int minute = 60000;
        int maxAttemptGap = 1800000;
        IOException exceptionToThrow = null;
        for (int nextAttemptGap = 30000; nextAttemptGap <= maxAttemptGap; nextAttemptGap *= 2) {
            try {
                this._startupSock = new Socket("localhost", sPort);
                return;
            }
            catch (IOException exc) {
                exceptionToThrow = exc;
                this._log.error((Object)("Failed to connect to startup port (" + sPort + ")"), (Throwable)exc);
                try {
                    this._log.info((Object)("Waiting " + (double)nextAttemptGap / 60000.0 + " minutes before retrying connection to Server port."));
                    Thread.sleep(nextAttemptGap);
                }
                catch (InterruptedException e) {
                    this._log.error((Object)("Failed to wait for next connection to startup port (" + sPort + ")"), (Throwable)e);
                }
                continue;
            }
        }
        throw new IOException("Failed to connect to startup port (" + sPort + "): " + exceptionToThrow.getMessage());
    }

    public void onAgentStartup(boolean succeeded) {
        if (succeeded) {
            this.writeStartupState(1);
        } else {
            this.writeStartupState(0);
        }
    }

    protected void finalize() throws Throwable {
        if (this._startupSock != null) {
            try {
                this._startupSock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStartupState(int state) {
        if (this._startupSock == null) {
            this._log.debug((Object)"Agent startup callback is disabled (socket is null)");
            return;
        }
        try {
            this._log.debug((Object)("Writing to startup socket the state: " + state));
            DataOutputStream dOs = new DataOutputStream(this._startupSock.getOutputStream());
            dOs.writeInt(state);
            dOs.flush();
        }
        catch (IOException exc) {
            this._log.error((Object)("Error writing startup state to startup port: " + exc.getMessage()));
        }
        finally {
            try {
                this._startupSock.close();
            }
            catch (IOException iOException) {}
        }
    }
}

