/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.server;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hyperic.hq.agent.AgentCommand;
import org.hyperic.hq.agent.AgentConnectionException;
import org.hyperic.hq.agent.AgentRemoteValue;

public abstract class AgentServerConnection {
    public abstract InputStream getInputStream() throws AgentConnectionException;

    public abstract OutputStream getOutputStream() throws AgentConnectionException;

    public abstract void close();

    public AgentCommand readCommand() throws AgentConnectionException, EOFException {
        AgentRemoteValue cmdArg;
        String cmd;
        int cmdVersion;
        int agentVersion;
        try {
            DataInputStream dIs = new DataInputStream(this.getInputStream());
            agentVersion = dIs.readInt();
            cmdVersion = dIs.readInt();
            cmd = dIs.readUTF();
            cmdArg = AgentRemoteValue.fromStream((DataInput)dIs);
        }
        catch (EOFException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new AgentConnectionException("Unable to read command: " + exc.getMessage(), (Exception)exc);
        }
        return new AgentCommand(agentVersion, cmdVersion, cmd, cmdArg);
    }

    public void sendErrorResponse(String msg) throws AgentConnectionException {
        try {
            DataOutputStream dOs = new DataOutputStream(this.getOutputStream());
            dOs.writeInt(1);
            dOs.writeUTF(msg);
        }
        catch (IOException exc) {
            throw new AgentConnectionException("Unable to send error: " + exc.getMessage());
        }
    }

    public void sendSuccessResponse(AgentRemoteValue res) throws AgentConnectionException {
        try {
            DataOutputStream dOs = new DataOutputStream(this.getOutputStream());
            dOs.writeInt(0);
            res.toStream((DataOutput)dOs);
        }
        catch (IOException exc) {
            throw new AgentConnectionException("Unable to send response: " + exc.getMessage(), (Exception)exc);
        }
    }
}

