/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.roo.support.ant;

import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AntPatchStringMatcher {
    private final char[] patArr;
    private final char[] strArr;
    private int patIdxStart = 0;
    private int patIdxEnd;
    private int strIdxStart = 0;
    private int strIdxEnd;
    private char ch;
    private final Map<String, String> uriTemplateVariables;

    AntPatchStringMatcher(String pattern, String str, Map<String, String> uriTemplateVariables) {
        this.patArr = pattern.toCharArray();
        this.strArr = str.toCharArray();
        this.uriTemplateVariables = uriTemplateVariables;
        this.patIdxEnd = this.patArr.length - 1;
        this.strIdxEnd = this.strArr.length - 1;
    }

    private void addTemplateVariable(int curlyIdxStart, int curlyIdxEnd, int valIdxStart, int valIdxEnd) {
        if (this.uriTemplateVariables != null) {
            String varName = new String(this.patArr, curlyIdxStart + 1, curlyIdxEnd - curlyIdxStart - 1);
            String varValue = new String(this.strArr, valIdxStart, valIdxEnd - valIdxStart + 1);
            this.uriTemplateVariables.put(varName, varValue);
        }
    }

    boolean matchStrings() {
        if (this.shortcutPossible()) {
            return this.doShortcut();
        }
        if (this.patternContainsOnlyStar()) {
            return true;
        }
        if (this.patternContainsOneTemplateVariable()) {
            this.addTemplateVariable(0, this.patIdxEnd, 0, this.strIdxEnd);
            return true;
        }
        if (!this.matchBeforeFirstStarOrCurly()) {
            return false;
        }
        if (this.allCharsUsed()) {
            return this.onlyStarsLeft();
        }
        if (!this.matchAfterLastStarOrCurly()) {
            return false;
        }
        if (this.allCharsUsed()) {
            return this.onlyStarsLeft();
        }
        while (this.patIdxStart != this.patIdxEnd && this.strIdxStart <= this.strIdxEnd) {
            int patIdxTmp;
            if (this.patArr[this.patIdxStart] == '{') {
                patIdxTmp = this.findClosingCurly();
                this.addTemplateVariable(this.patIdxStart, patIdxTmp, this.strIdxStart, this.strIdxEnd);
                this.patIdxStart = patIdxTmp + 1;
                this.strIdxStart = this.strIdxEnd + 1;
                continue;
            }
            patIdxTmp = this.findNextStarOrCurly();
            if (this.consecutiveStars(patIdxTmp)) continue;
            int patLength = patIdxTmp - this.patIdxStart - 1;
            int strLength = this.strIdxEnd - this.strIdxStart + 1;
            int foundIdx = -1;
            block1: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    this.ch = this.patArr[this.patIdxStart + j + 1];
                    if (this.ch != '?' && this.ch != this.strArr[this.strIdxStart + i + j]) continue block1;
                }
                foundIdx = this.strIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            this.patIdxStart = patIdxTmp;
            this.strIdxStart = foundIdx + patLength;
        }
        return this.onlyStarsLeft();
    }

    private boolean consecutiveStars(int patIdxTmp) {
        if (patIdxTmp == this.patIdxStart + 1 && this.patArr[this.patIdxStart] == '*' && this.patArr[patIdxTmp] == '*') {
            ++this.patIdxStart;
            return true;
        }
        return false;
    }

    private int findNextStarOrCurly() {
        for (int i = this.patIdxStart + 1; i <= this.patIdxEnd; ++i) {
            if (this.patArr[i] != '*' && this.patArr[i] != '{') continue;
            return i;
        }
        return -1;
    }

    private int findClosingCurly() {
        for (int i = this.patIdxStart + 1; i <= this.patIdxEnd; ++i) {
            if (this.patArr[i] != '}') continue;
            return i;
        }
        return -1;
    }

    private boolean onlyStarsLeft() {
        for (int i = this.patIdxStart; i <= this.patIdxEnd; ++i) {
            if (this.patArr[i] == '*') continue;
            return false;
        }
        return true;
    }

    private boolean allCharsUsed() {
        return this.strIdxStart > this.strIdxEnd;
    }

    private boolean shortcutPossible() {
        for (char ch : this.patArr) {
            if (ch != '*' && ch != '{' && ch != '}') continue;
            return false;
        }
        return true;
    }

    private boolean doShortcut() {
        if (this.patIdxEnd != this.strIdxEnd) {
            return false;
        }
        for (int i = 0; i <= this.patIdxEnd; ++i) {
            this.ch = this.patArr[i];
            if (this.ch == '?' || this.ch == this.strArr[i]) continue;
            return false;
        }
        return true;
    }

    private boolean patternContainsOnlyStar() {
        return this.patIdxEnd == 0 && this.patArr[0] == '*';
    }

    private boolean patternContainsOneTemplateVariable() {
        if (this.patIdxEnd >= 2 && this.patArr[0] == '{' && this.patArr[this.patIdxEnd] == '}') {
            for (int i = 1; i < this.patIdxEnd; ++i) {
                if (this.patArr[i] != '}') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean matchBeforeFirstStarOrCurly() {
        while ((this.ch = this.patArr[this.patIdxStart]) != '*' && this.ch != '{' && this.strIdxStart <= this.strIdxEnd) {
            if (this.ch != '?' && this.ch != this.strArr[this.strIdxStart]) {
                return false;
            }
            ++this.patIdxStart;
            ++this.strIdxStart;
        }
        return true;
    }

    private boolean matchAfterLastStarOrCurly() {
        while ((this.ch = this.patArr[this.patIdxEnd]) != '*' && this.ch != '}' && this.strIdxStart <= this.strIdxEnd) {
            if (this.ch != '?' && this.ch != this.strArr[this.strIdxEnd]) {
                return false;
            }
            --this.patIdxEnd;
            --this.strIdxEnd;
        }
        return true;
    }
}

