/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.livedata.agent.server;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.appdef.shared.AppdefEntityID;
import org.hyperic.hq.livedata.agent.client.LiveDataCommandsClient;
import org.hyperic.hq.livedata.agent.commands.LiveData_args;
import org.hyperic.hq.livedata.agent.commands.LiveData_result;
import org.hyperic.hq.livedata.shared.LiveDataResult;
import org.hyperic.hq.product.LiveDataPluginManager;
import org.hyperic.util.config.ConfigResponse;

public class LiveDataCommandsService
implements LiveDataCommandsClient {
    private static final Log _log = LogFactory.getLog(LiveDataCommandsService.class);
    private final LiveDataPluginManager _manager;

    public LiveDataCommandsService(LiveDataPluginManager manager) {
        this._manager = manager;
    }

    public LiveDataResult getData(AppdefEntityID id, String type, String command, ConfigResponse config) {
        try {
            String xml = this._manager.getData(type, command, config);
            return new LiveDataResult(id, xml);
        }
        catch (Exception e) {
            return new LiveDataResult(id, (Throwable)e, e.getMessage());
        }
    }

    LiveData_result getData(LiveData_args args) throws AgentRemoteException {
        _log.info((Object)("Asked to invoke getData for " + args.getType()));
        try {
            String xml = this._manager.getData(args.getType(), args.getCommand(), args.getConfig());
            LiveData_result res = new LiveData_result();
            res.setResult(xml);
            return res;
        }
        catch (Exception e) {
            throw new AgentRemoteException(e.getMessage(), e);
        }
    }
}

