/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.agent.server;

import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.bizapp.client.AgentCallbackClientException;
import org.hyperic.hq.bizapp.client.MeasurementCallbackClient;
import org.hyperic.hq.bizapp.client.ProviderFetcher;
import org.hyperic.hq.bizapp.client.StorageProviderFetcher;
import org.hyperic.hq.bizapp.shared.lather.TopNSendReport_args;
import org.hyperic.hq.measurement.TopNSchedule;
import org.hyperic.hq.measurement.agent.commands.ScheduleTopn_args;
import org.hyperic.hq.measurement.agent.server.ServerTimeDiff;
import org.hyperic.hq.plugin.system.ProcessData;
import org.hyperic.hq.plugin.system.ProcessReport;
import org.hyperic.hq.plugin.system.TopData;
import org.hyperic.hq.plugin.system.TopReport;
import org.hyperic.hq.util.properties.PropertiesUtil;
import org.hyperic.sigar.Humidor;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;

class TopNScheduler {
    private static final int SEND_INTERVAL = 1;
    private static final int MAX_BATCHSIZE = 5;
    private static final int MAX_ELEMENT_TO_STORE = 1440;
    private static final String DATA_FOLDERNAME = "topn_records";
    private static final String SCHEDULE_FILE = "topn_schedule";
    private final AgentStorageProvider storage;
    private final Log log = LogFactory.getLog(TopNScheduler.class);
    private Sigar _sigarImpl;
    private Humidor _humidor;
    private ScheduledExecutorService scheduler;
    private ScheduledExecutorService sender;
    private final MeasurementCallbackClient client;
    private String agentToken;
    private boolean deductServerTimeDiff = true;

    TopNScheduler(AgentStorageProvider storage, AgentConfig bootConfig) throws AgentStartException {
        this.storage = storage;
        this.client = this.setupClient(bootConfig);
        Boolean deductServerOffset = PropertiesUtil.getBooleanValue((String)bootConfig.getBootProperties().getProperty("agent.deductServerTimeDiff"), (boolean)true);
        this.deductServerTimeDiff = deductServerOffset;
        this.createSender();
        this.loadScheduleData();
    }

    private void loadScheduleData() {
        TopNSchedule schedule = null;
        schedule = (TopNSchedule)this.storage.getObject(SCHEDULE_FILE);
        if (null != schedule) {
            this.scheduleTopN(schedule);
        }
    }

    private void createSender() {
        this.sender = Executors.newScheduledThreadPool(1, new ThreadFactory(){
            private final AtomicLong i = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "TopNSender" + this.i.getAndIncrement());
            }
        });
        this.sender.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ArrayList<TopReport> reports = new ArrayList<TopReport>();
                for (TopReport report : TopNScheduler.this.storage.getObjectsFromFolder(TopNScheduler.DATA_FOLDERNAME, 5)) {
                    reports.add(report);
                }
                if (reports.isEmpty()) {
                    TopNScheduler.this.log.debug((Object)"No TopN records were found in the storage");
                    return;
                }
                TopNScheduler.this.log.debug((Object)("Sending " + reports.size() + " TopN entries " + "to server"));
                boolean success = false;
                try {
                    TopNSendReport_args report = new TopNSendReport_args();
                    if (TopNScheduler.this.agentToken == null) {
                        TopNScheduler.this.agentToken = TopNScheduler.this.storage.getValue("covalent.CAMAgentToken");
                    }
                    report.setTopReports(reports);
                    TopNScheduler.this.client.topNSendReport(report);
                    success = true;
                }
                catch (AgentCallbackClientException exc) {
                    TopNScheduler.this.log.error((Object)("Error sending TOPN data to server: " + exc.getMessage()));
                }
                if (success) {
                    ArrayList<String> filesToDelete = new ArrayList<String>();
                    for (TopReport report : reports) {
                        filesToDelete.add(String.valueOf(report.getCreateTime()));
                    }
                    TopNScheduler.this.storage.deleteObjectsFromFolder(TopNScheduler.DATA_FOLDERNAME, filesToDelete.toArray(new String[filesToDelete.size()]));
                }
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }

    private void createScheduler() {
        this.scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){
            private final AtomicLong i = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "TopNScheduler" + this.i.getAndIncrement());
            }
        });
    }

    public void unscheduleTopN() {
        this.scheduler.shutdown();
        this.storage.deleteObject(SCHEDULE_FILE);
    }

    public void scheduleTopN(ScheduleTopn_args args) {
        TopNSchedule schedule = new TopNSchedule();
        schedule.setQueryFilter(args.getQueryFilter());
        schedule.setInterval(args.getInterval());
        schedule.setNumberOfProcesses(args.getNumberOfProcesses());
        schedule.setLastUpdateTime(System.currentTimeMillis());
        this.storage.saveObject((Object)schedule, SCHEDULE_FILE);
        this.scheduleTopN(schedule);
    }

    private void scheduleTopN(final TopNSchedule schedule) {
        this.log.info((Object)("Scheduling TopN gathering task at interval of " + schedule.getInterval() + " minutes"));
        if (null != this.scheduler && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
        }
        this.createScheduler();
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                TopData data = null;
                try {
                    data = TopData.gather((SigarProxy)TopNScheduler.this.getSigar(), (String)schedule.getQueryFilter());
                }
                catch (SigarException e) {
                    TopNScheduler.this.log.error((Object)"Unable to gather Top data", (Throwable)e);
                }
                if (null != data) {
                    TopReport report = TopNScheduler.this.generateTopReport(data);
                    report.filterTopProcesses(schedule.getNumberOfProcesses());
                    try {
                        TopNScheduler.this.storage.addObjectToFolder(TopNScheduler.DATA_FOLDERNAME, (Object)report, report.getCreateTime(), 1440);
                    }
                    catch (Exception ex) {
                        TopNScheduler.this.log.error((Object)"Unable to store TopN data", (Throwable)ex);
                    }
                }
            }
        }, 10L, schedule.getInterval() * 60, TimeUnit.SECONDS);
    }

    void die() {
        if (this.sender != null) {
            this.sender.shutdown();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        if (this._sigarImpl != null) {
            this._sigarImpl.close();
            this._sigarImpl = null;
        }
    }

    private TopReport generateTopReport(TopData data) {
        TopReport report = new TopReport();
        if (this.deductServerTimeDiff && Math.abs(ServerTimeDiff.getInstance().getServerTimeDiff()) > 30000L) {
            report.setCreateTime(System.currentTimeMillis() + ServerTimeDiff.getInstance().getServerTimeDiff());
        } else {
            report.setCreateTime(System.currentTimeMillis());
        }
        report.setUpTime(data.getUptime().toString());
        report.setCpu(data.getCpu().toString());
        report.setMem(data.getMem().toString());
        report.setSwap(data.getSwap().toString());
        report.setProcStat(data.getProcStat().toString());
        for (ProcessData process : data.getProcesses()) {
            ProcessReport processReport = new ProcessReport(process);
            report.addProcess(processReport);
        }
        return report;
    }

    private MeasurementCallbackClient setupClient(AgentConfig bootConfig) throws AgentStartException {
        StorageProviderFetcher fetcher = new StorageProviderFetcher(this.storage);
        return new MeasurementCallbackClient((ProviderFetcher)fetcher, bootConfig);
    }

    private synchronized SigarProxy getSigar() {
        if (this._humidor == null) {
            this._sigarImpl = new Sigar();
            this._humidor = new Humidor(this._sigarImpl);
        }
        return this._humidor.getSigar();
    }
}

