/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.lather.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.hq.common.SystemException;
import org.hyperic.lather.LatherRemoteException;
import org.hyperic.lather.LatherValue;
import org.hyperic.lather.client.LatherClient;
import org.hyperic.lather.xcode.LatherXCoder;
import org.hyperic.util.encoding.Base64;
import org.hyperic.util.http.HttpConfig;
import org.hyperic.util.http.ServerHttpClient;
import org.hyperic.util.security.KeystoreConfig;

public class LatherHTTPClient
implements LatherClient {
    public static final int TIMEOUT_CONN = 10000;
    public static final int TIMEOUT_DATA = 40000;
    public static final String HDR_ERROR = "X-error-response";
    public static final String HDR_VALUECLASS = "X-latherValue-class";
    public static final String CMD_AI_SEND_REPORT = "aiSendReport";
    public static final String CMD_AI_SEND_RUNTIME_REPORT = "aiSendRuntimeReport";
    public static final String REGISTRATION_USERNAME = "user";
    public static final String REGISTRATION_PASSWORD = "password";
    public static final String REG_CSR = "csr";
    public static final String PRODUCT_VERSION = "version";
    public static final String AGENT_IP = "agentIp";
    private final ServerHttpClient client;
    private final LatherXCoder xCoder;
    private final String baseURL;

    public LatherHTTPClient(String baseURL) throws Exception {
        this(baseURL, 10000, 40000, null);
    }

    public LatherHTTPClient(String baseURL, int timeoutConn, int timeoutData, AgentConfig agtCfg) {
        this(baseURL, LatherHTTPClient.createClient(timeoutConn, timeoutData, agtCfg));
    }

    public LatherHTTPClient(String baseURL, ServerHttpClient client) {
        this.client = client;
        this.baseURL = baseURL;
        this.xCoder = new LatherXCoder();
    }

    private static ServerHttpClient createClient(int timeoutConn, int timeoutData, AgentConfig agtCfg) {
        ServerHttpClient client;
        try {
            client = new ServerHttpClient((KeystoreConfig)new AgentKeystoreConfig(agtCfg), LatherHTTPClient.getHttpConfig(timeoutConn, timeoutData), false, LatherHTTPClient.getMaxRequestsPerConnection(), LatherHTTPClient.isSupportRRDNS(), LatherHTTPClient.getFailPeriodInMin(), LatherHTTPClient.getDownPeriodInMin());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return client;
    }

    public static int getMaxRequestsPerConnection() {
        String maxRequestsPerConnection = AgentConfig.getDefaultProperties().getProperty(AgentConfig.PROP_MAX_HTTP_REQUESTS_PER_CONNECTION[0]);
        try {
            return Integer.parseInt(maxRequestsPerConnection);
        }
        catch (NumberFormatException e) {
            return AgentConfig.MAX_HTTP_REQUESTS_PER_CONNECTION;
        }
    }

    public static HttpConfig getHttpConfig(int timeoutConn, int timeoutData) {
        String proxyHostname = System.getProperty("lather.proxyHost", null);
        int proxyPort = Integer.getInteger("lather.proxyPort", new Integer(-1));
        HttpConfig config = new HttpConfig();
        config.setConnectionTimeout(timeoutConn);
        config.setSocketTimeout(timeoutData);
        config.setProxyHostname(proxyHostname);
        config.setProxyPort(proxyPort);
        return config;
    }

    @Override
    public LatherValue invoke(String method, LatherValue args) throws IOException, LatherRemoteException {
        boolean closeConn = Boolean.parseBoolean(AgentConfig.getDefaultProperties().getProperty(AgentConfig.PROP_CLOSE_HTTP_CONNECTION_BY_DEFAULT[0]));
        return this.invoke(method, args, closeConn);
    }

    @Override
    public LatherValue invoke(String method, LatherValue args, boolean closeConn) throws IOException, LatherRemoteException {
        HttpResponse response = this.invokeUnparsed(method, args, closeConn);
        return this.parseLatherHttpResponse(response);
    }

    public LatherValue parseLatherHttpResponse(HttpResponse response) throws IOException, LatherRemoteException {
        if (response != null && response.getStatusLine().getStatusCode() == 200) {
            LatherValue decodedLather;
            ByteArrayInputStream bIs;
            Class<?> resClass;
            Header errHeader = response.getFirstHeader(HDR_ERROR);
            Header clsHeader = response.getFirstHeader(HDR_VALUECLASS);
            HttpEntity entity = response.getEntity();
            String responseBody = EntityUtils.toString((HttpEntity)entity);
            if (errHeader != null) {
                throw new LatherRemoteException(responseBody);
            }
            if (clsHeader == null) {
                throw new IOException("Server returned malformed result: did not contain a value class header");
            }
            try {
                resClass = Class.forName(clsHeader.getValue());
            }
            catch (ClassNotFoundException exc) {
                throw new LatherRemoteException("Server returned a class '" + clsHeader.getValue() + "' which the client did not have access to");
            }
            try {
                bIs = new ByteArrayInputStream(Base64.decode((String)responseBody));
            }
            catch (IllegalArgumentException e) {
                throw new SystemException("could not decode response from server body=" + responseBody, (Throwable)e);
            }
            DataInputStream dIs = new DataInputStream(bIs);
            try {
                decodedLather = this.xCoder.decode(dIs, resClass);
            }
            catch (IllegalArgumentException exc) {
                throw new LatherRemoteException("Response contained bad lather value: " + exc.getMessage());
            }
            return decodedLather;
        }
        EntityUtils.consume((HttpEntity)response.getEntity());
        throw new IOException("Connection failure: " + response.getStatusLine());
    }

    public HttpResponse invokeUnparsed(String method, LatherValue args, boolean closeConn) throws IOException, LatherRemoteException {
        ByteArrayOutputStream bOs = new ByteArrayOutputStream();
        DataOutputStream dOs = new DataOutputStream(bOs);
        this.xCoder.encode(args, dOs);
        byte[] rawData = bOs.toByteArray();
        String encodedArgs = Base64.encode((byte[])rawData);
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("method", method);
        if ("registerAgent".equalsIgnoreCase(method)) {
            postParams.put(REGISTRATION_USERNAME, (String)args.getStringVals().get(REGISTRATION_USERNAME));
            postParams.put(REGISTRATION_PASSWORD, (String)args.getStringVals().get("pword"));
            postParams.put(REG_CSR, Base64.encode((byte[])((byte[])args.getByteAVals().get(REG_CSR))));
            postParams.put(PRODUCT_VERSION, (String)args.getStringVals().get(PRODUCT_VERSION));
            postParams.put(AGENT_IP, (String)args.getStringVals().get("agentIP"));
        } else {
            postParams.put("args", encodedArgs);
            postParams.put("argsClass", args.getClass().getName());
        }
        this.shouldExpect100Continue(postParams);
        HttpResponse response = this.client.post(this.baseURL, postParams, closeConn);
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            throw new IOException("Connection failure: " + response.getStatusLine());
        }
        return response;
    }

    private void shouldExpect100Continue(Map<String, String> postParams) {
        String method = postParams.get("method");
        if (method != null && (CMD_AI_SEND_RUNTIME_REPORT.equals(method) || CMD_AI_SEND_REPORT.equals(method))) {
            postParams.put("Expect", "100-continue");
        }
    }

    public static int getFailPeriodInMin() {
        return LatherHTTPClient.getIntConfig(AgentConfig.PROP_COMMUNICATION_FAIL_PERIOD_IN_MINUTES[0], AgentConfig.COMMUNICATION_FAIL_PERIOD_IN_MINUTES);
    }

    public static int getDownPeriodInMin() {
        return LatherHTTPClient.getIntConfig(AgentConfig.PROP_COMMUNICATION_DOWN_PERIOD_IN_MINUTES[0], AgentConfig.COMMUNICATION_DOWN_PERIOD_IN_MINUTES);
    }

    public static boolean isSupportRRDNS() {
        return LatherHTTPClient.getBooleanConfig(AgentConfig.PROP_SUPPORT_RRDNS[0], AgentConfig.SUPPORT_RRDNS);
    }

    private static int getIntConfig(String propName, int defValue) {
        String value = AgentConfig.getDefaultProperties().getProperty(propName);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    private static boolean getBooleanConfig(String propName, boolean defValue) {
        String value = AgentConfig.getDefaultProperties().getProperty(propName);
        return Boolean.parseBoolean(value);
    }
}

