/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.vmware;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ptql.ProcessFinder;

public class VMwareGuestInfo {
    private static final String PTQL_QUERY = "State.Name.eq=vmtoolsd";
    private static final String VMTOOLSD_CMD_ARG = "--cmd";
    private static final String VMTOOLSD_GET_CMD_VALUE_PREFIX = "info-get guestinfo.";
    private static final String VMTOOLSD_SET_CMD_VALUE_PREFIX = "info-set guestinfo.";

    public static String findVMwareToolsCommand(Sigar sigar) {
        long[] pids;
        try {
            pids = ProcessFinder.find((Sigar)sigar, (String)PTQL_QUERY);
        }
        catch (SigarException e) {
            return null;
        }
        for (int i = 0; i < pids.length; ++i) {
            try {
                return sigar.getProcExe(pids[i]).getName();
            }
            catch (SigarException e) {
                try {
                    String[] args = sigar.getProcArgs(pids[i]);
                    if (args.length <= 0) continue;
                    return args[0];
                }
                catch (SigarException sigarException) {
                    // empty catch block
                }
                continue;
            }
        }
        return null;
    }

    public static Map<String, String> getGuestInfoValuesFor(String[] keys, Sigar sigar) {
        HashMap<String, String> info = new HashMap<String, String>();
        String vmtoolsd = VMwareGuestInfo.findVMwareToolsCommand(sigar);
        if (vmtoolsd == null) {
            return null;
        }
        String[] argv = new String[]{vmtoolsd, VMTOOLSD_CMD_ARG, null};
        for (int i = 0; i < keys.length; ++i) {
            argv[2] = VMTOOLSD_GET_CMD_VALUE_PREFIX + keys[i];
            String value = VMwareGuestInfo.getGuestInfoValue(argv);
            if (value == null) continue;
            info.put(keys[i], value);
        }
        if (info.size() > 0) {
            return info;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getGuestInfoValue(String[] argv) {
        BufferedReader in = null;
        try {
            String line;
            Process proc = Runtime.getRuntime().exec(argv);
            in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("Warning:") || line.startsWith("No value found")) continue;
                String string = line;
                return string;
            }
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setGuestInfoValue(String key, String value) {
        if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)value)) {
            return;
        }
        Sigar sigar = new Sigar();
        try {
            VMwareGuestInfo.setGuestInfoValue(sigar, key, value);
        }
        finally {
            sigar.close();
        }
    }

    public static void setGuestInfoValue(Sigar sigar, String key, String value) {
        if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)value)) {
            return;
        }
        String vmtoolsd = VMwareGuestInfo.findVMwareToolsCommand(sigar);
        if (vmtoolsd == null) {
            return;
        }
        String[] argv = new String[]{vmtoolsd, VMTOOLSD_CMD_ARG, VMTOOLSD_SET_CMD_VALUE_PREFIX + key + " " + value};
        try {
            Runtime.getRuntime().exec(argv);
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

