/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.stats;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import mx4j.tools.stats.AbstractStatisticsRecorder;
import mx4j.tools.stats.ObserverStatisticsRecorderMBean;

public abstract class ObserverStatisticsRecorder
extends AbstractStatisticsRecorder
implements ObserverStatisticsRecorderMBean {
    protected ObjectName observedName = null;
    protected String observedAttribute = null;

    public void setObservedObject(ObjectName object) {
        this.observedName = object;
    }

    public ObjectName getObservedObject() {
        return this.observedName;
    }

    public String getObservedAttribute() {
        return this.observedAttribute;
    }

    public void setObservedAttribute(String attribute) {
        this.observedAttribute = attribute;
    }

    protected void doStart() throws Exception {
        if (this.observedName == null || this.observedAttribute == null) {
            this.getLogger().warn(this.toString() + " cannot start with objectName " + this.observedName + " and attribute " + this.observedAttribute);
            this.stop();
            return;
        }
        if (!this.server.isRegistered(this.observedName)) {
            this.getLogger().warn(this.toString() + " cannot start since objectName is not registered");
            this.stop();
            return;
        }
        MBeanInfo info = this.server.getMBeanInfo(this.observedName);
        MBeanAttributeInfo[] attributes = info.getAttributes();
        MBeanAttributeInfo theAttribute = null;
        boolean found = false;
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equals(this.observedAttribute)) continue;
            theAttribute = attributes[i];
            found = true;
            break;
        }
        if (!found) {
            this.getLogger().warn(this.toString() + " cannot start with objectName " + this.observedName + " since attribute " + this.observedAttribute + " does not belong to the MBean interface");
            this.stop();
            return;
        }
        if (!theAttribute.isReadable()) {
            this.getLogger().warn(this.toString() + " cannot start with objectName " + this.observedName + " since attribute " + this.observedAttribute + " is not readable");
            this.stop();
            return;
        }
        Object value = this.server.getAttribute(this.observedName, this.observedAttribute);
        if (!(value instanceof Number)) {
            this.getLogger().warn(this.toString() + " cannot start with objectName " + this.observedName + " since attribute " + this.observedAttribute + " is not a number");
            this.stop();
            return;
        }
        this.startObserving();
    }

    protected abstract void startObserving() throws Exception;

    protected abstract void stopObserving() throws Exception;

    protected void doStop() throws Exception {
        this.stopObserving();
    }
}

