/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpEngine;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.ThreadContext;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import com.sun.jmx.snmp.daemon.SnmpAdaptorServer;
import com.sun.jmx.snmp.daemon.SnmpSubRequestHandler;
import com.sun.jmx.snmp.internal.SnmpIncomingRequest;
import java.util.logging.Level;

class SnmpSubNextRequestHandler
extends SnmpSubRequestHandler {
    private SnmpAdaptorServer server = null;

    protected SnmpSubNextRequestHandler(SnmpAdaptorServer snmpAdaptorServer, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu) {
        super(snmpMibAgent, snmpPdu);
        this.init(snmpPdu, snmpAdaptorServer);
    }

    protected SnmpSubNextRequestHandler(SnmpEngine snmpEngine, SnmpAdaptorServer snmpAdaptorServer, SnmpIncomingRequest snmpIncomingRequest, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu) {
        super(snmpEngine, snmpIncomingRequest, snmpMibAgent, snmpPdu);
        this.init(snmpPdu, snmpAdaptorServer);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubNextRequestHandler.class.getName(), "SnmpSubNextRequestHandler", "Constructor : " + this);
        }
    }

    private void init(SnmpPdu snmpPdu, SnmpAdaptorServer snmpAdaptorServer) {
        this.server = snmpAdaptorServer;
        int n = this.translation.length;
        SnmpVarBind[] snmpVarBindArray = snmpPdu.varBindList;
        SnmpSubRequestHandler.NonSyncVector nonSyncVector = (SnmpSubRequestHandler.NonSyncVector)this.varBind;
        for (int i = 0; i < n; ++i) {
            this.translation[i] = i;
            SnmpVarBind snmpVarBind = new SnmpVarBind(snmpVarBindArray[i].oid, snmpVarBindArray[i].value);
            nonSyncVector.addNonSyncElement(snmpVarBind);
        }
    }

    @Override
    public void run() {
        block9: {
            try {
                ThreadContext threadContext = ThreadContext.push("SnmpUserData", this.data);
                try {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:getNext operation on " + this.agent.getMibName());
                    }
                    this.agent.getNext(this.createMibRequest(this.varBind, 1, this.data));
                }
                finally {
                    ThreadContext.restore(threadContext);
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                this.errorStatus = snmpStatusException.getStatus();
                this.errorIndex = snmpStatusException.getErrorIndex();
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:an Snmp error occurred during the operation", snmpStatusException);
                }
            }
            catch (Exception exception) {
                this.errorStatus = 5;
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) break block9;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:a generic error occurred during the operation", exception);
            }
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    @Override
    protected void updateRequest(SnmpVarBind snmpVarBind, int n) {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "updateRequest", "Copy :" + snmpVarBind);
        }
        int n2 = this.varBind.size();
        this.translation[n2] = n;
        SnmpVarBind snmpVarBind2 = new SnmpVarBind(snmpVarBind.oid, snmpVarBind.value);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "updateRequest", "Copied :" + snmpVarBind2);
        }
        this.varBind.addElement(snmpVarBind2);
    }

    @Override
    protected void updateResult(SnmpVarBind[] snmpVarBindArray) {
        int n = this.varBind.size();
        for (int i = 0; i < n; ++i) {
            int n2 = this.translation[i];
            SnmpVarBind snmpVarBind = (SnmpVarBind)((SnmpSubRequestHandler.NonSyncVector)this.varBind).elementAtNonSync(i);
            SnmpVarBind snmpVarBind2 = snmpVarBindArray[n2];
            if (snmpVarBind2 == null) {
                snmpVarBindArray[n2] = snmpVarBind;
                continue;
            }
            SnmpValue snmpValue = snmpVarBind2.value;
            if (snmpValue == null || snmpValue == SnmpVarBind.endOfMibView) {
                if (snmpVarBind == null || snmpVarBind.value == SnmpVarBind.endOfMibView) continue;
                snmpVarBindArray[n2] = snmpVarBind;
                continue;
            }
            if (snmpVarBind == null || snmpVarBind.value == SnmpVarBind.endOfMibView) continue;
            int n3 = snmpVarBind.oid.compareTo(snmpVarBind2.oid);
            if (n3 < 0) {
                snmpVarBindArray[n2] = snmpVarBind;
                continue;
            }
            if (n3 != 0) continue;
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "updateResult", " oid overlapping. Oid : " + snmpVarBind.oid + "value :" + snmpVarBind.value);
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "updateResult", "Already present varBind : " + snmpVarBind2);
            }
            SnmpOid snmpOid = snmpVarBind2.oid;
            SnmpMibAgent snmpMibAgent = this.server.getAgentMib(snmpOid);
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "updateResult", "Deeper agent : " + snmpMibAgent);
            }
            if (snmpMibAgent != this.agent) continue;
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "updateResult", "The current agent is the deeper one. Update the value with the current one");
            }
            snmpVarBindArray[n2].value = snmpVarBind.value;
        }
    }
}

