/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.shared.lather;

import org.apache.log4j.Logger;
import org.hyperic.hq.bizapp.shared.lather.AgentInfo_args;
import org.hyperic.lather.LatherKeyNotFoundException;
import org.hyperic.lather.LatherRemoteException;

public class RegisterAgent_args
extends AgentInfo_args {
    private static final String PROP_VERSION = "version";
    private static final String PROP_CSR = "csr";
    private static final String VALIDATE_VERSION_PATTERN = "^[-\\w\\.]+$";
    private static int VERSION_LENGTH_MAX = 20;
    private static int CSR_LENGTH_MAX = 1200;
    private static final Logger LOGGER = Logger.getLogger(RegisterAgent_args.class);

    public void setVersion(String version) {
        this.setStringValue(PROP_VERSION, version);
    }

    public String getVersion() {
        return this.getStringValue(PROP_VERSION);
    }

    public void setCertificateRequest(byte[] csr) {
        this.setByteAValue(PROP_CSR, csr);
    }

    public byte[] getCertificateRequest() {
        return this.getByteAValue(PROP_CSR);
    }

    @Override
    public void validate() throws LatherRemoteException {
        byte[] csr;
        String version;
        super.validate();
        try {
            version = this.getVersion();
            csr = this.getCertificateRequest();
        }
        catch (LatherKeyNotFoundException exc) {
            throw new LatherRemoteException("Not all values were set. First value that wasn't set is:" + exc.getMessage());
        }
        if (csr.length > CSR_LENGTH_MAX || csr.length < 0) {
            LOGGER.error((Object)("Bad lather value denied: bad csr length; didn't match expected. Length was: " + csr.length + ", expected maximum length of: " + CSR_LENGTH_MAX));
            throw new LatherRemoteException(INVALID_VALUE_ERROR);
        }
        if (version.length() > VERSION_LENGTH_MAX || version.length() < 0) {
            LOGGER.error((Object)("Bad lather value denied: version field length didn't match expected. Length was: " + version.length() + " expected maximum of: " + VERSION_LENGTH_MAX));
            throw new LatherRemoteException(INVALID_VALUE_ERROR);
        }
        if (!version.matches(VALIDATE_VERSION_PATTERN)) {
            LOGGER.error((Object)("Bad lather value denied: version field pattern didn't match expected: " + version));
            throw new LatherRemoteException(INVALID_VALUE_ERROR);
        }
    }
}

