/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RunnableTrackThread
implements Runnable {
    private static Log log = LogFactory.getLog((String)RunnableTrackThread.class.getName());
    private Thread thread = null;
    private static RunnableTrackThread instance = null;
    private boolean shouldDie = false;
    private long interval = 60000L;
    private Set watchers = Collections.synchronizedSet(new HashSet());

    RunnableTrackThread() {
    }

    static synchronized RunnableTrackThread getInstance() {
        if (instance == null) {
            instance = new RunnableTrackThread();
        }
        return instance;
    }

    public synchronized void doStart() {
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread((Runnable)this, "RunnableLogThread");
        this.thread.setDaemon(true);
        this.thread.start();
        log.info((Object)(this.thread.getName() + " started"));
    }

    public synchronized void doStop() {
        if (this.thread == null) {
            return;
        }
        this.die();
        this.thread.interrupt();
        log.info((Object)(this.thread.getName() + " stopped"));
        this.thread = null;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public long getInterval() {
        return this.interval;
    }

    public void add(Runnable watcher) {
        this.watchers.add(watcher);
    }

    public void remove(Runnable watcher) {
        this.watchers.remove(watcher);
    }

    @Override
    public void run() {
        while (!this.shouldDie) {
            this.check();
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void die() {
        this.shouldDie = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() {
        Set set = this.watchers;
        synchronized (set) {
            for (Runnable watcher : this.watchers) {
                try {
                    watcher.run();
                }
                catch (Exception e) {
                    log.error((Object)("Unexpected exception: " + e), (Throwable)e);
                }
            }
        }
    }
}

