/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.jmx;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PluginException;

public class MBeanUtil {
    private static Log log = LogFactory.getLog(MBeanUtil.class);
    public static final String DYNAMIC_SERVICE_DOMAIN = "spring.application";
    private static Map converters = new HashMap();

    public static void addConverter(Class type, Converter converter) {
        converters.put(type.getName(), converter);
    }

    public static void addConverter(Class type, ListConverter converter) {
        converters.put(type.getName(), converter);
    }

    private static void addConverter(Class addType, Class fromType) {
        converters.put(addType.getName(), converters.get(fromType.getName()));
    }

    private static IllegalArgumentException invalid(String param, Exception e) {
        return new IllegalArgumentException("'" + param + "': " + e.getMessage());
    }

    private static void initConverters() {
        MBeanUtil.addConverter(Object.class, new Converter(){

            @Override
            public Object convert(String param) {
                return param;
            }
        });
        MBeanUtil.addConverter(Short.class, new Converter(){

            @Override
            public Object convert(String param) {
                return Short.valueOf(param);
            }
        });
        MBeanUtil.addConverter(Integer.class, new Converter(){

            @Override
            public Object convert(String param) {
                return Integer.valueOf(param);
            }
        });
        MBeanUtil.addConverter(Long.class, new Converter(){

            @Override
            public Object convert(String param) {
                return Long.valueOf(param);
            }
        });
        MBeanUtil.addConverter(Double.class, new Converter(){

            @Override
            public Object convert(String param) {
                return Double.valueOf(param);
            }
        });
        MBeanUtil.addConverter(Boolean.class, new Converter(){

            @Override
            public Object convert(String param) {
                return Boolean.valueOf(param);
            }
        });
        MBeanUtil.addConverter(File.class, new Converter(){

            @Override
            public Object convert(String param) {
                return new File(param);
            }
        });
        MBeanUtil.addConverter(URL.class, new Converter(){

            @Override
            public Object convert(String param) {
                try {
                    return new URL(param);
                }
                catch (MalformedURLException e) {
                    throw MBeanUtil.invalid(param, e);
                }
            }
        });
        MBeanUtil.addConverter(ObjectName.class, new Converter(){

            @Override
            public Object convert(String param) {
                try {
                    return new ObjectName(param);
                }
                catch (MalformedObjectNameException e) {
                    throw MBeanUtil.invalid(param, e);
                }
            }
        });
        MBeanUtil.addConverter(List.class, new ListConverter(){

            @Override
            public Object convert(String[] params) {
                return Arrays.asList(params);
            }
        });
        MBeanUtil.addConverter(String[].class, new ListConverter(){

            @Override
            public Object convert(String[] params) {
                return params;
            }
        });
        MBeanUtil.addConverter(Long[].class, new ListConverter(){

            @Override
            public Object convert(String[] params) {
                Long[] args = new Long[params.length];
                for (int i = 0; i < params.length; ++i) {
                    args[i] = Long.valueOf(params[i]);
                }
                return args;
            }
        });
        MBeanUtil.addConverter(Integer[].class, new ListConverter(){

            @Override
            public Object convert(String[] params) {
                Integer[] args = new Integer[params.length];
                for (int i = 0; i < params.length; ++i) {
                    args[i] = Integer.valueOf(params[i]);
                }
                return args;
            }
        });
        MBeanUtil.addConverter(Double[].class, new ListConverter(){

            @Override
            public Object convert(String[] params) {
                Double[] args = new Double[params.length];
                for (int i = 0; i < params.length; ++i) {
                    args[i] = Double.valueOf(params[i]);
                }
                return args;
            }
        });
        MBeanUtil.addConverter(Short[].class, new ListConverter(){

            @Override
            public Object convert(String[] params) {
                Short[] args = new Short[params.length];
                for (int i = 0; i < params.length; ++i) {
                    args[i] = Short.valueOf(params[i]);
                }
                return args;
            }
        });
        MBeanUtil.addConverter(Boolean[].class, new ListConverter(){

            @Override
            public Object convert(String[] params) {
                Boolean[] args = new Boolean[params.length];
                for (int i = 0; i < params.length; ++i) {
                    args[i] = Boolean.valueOf(params[i]);
                }
                return args;
            }
        });
        MBeanUtil.addConverter(long[].class, new ListConverter(){

            @Override
            public Object convert(String[] params) {
                long[] args = new long[params.length];
                for (int i = 0; i < params.length; ++i) {
                    args[i] = Long.parseLong(params[i]);
                }
                return args;
            }
        });
        MBeanUtil.addConverter(int[].class, new ListConverter(){

            @Override
            public Object convert(String[] params) {
                int[] args = new int[params.length];
                for (int i = 0; i < params.length; ++i) {
                    args[i] = Integer.parseInt(params[i]);
                }
                return args;
            }
        });
        MBeanUtil.addConverter(double[].class, new ListConverter(){

            @Override
            public Object convert(String[] params) {
                double[] args = new double[params.length];
                for (int i = 0; i < params.length; ++i) {
                    args[i] = Double.parseDouble(params[i]);
                }
                return args;
            }
        });
        MBeanUtil.addConverter(short[].class, new ListConverter(){

            @Override
            public Object convert(String[] params) {
                short[] args = new short[params.length];
                for (int i = 0; i < params.length; ++i) {
                    args[i] = Short.parseShort(params[i]);
                }
                return args;
            }
        });
        MBeanUtil.addConverter(boolean[].class, new ListConverter(){

            @Override
            public Object convert(String[] params) {
                boolean[] args = new boolean[params.length];
                for (int i = 0; i < params.length; ++i) {
                    args[i] = params[i].equals("true");
                }
                return args;
            }
        });
        Class[][] aliases = new Class[][]{{String.class, Object.class}, {Short.TYPE, Short.class}, {Integer.TYPE, Integer.class}, {Long.TYPE, Long.class}, {Double.TYPE, Double.class}, {Boolean.TYPE, Boolean.class}};
        for (int i = 0; i < aliases.length; ++i) {
            MBeanUtil.addConverter(aliases[i][0], aliases[i][1]);
        }
    }

    private static Object getConverter(String type) {
        Object converter = converters.get(type);
        if (converter == null) {
            converter = converters.get(Object.class.getName());
        }
        return converter;
    }

    private static boolean hasConverter(String type) {
        return converters.get(type) != null;
    }

    private static Object convert(String type, String param) {
        return ((Converter)MBeanUtil.getConverter(type)).convert(param);
    }

    private static Object convert(String type, String[] params) {
        return ((ListConverter)MBeanUtil.getConverter(type)).convert(params);
    }

    private static boolean isListType(String type) {
        return MBeanUtil.getConverter(type) instanceof ListConverter;
    }

    private static PluginException invalidParams(String method, HashMap sigs, Object[] args) {
        StringBuffer num = new StringBuffer();
        StringBuffer sig = new StringBuffer();
        for (Object o : sigs.keySet()) {
            StringBuffer sb = o instanceof Integer ? num : sig;
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(o);
        }
        String msg = "operation '" + method + "' takes (" + num + ")" + " arguments, " + args.length + " given. Signature=[" + sig + "]";
        return new PluginException(msg);
    }

    public static OperationParams getAttributeParams(MBeanInfo info, String method, Object[] args) throws PluginException {
        if (method.startsWith("set") || method.startsWith("get")) {
            method = method.substring(3);
        }
        MBeanAttributeInfo[] attrs = info.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            MBeanAttributeInfo attr = attrs[i];
            if (!attr.getName().equals(method)) continue;
            String sig = attr.getType();
            if (!MBeanUtil.hasConverter(sig)) {
                String msg = "Cannot convert String argument to " + sig;
                throw new PluginException(msg);
            }
            OperationParams params = new OperationParams();
            Object value = null;
            try {
                if (args.length > 0) {
                    value = MBeanUtil.convert(sig, (String)args[0]);
                }
            }
            catch (Exception e) {
                String msg = "Exception converting param '" + args[0] + "' to type '" + sig + "'";
                throw new PluginException(msg + ": " + e);
            }
            if (value != null) {
                params.arguments = new Object[]{value};
            }
            params.isAttribute = true;
            return params;
        }
        return null;
    }

    private static String toString(MBeanParameterInfo[] pinfo) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pinfo.length; ++i) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(pinfo[i].getType());
        }
        sb.insert(0, '(');
        sb.append(')');
        return sb.toString();
    }

    private static Object[] asObjectArray(long[] values) {
        Object[] list = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            list[i] = new Long(values[i]);
        }
        return list;
    }

    private static Object[] asObjectArray(int[] values) {
        Object[] list = new Integer[values.length];
        for (int i = 0; i < values.length; ++i) {
            list[i] = new Integer(values[i]);
        }
        return list;
    }

    private static Object[] asObjectArray(Object values) {
        if (values instanceof long[]) {
            return MBeanUtil.asObjectArray((long[])values);
        }
        if (values instanceof int[]) {
            return MBeanUtil.asObjectArray((int[])values);
        }
        if (values instanceof Object[]) {
            return (Object[])values;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OperationParams getOperationParams(MBeanInfo info, String method, Object[] args) throws PluginException {
        int consumed;
        String msg;
        String arg;
        boolean isDebug = log.isDebugEnabled();
        MBeanOperationInfo[] ops = info.getOperations();
        MBeanParameterInfo[] pinfo = null;
        HashMap<Object, MBeanParameterInfo[]> sigs = new HashMap<Object, MBeanParameterInfo[]>();
        String methodSignature = null;
        if (args.length != 0 && (arg = (String)args[0]).startsWith("@(") && arg.endsWith(")")) {
            methodSignature = arg.substring(1);
            String[] dst = new String[args.length - 1];
            System.arraycopy(args, 1, dst, 0, dst.length);
            args = dst;
        }
        if (isDebug) {
            String msg2 = "Converting params for: " + method + Arrays.asList(args);
            if (methodSignature != null) {
                msg2 = msg2 + ", using provided signature: " + methodSignature;
            }
            log.debug((Object)msg2);
        }
        for (int i = 0; i < ops.length; ++i) {
            if (!ops[i].getName().equals(method)) continue;
            pinfo = ops[i].getSignature();
            StringBuffer sig = new StringBuffer();
            sig.append("(");
            for (int j = 0; j < pinfo.length; ++j) {
                sig.append(pinfo[j].getType());
                if (j + 1 == pinfo.length) continue;
                sig.append(';');
            }
            sig.append(')');
            log.debug((Object)("Found operation: " + method + sig));
            sigs.put(sig.toString(), pinfo);
            sigs.put(new Integer(pinfo.length), pinfo);
        }
        if (sigs.size() == 0) {
            OperationParams op = MBeanUtil.getAttributeParams(info, method, args);
            if (op != null) {
                return op;
            }
            msg = "No MBean Operation or Attribute Info found for: " + method;
            throw new PluginException(msg);
        }
        if (sigs.size() > 1) {
            if (methodSignature == null) {
                Object o = sigs.get(new Integer(args.length));
                if (o == null) {
                    msg = "No Operation signatures found";
                    throw new PluginException(msg);
                }
                pinfo = (MBeanParameterInfo[])o;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using default sig: " + MBeanUtil.toString(pinfo)));
                }
            } else {
                pinfo = (MBeanParameterInfo[])sigs.get(methodSignature);
                if (pinfo == null) {
                    String msg3 = "No matching Operation signature found for: " + method + methodSignature;
                    throw new PluginException(msg3);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using matched sig: " + MBeanUtil.toString(pinfo)));
                }
            }
        }
        int len = pinfo.length;
        int nargs = args.length;
        String[] signature = new String[len];
        ArrayList<Object> arguments = new ArrayList<Object>();
        int j = 0;
        for (int i = 0; i < len; ++i, j += consumed) {
            void var16_33;
            String sig;
            consumed = 1;
            signature[i] = sig = pinfo[i].getType();
            if (!MBeanUtil.hasConverter(sig)) {
                String string = "Cannot convert String argument to " + sig;
                throw new PluginException(string);
            }
            if (j >= args.length) {
                throw MBeanUtil.invalidParams(method, sigs, args);
            }
            if (MBeanUtil.isListType(sig)) {
                void var16_27;
                if (len == 1) {
                    String[] stringArray = (String[])args;
                } else {
                    int remain = len - 1 - j;
                    consumed = args.length - j - remain;
                    String[] stringArray = new String[consumed];
                    System.arraycopy(args, j, stringArray, 0, consumed);
                }
                nargs -= ((void)var16_27).length;
                try {
                    arguments.add(MBeanUtil.convert(sig, (String[])var16_27));
                }
                catch (Exception e) {
                    String msg4 = "Exception converting " + Arrays.asList(var16_27) + "' to type '" + sig + "'";
                    throw new PluginException(msg4 + ": " + e);
                }
            }
            --nargs;
            try {
                arguments.add(MBeanUtil.convert(sig, (String)args[j]));
            }
            catch (Exception exception) {
                String msg5 = "Exception converting param[" + j + "] '" + args[j] + "' to type '" + sig + "'";
                throw new PluginException(msg5 + ": " + exception);
            }
            if (!isDebug) continue;
            Object e = arguments.get(i);
            if (e.getClass().isArray()) {
                Object[] objectArray = MBeanUtil.asObjectArray(e);
                if (objectArray == null) {
                    String string = arguments.get(i).toString();
                } else {
                    String string = Arrays.asList(objectArray).toString();
                }
            }
            log.debug((Object)(method + "() arg " + i + "=" + var16_33 + ", type=" + sig));
        }
        if (nargs != 0) {
            throw MBeanUtil.invalidParams(method, sigs, args);
        }
        OperationParams params = new OperationParams();
        params.signature = signature;
        params.arguments = arguments.toArray();
        return params;
    }

    public static String anyToString(Object obj) {
        if (obj.getClass().isArray()) {
            if (Object[].class.isAssignableFrom(obj.getClass())) {
                return Arrays.asList((Object[])obj).toString();
            }
            ArrayList<String> values = new ArrayList<String>();
            if (obj.getClass() == long[].class) {
                long[] xv = (long[])obj;
                for (int i = 0; i < xv.length; ++i) {
                    values.add(String.valueOf(xv[i]));
                }
            } else if (obj.getClass() == int[].class) {
                int[] xv = (int[])obj;
                for (int i = 0; i < xv.length; ++i) {
                    values.add(String.valueOf(xv[i]));
                }
            } else if (obj.getClass() == short[].class) {
                short[] xv = (short[])obj;
                for (int i = 0; i < xv.length; ++i) {
                    values.add(String.valueOf(xv[i]));
                }
            } else if (obj.getClass() == double[].class) {
                double[] xv = (double[])obj;
                for (int i = 0; i < xv.length; ++i) {
                    values.add(String.valueOf(xv[i]));
                }
            } else if (obj.getClass() == boolean[].class) {
                boolean[] xv = (boolean[])obj;
                for (int i = 0; i < xv.length; ++i) {
                    values.add(String.valueOf(xv[i]));
                }
            } else {
                return obj.toString();
            }
            return ((Object)values).toString();
        }
        return obj.toString();
    }

    static {
        MBeanUtil.initConverters();
    }

    public static class OperationParams {
        public Object[] arguments;
        public String[] signature;
        public boolean isAttribute = false;
    }

    public static interface ListConverter {
        public Object convert(String[] var1);
    }

    public static interface Converter {
        public Object convert(String var1);
    }
}

