/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class MultiRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -7173670617853595611L;
    private static final String NESTED_EXCEPTION_MSG_PREFIX = "--- Next Exception ---";
    private static final String CONTEXT_PREFIX = "[Context]: ";
    private final List<ExceptionWrapper> nestedExceptions;
    final MessageType ToString = new MessageType(){

        @Override
        public final StringBuilder appendMessage(Throwable t, StringBuilder messageBuilder) {
            return messageBuilder.append(t instanceof MultiRuntimeException ? MultiRuntimeException.super.toString() : t.toString());
        }
    };
    static final MessageType getMessage = new MessageType(){

        @Override
        public final StringBuilder appendMessage(Throwable t, StringBuilder messageBuilder) {
            return messageBuilder.append(t.getMessage());
        }
    };

    public MultiRuntimeException() {
        this.nestedExceptions = new ArrayList<ExceptionWrapper>();
    }

    public MultiRuntimeException(Throwable t) {
        this();
        this.addThrowable(t);
    }

    public MultiRuntimeException(String message, Throwable t) {
        super(message);
        this.nestedExceptions = new ArrayList<ExceptionWrapper>();
        this.addThrowable(t);
    }

    public final MultiRuntimeException addThrowable(Throwable t) {
        return this.addThrowable(t, null);
    }

    public final MultiRuntimeException addThrowable(Throwable t, String message) {
        this.nestedExceptions.add(new ExceptionWrapper(t, message));
        return this;
    }

    public final boolean isEmpty() {
        return this.nestedExceptions == null || this.nestedExceptions.isEmpty();
    }

    public final int size() {
        return this.isEmpty() ? 0 : this.nestedExceptions.size();
    }

    @Override
    public String getMessage() {
        String msg = super.getMessage();
        String origMsg = (msg == null ? "" : msg) + "\n";
        StringBuilder builder = new StringBuilder(origMsg).append(this.nestedExceptions.size()).append(" Exception(s) have occured:\n");
        return builder.toString();
    }

    public String getCompleteMessage(MessageType enumMessageType) {
        StringBuilder builder = new StringBuilder();
        enumMessageType.appendMessage(this, builder);
        int iLength = this.nestedExceptions.size();
        for (int i = 0; i < iLength; ++i) {
            this.getMessage(enumMessageType, this.nestedExceptions.get(i), builder);
            if (i >= iLength - 1) continue;
            builder.append("\n--- Next Exception ---\n");
        }
        return builder.toString();
    }

    public String toCompleteString() {
        return this.getCompleteMessage(this.ToString);
    }

    private final StringBuilder getMessage(MessageType enumMessageType, ExceptionWrapper wrapper, StringBuilder builder) {
        Throwable exception = wrapper.t;
        if (wrapper.message != null) {
            builder.append(CONTEXT_PREFIX).append(wrapper.message).append("\n");
        }
        if (exception instanceof SQLException) {
            SQLException sqle = (SQLException)exception;
            SQLException t = null;
            while (true) {
                t = sqle;
                enumMessageType.appendMessage(t, builder);
                sqle = sqle.getNextException();
                if (sqle != null && sqle != t) {
                    builder.append("\n---Next SQL Exception---\n");
                    continue;
                }
                break;
            }
        } else {
            enumMessageType.appendMessage(exception, builder);
        }
        return builder;
    }

    @Override
    public final void printStackTrace(PrintStream ps) {
        this.printStackTrace(ps, StreamHandlerInterface.printStreamStrategy);
    }

    public final void printSelfStacktrace(PrintStream ps) {
        super.printStackTrace(ps);
    }

    public final void printSelfStacktrace(PrintWriter pw) {
        super.printStackTrace(pw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> void printStackTrace(T visitor, StreamHandlerInterface<T> strategy) {
        T t = visitor;
        synchronized (t) {
            strategy.printParentStackTrace(visitor, this);
            Throwable exception = null;
            for (ExceptionWrapper wrapper : this.nestedExceptions) {
                strategy.println(visitor, NESTED_EXCEPTION_MSG_PREFIX);
                if (wrapper.message != null) {
                    strategy.println(visitor, CONTEXT_PREFIX + wrapper.message);
                }
                if ((exception = wrapper.t) instanceof SQLException) {
                    SQLException sqle = (SQLException)exception;
                    SQLException t2 = null;
                    do {
                        t2 = sqle;
                        strategy.printStackTrace(visitor, t2);
                    } while ((sqle = sqle.getNextException()) != null && sqle != t2);
                    continue;
                }
                strategy.printStackTrace(visitor, exception);
            }
        }
    }

    @Override
    public final void printStackTrace(PrintWriter pw) {
        this.printStackTrace(pw, StreamHandlerInterface.printWriterStrategy);
    }

    public static final MultiRuntimeException newMultiRuntimeException(MultiRuntimeException multiException, Throwable t) {
        return MultiRuntimeException.newMultiRuntimeException(multiException, t, null);
    }

    public static final MultiRuntimeException newMultiRuntimeException(MultiRuntimeException multiException, Throwable t, String nestedExcpetionMessage) {
        if (multiException == null) {
            multiException = t instanceof MultiRuntimeException ? (MultiRuntimeException)t : new MultiRuntimeException(t);
        } else {
            multiException.addThrowable(t, nestedExcpetionMessage);
        }
        return multiException;
    }

    private static final class ExceptionWrapper {
        private Throwable t;
        private String message;

        public ExceptionWrapper(Throwable t, String message) {
            this.t = t;
            this.message = message;
        }
    }

    private static interface MessageType {
        public StringBuilder appendMessage(Throwable var1, StringBuilder var2);
    }

    private static final class PrintWriterHandler
    implements StreamHandlerInterface<PrintWriter> {
        private PrintWriterHandler() {
        }

        @Override
        public final void println(PrintWriter visitor, String line) {
            visitor.println(line);
        }

        @Override
        public final void print(PrintWriter visitor, String line) {
            visitor.print(line);
        }

        @Override
        public final void printStackTrace(PrintWriter visitor, Throwable throwable) {
            throwable.printStackTrace(visitor);
        }

        @Override
        public final void printParentStackTrace(PrintWriter visitor, MultiRuntimeException mre) {
            mre.printSelfStacktrace(visitor);
        }
    }

    private static final class PrintStreamHandler
    implements StreamHandlerInterface<PrintStream> {
        private PrintStreamHandler() {
        }

        @Override
        public final void println(PrintStream visitor, String line) {
            visitor.println(line);
        }

        @Override
        public final void print(PrintStream visitor, String line) {
            visitor.print(line);
        }

        @Override
        public final void printStackTrace(PrintStream visitor, Throwable throwable) {
            throwable.printStackTrace(visitor);
        }

        @Override
        public final void printParentStackTrace(PrintStream visitor, MultiRuntimeException mre) {
            mre.printSelfStacktrace(visitor);
        }
    }

    private static interface StreamHandlerInterface<T> {
        public static final StreamHandlerInterface<PrintStream> printStreamStrategy = new PrintStreamHandler();
        public static final StreamHandlerInterface<PrintWriter> printWriterStrategy = new PrintWriterHandler();

        public void printParentStackTrace(T var1, MultiRuntimeException var2);

        public void println(T var1, String var2);

        public void print(T var1, String var2);

        public void printStackTrace(T var1, Throwable var2);
    }
}

