/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.stats;

public class StatsCollector {
    private final Object LOCK = new Object();
    private long[] _timestamps;
    private double[] _values;
    private int _start;
    private int _numEnts;
    private int _size;
    private double _total;

    public StatsCollector(int size) {
        this._timestamps = new long[size];
        this._values = new double[size];
        this._start = 0;
        this._numEnts = 0;
        this._size = size;
        this._total = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(double value, long timestamp) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this._numEnts == this._size) {
                this._total -= this._values[this._start];
                this._values[this._start] = value;
                this._timestamps[this._start] = timestamp;
                ++this._start;
                if (this._start == this._size) {
                    this._start = 0;
                }
            } else {
                int insertIdx = this._start + this._numEnts;
                this._values[insertIdx] = value;
                this._timestamps[insertIdx] = timestamp;
                ++this._numEnts;
            }
            this._total += value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTotal() {
        Object object = this.LOCK;
        synchronized (object) {
            return this._total;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOldestTime() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this._numEnts == 0) {
                return -1L;
            }
            return this._timestamps[this._start];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNewestTime() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this._numEnts == 0) {
                return -1L;
            }
            int idx = this._start + (this._numEnts - 1);
            if (idx >= this._size) {
                idx -= this._size;
            }
            return this._timestamps[idx];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double valPerTimestamp(long newestTime) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this._numEnts < 2) {
                return Double.NaN;
            }
            long runtime = newestTime - this.getOldestTime();
            return this.getTotal() / (double)runtime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double valPerTimestamp() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.valPerTimestamp(this.getNewestTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Object object = this.LOCK;
        synchronized (object) {
            return this._numEnts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump() {
        Object object = this.LOCK;
        synchronized (object) {
            StringBuffer res = new StringBuffer();
            int idx = this._start;
            res.append("Size=" + this._size + " Start=" + this._start + " numEnts=" + this._numEnts + " valPerTimestamp=" + this.valPerTimestamp() + " oldest=" + this.getOldestTime() + " newest=" + this.getNewestTime() + "\n");
            for (int i = 0; i < this._numEnts; ++i) {
                res.append("Value[" + idx + "]  val=" + this._values[idx] + " ts=" + this._timestamps[idx] + "\n");
                if (++idx != this._size) continue;
                idx = 0;
            }
            return res.toString();
        }
    }

    public static void main(String[] args) {
        StatsCollector x = new StatsCollector(2);
        x.add(100.0, 1L);
        System.out.println(x.dump());
        x.add(200.0, 2L);
        System.out.println(x.dump());
        x.add(300.0, 3L);
        System.out.println(x.dump());
        x.add(400.0, 4L);
        System.out.println(x.dump());
    }
}

