/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.validator.common;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.hyperic.util.validator.common.CommonValidatorException;
import org.xml.sax.SAXException;

public class CommonValidator {
    private ResourceBundle _properties = null;
    private ValidatorResults _validatorResults = null;
    private String _resourceName = null;
    private ValidatorResources _validatorResources = null;

    public CommonValidator(ResourceBundle properties) {
        this._properties = properties;
    }

    private void setResourceName(String rName) {
        this._resourceName = rName;
    }

    private void setValidatorResults(ValidatorResults results) {
        this._validatorResults = results;
    }

    public ValidatorResults getValidatorResults() {
        return this._validatorResults;
    }

    public String getResourceName() {
        return this._resourceName;
    }

    public ValidatorResources getValidatorResources() {
        return this._validatorResources;
    }

    private void setValidatorResources(String resourceName, Object bean, InputStream in) throws IOException, SAXException {
        if (this.getResourceName() == null || !this.getResourceName().equals(resourceName)) {
            this.setResourceName(resourceName);
            in = bean.getClass().getResourceAsStream(resourceName);
            this._validatorResources = new ValidatorResources(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(String validationMappingRes, String formName, Object beanInstance) throws CommonValidatorException, SAXException {
        block19: {
            InputStream xmlStream = null;
            CommonValidatorException cve = null;
            try {
                this.setValidatorResources(validationMappingRes, beanInstance, xmlStream);
                Form form = this._validatorResources.getForm(Locale.getDefault(), formName);
                Validator validator = new Validator(this._validatorResources, formName);
                validator.setParameter("java.lang.Object", beanInstance);
                ValidatorResults results = validator.validate();
                this.setValidatorResults(results);
                for (String propertyName : results.getPropertyNames()) {
                    Field field = form.getField(propertyName);
                    String prettyFieldName = this._properties.getString(field.getArg(0).getKey());
                    ValidatorResult result = results.getValidatorResult(propertyName);
                    Map actionMap = result.getActionMap();
                    for (String actName : actionMap.keySet()) {
                        ValidatorAction action = this._validatorResources.getValidatorAction(actName);
                        if (result.isValid(actName)) continue;
                        String message = this._properties.getString(action.getMsg());
                        Object[] args = new Object[]{prettyFieldName};
                        if (cve == null) {
                            cve = new CommonValidatorException();
                        }
                        cve.addMessage(MessageFormat.format(message, args));
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (ValidatorException ex) {
                ex.printStackTrace();
            }
            finally {
                if (xmlStream != null) {
                    try {
                        xmlStream.close();
                    }
                    catch (Exception e) {}
                }
                if (cve == null) break block19;
                throw cve;
            }
        }
    }
}

