/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipInputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.hyperic.util.file.ArchiveUpdater;
import org.hyperic.util.file.FileUtil;

public class ZipUpdater
extends ArchiveUpdater {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(File zip, File out, String pathToReplace, InputStream replacement, long rsize) throws IOException {
        FileInputStream file_in = null;
        ZipInputStream zip_in = null;
        FileOutputStream file_out = null;
        ZipOutputStream zip_out = null;
        boolean isOverwrite = false;
        if (out == null || out.equals(zip)) {
            isOverwrite = true;
            out = File.createTempFile("ZipUpdater", ".zip.tmp");
        }
        boolean completedOK = false;
        boolean didReplacement = false;
        byte[] buf = new byte[8192];
        try {
            ZipEntry outEntry;
            file_in = new FileInputStream(zip);
            zip_in = new ZipInputStream(new BufferedInputStream(file_in));
            file_out = new FileOutputStream(out);
            zip_out = new ZipOutputStream((OutputStream)new BufferedOutputStream(file_out));
            zip_out.setLevel(9);
            zip_out.setMethod(8);
            java.util.zip.ZipEntry inEntry = zip_in.getNextEntry();
            while (inEntry != null) {
                outEntry = new ZipEntry(inEntry);
                outEntry.setMethod(8);
                if (!didReplacement && this.matches(outEntry.getName(), pathToReplace)) {
                    this.addFile(outEntry, zip_out, replacement, rsize, buf);
                    didReplacement = true;
                } else {
                    zip_out.putNextEntry(outEntry);
                    FileUtil.copyStream(zip_in, (OutputStream)zip_out, buf);
                    zip_out.closeEntry();
                }
                inEntry = zip_in.getNextEntry();
            }
            if (!didReplacement) {
                outEntry = new ZipEntry(pathToReplace);
                this.addFile(outEntry, zip_out, replacement, rsize, buf);
            }
            file_out.flush();
            zip_out.flush();
            completedOK = true;
        }
        catch (Throwable throwable) {
            this.doClose(zip_in);
            this.doClose(file_in);
            this.doClose((OutputStream)zip_out);
            this.doClose(file_out);
            if (!completedOK) {
                out.delete();
            }
            throw throwable;
        }
        this.doClose(zip_in);
        this.doClose(file_in);
        this.doClose((OutputStream)zip_out);
        this.doClose(file_out);
        if (!completedOK) {
            out.delete();
        }
        if (isOverwrite && !out.renameTo(zip)) {
            throw new IOException("Error renaming " + out.getPath() + " to " + zip.getPath());
        }
    }

    private void addFile(ZipEntry entry, ZipOutputStream zip_out, InputStream in, long size, byte[] buf) throws IOException {
        entry.setTime(System.currentTimeMillis());
        entry.setSize(size);
        zip_out.putNextEntry(entry);
        FileUtil.copyStream(in, (OutputStream)zip_out, buf);
        zip_out.closeEntry();
    }
}

