/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.hyperic.util.http.HttpConfig;
import org.hyperic.util.security.DefaultSSLProviderImpl;
import org.hyperic.util.security.KeystoreConfig;

public class HQHttpClient
extends DefaultHttpClient {
    private final Log log = LogFactory.getLog(HQHttpClient.class);

    public HQHttpClient(KeystoreConfig keyConfig, HttpConfig config, boolean acceptUnverifiedCertificates, ClientConnectionManager conman) {
        super(conman);
        this.log.debug((Object)("Keystore info: path:" + keyConfig.getFilePath() + ", acceptUnverifiedCertificates=" + acceptUnverifiedCertificates));
        DefaultSSLProviderImpl sslProvider = new DefaultSSLProviderImpl(keyConfig, acceptUnverifiedCertificates);
        Scheme sslScheme = new Scheme("https", 443, (SchemeSocketFactory)sslProvider.getSSLSocketFactory());
        this.getConnectionManager().getSchemeRegistry().register(sslScheme);
        if (config != null) {
            this.getParams().setParameter("http.socket.timeout", (Object)config.getSocketTimeout());
            this.getParams().setParameter("http.connection.timeout", (Object)config.getConnectionTimeout());
            String proxyHost = config.getProxyHostname();
            int proxyPort = config.getProxyPort();
            if (proxyHost != null & proxyPort != -1) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                this.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            }
        }
    }

    public HQHttpClient(KeystoreConfig keyConfig, HttpConfig config, boolean acceptUnverifiedCertificates) {
        this(keyConfig, config, acceptUnverifiedCertificates, null);
    }

    public HttpResponse post(String url, Map<String, String> params) throws ClientProtocolException, IOException {
        return this.post(url, null, params);
    }

    public HttpResponse post(String url, Map<String, String> headers, Map<String, String> params) throws ClientProtocolException, IOException {
        if (url == null || StringUtils.isWhitespace((String)url)) {
            throw new IllegalArgumentException("url cannot be null and must contain at least one non-whitespacecharacter");
        }
        HttpPost post = new HttpPost(url);
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                post.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (params.containsKey("method")) {
            post.addHeader("Method", params.get("method"));
        }
        if (params.containsKey("Expect")) {
            post.addHeader("Expect", "100-continue");
        }
        if (params != null && !params.isEmpty()) {
            ArrayList<BasicNameValuePair> postParams = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                postParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(postParams, "UTF-8"));
        }
        return this.execute((HttpUriRequest)post);
    }

    public HttpResponse get(String url, Map<String, String> headers) throws ClientProtocolException, IOException {
        if (url == null || StringUtils.isWhitespace((String)url)) {
            throw new IllegalArgumentException("url cannot be null and must contain at least one non-whitespacecharacter");
        }
        HttpGet post = new HttpGet(url);
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                post.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return this.execute((HttpUriRequest)post);
    }
}

