/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.client.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.protocol.HttpContext;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.hq.bizapp.client.AgentCallbackClient;
import org.hyperic.lather.client.LatherHTTPClient;
import org.hyperic.util.http.ServerHttpClient;
import org.hyperic.util.security.KeystoreConfig;

public enum CommonServerInteractor {
    INSTANCE;

    private static final int FALLBACK_KEEP_ALIVE_DURATION = 15000;
    private static final int CONNECTION_TIMEOUT = 30000;
    private static final int SOCKET_TIMEOUT = 300000;
    private static final Log logger;
    private ServerHttpClient httpClient;

    public synchronized ServerHttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = this.generateHttpClient(this.getFallbackConfig());
        }
        return this.httpClient;
    }

    private ServerHttpClient generateHttpClient(AgentKeystoreConfig agentKeystoreConfig) {
        ServerHttpClient client = new ServerHttpClient((KeystoreConfig)agentKeystoreConfig, LatherHTTPClient.getHttpConfig((int)30000, (int)300000), true, this.generateConnectionManager(), CommonServerInteractor.getMaxRequestsPerConnection(), CommonServerInteractor.isSupportRRDNS(), CommonServerInteractor.getFailPeriodInMin(), CommonServerInteractor.getDownPeriodInMin());
        client.setReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy());
        client.setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long serverKeepaliveTimeout = super.getKeepAliveDuration(response, context);
                if (serverKeepaliveTimeout <= 0L) {
                    return 15000L;
                }
                return serverKeepaliveTimeout;
            }
        });
        this.setLocalIPAddress(client);
        return client;
    }

    private void setLocalIPAddress(ServerHttpClient client) {
        String localIPAddress = this.getLocalIPAddressFromAgentProperties();
        try {
            if (StringUtils.isNotBlank((String)localIPAddress)) {
                client.getParams().setParameter("http.route.local-address", (Object)InetAddress.getByName(localIPAddress));
            }
        }
        catch (UnknownHostException e) {
            logger.error((Object)"Error in generateHttpClient. Could not set source IP address for agent", (Throwable)e);
        }
    }

    private String getLocalIPAddressFromAgentProperties() {
        String localIPAddress = AgentConfig.getDefaultProperties().getProperty("agent.setup.agentIP");
        if (StringUtils.isNotBlank((String)localIPAddress)) {
            if (InetAddressUtils.isIPv4Address((String)localIPAddress) || InetAddressUtils.isIPv6Address((String)localIPAddress)) {
                return localIPAddress;
            }
            logger.error((Object)"Error in getLocalIPAddressFromAgentProperties. The local IP address is not valid");
        }
        return "";
    }

    private ClientConnectionManager generateConnectionManager() {
        ThreadSafeClientConnManager conman = new ThreadSafeClientConnManager();
        conman.setDefaultMaxPerRoute(CommonServerInteractor.getMaxConnectionsPerRoute());
        return conman;
    }

    private AgentKeystoreConfig getFallbackConfig() {
        AgentConfig config = AgentCallbackClient.getAgentConfig();
        return new AgentKeystoreConfig(config);
    }

    private static int getMaxRequestsPerConnection() {
        String maxRequestsPerConnection = AgentConfig.getDefaultProperties().getProperty(AgentConfig.PROP_MAX_HTTP_REQUESTS_PER_CONNECTION[0]);
        try {
            return Integer.parseInt(maxRequestsPerConnection);
        }
        catch (NumberFormatException e) {
            return AgentConfig.MAX_HTTP_REQUESTS_PER_CONNECTION;
        }
    }

    private static int getMaxConnectionsPerRoute() {
        String maxConnectionsPerRoute = AgentConfig.getDefaultProperties().getProperty(AgentConfig.PROP_MAX_HTTP_CONNECTION_PER_ROUTE[0]);
        try {
            return Integer.parseInt(maxConnectionsPerRoute);
        }
        catch (NumberFormatException e) {
            return AgentConfig.MAX_HTTP_CONNECTION_PER_ROUTE;
        }
    }

    public static int getFailPeriodInMin() {
        return CommonServerInteractor.getIntConfig(AgentConfig.PROP_COMMUNICATION_FAIL_PERIOD_IN_MINUTES[0], AgentConfig.COMMUNICATION_FAIL_PERIOD_IN_MINUTES);
    }

    public static int getDownPeriodInMin() {
        return CommonServerInteractor.getIntConfig(AgentConfig.PROP_COMMUNICATION_DOWN_PERIOD_IN_MINUTES[0], AgentConfig.COMMUNICATION_DOWN_PERIOD_IN_MINUTES);
    }

    public static boolean isSupportRRDNS() {
        return CommonServerInteractor.getBooleanConfig(AgentConfig.PROP_SUPPORT_RRDNS[0], AgentConfig.SUPPORT_RRDNS);
    }

    private static int getIntConfig(String propName, int defValue) {
        String value = AgentConfig.getDefaultProperties().getProperty(propName);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    private static boolean getBooleanConfig(String propName, boolean defValue) {
        String value = AgentConfig.getDefaultProperties().getProperty(propName);
        return Boolean.parseBoolean(value);
    }

    public synchronized void onKeystoreChange(AgentKeystoreConfig agentKeystoreConfig) {
        this.httpClient = this.generateHttpClient(agentKeystoreConfig);
        logger.info((Object)"Generated a new http client");
    }

    static {
        logger = LogFactory.getLog(CommonServerInteractor.class);
    }
}

