/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerControlPlugin;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.util.config.ConfigResponse;

public class FileControlPlugin
extends ServerControlPlugin {
    private File file;
    private static final List ACTIONS = Arrays.asList("run");

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        this.file = new File(config.getValue("path"));
        this.setControlProgram(this.file.getAbsolutePath());
    }

    public List getActions() {
        return ACTIONS;
    }

    public void doAction(String action, String[] args) throws PluginException {
        if (this.file.isDirectory()) {
            throw new PluginException(this.file + " is a directory.");
        }
        this.doCommand(args);
    }

    protected boolean useConfigSchema(TypeInfo info) {
        return true;
    }
}

