/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hyperic.hq.appdef.shared.AIServiceValue;
import org.hyperic.hq.plugin.system.SystemServerDetector;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.win32.Service;
import org.hyperic.sigar.win32.ServiceConfig;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.EncodingException;

public class WindowsDetector
extends SystemServerDetector {
    @Override
    protected String getServerType() {
        return "WindowsServer";
    }

    @Override
    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        if (WindowsDetector.isWin32()) {
            return super.getServerResources(platformConfig);
        }
        return null;
    }

    private boolean setCustomProperty(String type, ConfigResponse cprops, String key, String val) {
        if (type.equals("Windows Service")) {
            cprops.setValue(key, val);
            return true;
        }
        ProductPluginManager manager = (ProductPluginManager)this.getManager().getParent();
        MeasurementPlugin plugin = manager.getMeasurementPlugin(type);
        if (plugin == null) {
            return false;
        }
        if (plugin.getCustomPropertiesSchema().getOption(key) == null) {
            return false;
        }
        cprops.setValue(key, val);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceConfig setServiceInventoryProperties(String serviceName, AIServiceValue svc, boolean exists) {
        String desc;
        String statusString;
        int status;
        ServiceConfig config;
        ConfigResponse cprops = new ConfigResponse();
        Service service = null;
        try {
            service = new Service(serviceName);
            config = service.getConfig();
            status = service.getStatus();
            statusString = service.getStatusString();
        }
        catch (Win32Exception e) {
            String msg = "Error getting config for service=" + serviceName + ": " + e.getMessage();
            if (exists) {
                log.error((Object)msg);
            } else {
                log.debug((Object)(serviceName + " does not exist"));
            }
            ServiceConfig serviceConfig = null;
            return serviceConfig;
        }
        finally {
            if (service != null) {
                service.close();
            }
        }
        if (!exists) {
            if (config.getStartType() != 2) {
                log.debug((Object)("Skipping " + serviceName + ", start type=" + config.getStartTypeString()));
                return null;
            }
            if (status != 4) {
                log.debug((Object)("Skipping " + serviceName + ", status=" + statusString));
                return null;
            }
        }
        if ((desc = config.getDescription()) == null) {
            desc = config.getDisplayName();
        }
        svc.setDescription(desc);
        String type = svc.getServiceTypeName();
        this.setCustomProperty(type, cprops, "path", config.getPath());
        this.setCustomProperty(type, cprops, "startupType", config.getStartTypeString());
        this.setCustomProperty(type, cprops, "displayName", config.getDisplayName());
        try {
            svc.setCustomProperties(cprops.encode());
        }
        catch (EncodingException e) {
            log.error((Object)("Error encoding cprops: " + e.getMessage()));
            return null;
        }
        return config;
    }

    private AIServiceValue findWindowsService(String type, String serviceName, boolean enableControl) {
        AIServiceValue svc;
        ServiceConfig config;
        String serviceDisplayName = null;
        if (serviceName != null && !serviceName.isEmpty() && serviceName.contains("|")) {
            String[] serviceNameWithDescription = serviceName.split("\\|");
            serviceName = serviceNameWithDescription[0];
            serviceDisplayName = serviceNameWithDescription[1];
        }
        if ((config = this.setServiceInventoryProperties(serviceName, svc = this.createSystemService(type, serviceName), false)) == null) {
            return null;
        }
        if (serviceDisplayName != null) {
            svc.setName(serviceDisplayName);
        } else {
            svc.setName(this.getFullServiceName(config.getDisplayName()));
        }
        log.debug((Object)("Found service " + svc.getName() + " - " + svc.getDescription()));
        ConfigResponse productConfig = new ConfigResponse();
        productConfig.setValue("service_name", serviceName);
        try {
            svc.setProductConfig(productConfig.encode());
            svc.setMeasurementConfig(ConfigResponse.EMPTY_CONFIG);
            if (enableControl) {
                svc.setControlConfig(ConfigResponse.EMPTY_CONFIG);
            }
        }
        catch (EncodingException e) {
            log.error((Object)("Error encoding config: " + e.getMessage()));
            return null;
        }
        return svc;
    }

    private void discoverWindowsServices(String names, ArrayList services) throws Win32Exception {
        List serviceNames = "true".equals(names) ? Service.getServiceNames() : StringUtil.explode((String)names, (String)",");
        for (int i = 0; i < serviceNames.size(); ++i) {
            String name = (String)serviceNames.get(i);
            AIServiceValue svc = this.findWindowsService("Windows Service", name, true);
            if (svc == null) continue;
            services.add(svc);
        }
    }

    boolean hasControlPlugin(String type) {
        ProductPluginManager ppm = (ProductPluginManager)this.getManager().getParent();
        return ppm.getControlPlugin(type) != null;
    }

    private void discoverPluginServices(List services) {
        Map plugins = this.getServiceInventoryPlugins();
        if (plugins == null) {
            return;
        }
        for (String type : plugins.keySet()) {
            String name = this.getTypeProperty(type, "service_name");
            if (name == null) {
                log.warn((Object)("Service type '" + type + "' has autoinventory plugin " + "without '" + "service_name" + "' property defined."));
                continue;
            }
            boolean enableControl = this.hasControlPlugin(type);
            log.debug((Object)("Looking for " + type + " service=" + name + " (control=" + enableControl + ")"));
            AIServiceValue svc = this.findWindowsService(type, name, enableControl);
            if (svc == null) continue;
            services.add(svc);
        }
    }

    @Override
    protected ArrayList getSystemServiceValues(Sigar sigar, ConfigResponse serverConfig) throws SigarException {
        String type = "Windows Service";
        List serviceConfigs = this.getServiceConfigs(type);
        ArrayList<AIServiceValue> services = new ArrayList<AIServiceValue>();
        for (int i = 0; i < serviceConfigs.size(); ++i) {
            ConfigResponse serviceConfig = (ConfigResponse)serviceConfigs.get(i);
            String name = serviceConfig.getValue("resource.name");
            String serviceName = serviceConfig.getValue("service_name");
            AIServiceValue svc = this.createSystemService(type, name);
            this.setServiceInventoryProperties(serviceName, svc, true);
            services.add(svc);
        }
        this.discoverPluginServices(services);
        String windowsServices = this.getManager().getProperty("windows.services.discover");
        if (windowsServices != null) {
            this.discoverWindowsServices(windowsServices, services);
        }
        return services;
    }
}

