/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory;

import org.hyperic.hq.appdef.shared.AIPlatformValue;
import org.hyperic.hq.appdef.shared.AIServerExtValue;
import org.hyperic.hq.appdef.shared.AIServerValue;
import org.hyperic.hq.appdef.shared.AIServiceValue;
import org.hyperic.hq.product.RuntimeResourceReport;
import org.hyperic.util.ArrayUtil;
import org.hyperic.util.StringUtil;

public class CompositeRuntimeResourceReport {
    private boolean isSyncScan = false;
    private RuntimeResourceReport[] _serverReports = new RuntimeResourceReport[0];

    public RuntimeResourceReport[] getServerReports() {
        return this._serverReports;
    }

    public boolean isSyncScan() {
        return this.isSyncScan;
    }

    public void setIsSyncScan(boolean isSyncScan) {
        this.isSyncScan = isSyncScan;
    }

    public void setServerReports(RuntimeResourceReport[] serverReports) {
        this._serverReports = serverReports;
    }

    public void addServerReport(RuntimeResourceReport report) {
        if (report == null) {
            return;
        }
        Object[] newReportArray = new RuntimeResourceReport[]{report};
        this._serverReports = (RuntimeResourceReport[])ArrayUtil.combine((Object[])this._serverReports, (Object[])newReportArray);
    }

    public String toString() {
        return "[CompositeRRR " + StringUtil.arrayToString((Object[])this._serverReports) + "]";
    }

    public boolean isSameReport(CompositeRuntimeResourceReport other) {
        RuntimeResourceReport[] rrr2;
        if (other == null) {
            return false;
        }
        RuntimeResourceReport[] rrr1 = this.getServerReports();
        if (rrr1.length != (rrr2 = other.getServerReports()).length) {
            return false;
        }
        for (int i = 0; i < rrr1.length; ++i) {
            boolean foundMatchingRRR = false;
            for (int j = 0; j < rrr2.length; ++j) {
                if (!rrr1[i].isSameReport(rrr2[j])) continue;
                foundMatchingRRR = true;
                break;
            }
            if (foundMatchingRRR) continue;
            return false;
        }
        return true;
    }

    public String simpleSummary() {
        String rstr = "[CompositeRRR ";
        for (int i = 0; i < this._serverReports.length; ++i) {
            rstr = rstr + "\n\tReport #" + i + " from " + "reporting server=" + this._serverReports[i].getServerId() + ": ";
            AIPlatformValue[] platforms = this._serverReports[i].getAIPlatforms();
            for (int j = 0; j < platforms.length; ++j) {
                rstr = rstr + "\n\t\tPlatform #" + j + " ID=" + platforms[j].getId() + " FQDN=" + platforms[j].getFqdn();
                AIServerValue[] servers = platforms[j].getAIServerValues();
                if (servers == null || servers.length == 0) continue;
                for (int k = 0; k < servers.length; ++k) {
                    rstr = rstr + "\n\t\t\tServer #" + k + " ID=" + servers[k].getId() + " Name=" + servers[k].getName() + " Stype=" + servers[k].getServerTypeName();
                    if (!(servers[k] instanceof AIServerExtValue)) continue;
                    AIServiceValue[] services = ((AIServerExtValue)servers[k]).getAIServiceValues();
                    rstr = rstr + " serviceCount=" + (services != null ? services.length : -1);
                }
            }
        }
        return rstr + "\n]";
    }

    public String fullSummary() {
        StringBuilder rstr = new StringBuilder(1024);
        rstr.append("[CompositeRRR ");
        for (int i = 0; i < this._serverReports.length; ++i) {
            rstr.append("\n\tReport #").append(i).append(" from reporting server=").append(this._serverReports[i].getServerId()).append(": ");
            AIPlatformValue[] platforms = this._serverReports[i].getAIPlatforms();
            if (platforms == null) continue;
            for (int j = 0; j < platforms.length; ++j) {
                AIPlatformValue platform = platforms[j];
                Integer platformId = platform.getId();
                String platformFqdn = platform.getFqdn();
                String platformName = platform.getName();
                String platformType = platform.getPlatformTypeName();
                rstr.append("\n\t\tPlatform #").append(j).append(" ID=").append(platformId).append(" FQDN=").append(platformFqdn).append(" Name=").append(platformName).append(" Type=").append(platformType);
                AIServerValue[] servers = platforms[j].getAIServerValues();
                rstr.append(" serverCount=").append(servers != null ? servers.length : -1);
                if (servers == null) continue;
                for (int k = 0; k < servers.length; ++k) {
                    AIServerValue server = servers[k];
                    Integer serverId = server.getId();
                    String serverName = server.getName();
                    String serverType = server.getServerTypeName();
                    rstr.append("\n\t\t\tServer #").append(k).append(" ID=").append(serverId).append(" Name=").append(serverName).append(" Stype=").append(serverType);
                    if (!(servers[k] instanceof AIServerExtValue)) continue;
                    AIServiceValue[] services = ((AIServerExtValue)servers[k]).getAIServiceValues();
                    rstr.append(" serviceCount=").append(services != null ? services.length : -1);
                    if (services == null) continue;
                    for (int m = 0; m < services.length; ++m) {
                        AIServiceValue service = services[m];
                        Integer serviceId = service.getId();
                        String serviceName = service.getName();
                        String serviceType = service.getServiceTypeName();
                        rstr.append("\n\t\t\t\tService #").append(m).append(" ID=").append(serviceId).append(" Name=").append(serviceName).append(" Type=").append(serviceType);
                    }
                }
            }
        }
        rstr.append("\n]");
        return rstr.toString();
    }
}

