/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hyperic.hq.appdef.shared.AIServerExtValue;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.hq.product.ServiceType;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.EncodingException;

public class ServerResource {
    List services = new ArrayList();
    List serviceTypes = new ArrayList();
    private AIServerExtValue resource = new AIServerExtValue();
    private String[] connectProps = null;
    private String fqdn = null;
    private ConfigResponse productConfig = null;
    private ConfigResponse metricConfig = null;
    private ConfigResponse controlConfig = null;
    private ConfigResponse cprops = null;

    public Object getResource() {
        if (this.connectProps != null) {
            if (this.metricConfig != null) {
                this.resource.addMetricConnectHashCode(this.metricConfig, this.connectProps);
            }
            if (this.productConfig != null) {
                this.resource.addMetricConnectHashCode(this.productConfig, this.connectProps);
            }
        }
        return this.resource;
    }

    public void setPlatformFqdn(String name) {
        this.fqdn = name;
    }

    public String getPlatformFqdn() {
        return this.fqdn;
    }

    public void setConnectProperties(String[] keys) {
        this.connectProps = keys;
    }

    public String[] getConnectProperties() {
        return this.connectProps;
    }

    public void addService(ServiceResource service) {
        this.services.add(service.resource);
    }

    public void addServiceType(ServiceType serviceType) {
        this.serviceTypes.add(serviceType.getAIServiceTypeValue());
    }

    public void setInstallPath(String name) {
        this.resource.setInstallPath(name);
    }

    public String getInstallPath() {
        return this.resource.getInstallPath();
    }

    public void setIdentifier(String name) {
        this.resource.setAutoinventoryIdentifier(name);
    }

    public String getIdentifier() {
        return this.resource.getAutoinventoryIdentifier();
    }

    public void setType(GenericPlugin plugin) {
        this.resource.setServerTypeName(plugin.getTypeInfo().getName());
    }

    public void setType(String name) {
        this.resource.setServerTypeName(name);
    }

    public String getType() {
        return this.resource.getServerTypeName();
    }

    public void setName(String name) {
        this.resource.setName(name);
    }

    public String getName() {
        return this.resource.getName();
    }

    public void setDescription(String description) {
        this.resource.setDescription(description);
    }

    public String getDescription() {
        return this.resource.getDescription();
    }

    private RuntimeException encodeException() {
        return new RuntimeException("Error encoding config");
    }

    public ConfigResponse getProductConfig() {
        return this.productConfig;
    }

    public void setProductConfig(ConfigResponse config) {
        if (config == null) {
            return;
        }
        this.productConfig = config;
        try {
            this.resource.setProductConfig(config.encode());
        }
        catch (EncodingException e) {
            throw this.encodeException();
        }
    }

    public ConfigResponse getMeasurementConfig() {
        return this.metricConfig;
    }

    public void setMeasurementConfig(ConfigResponse config) {
        if (config == null) {
            return;
        }
        this.metricConfig = config;
        try {
            this.resource.setMeasurementConfig(config.encode());
        }
        catch (EncodingException e) {
            throw this.encodeException();
        }
    }

    public void setMeasurementConfig(ConfigResponse config, int logTrackLevel) {
        LogTrackPlugin.setEnabled(config, 3, logTrackLevel);
        this.setMeasurementConfig(config);
    }

    public ConfigResponse getControlConfig() {
        return this.controlConfig;
    }

    public void setControlConfig(ConfigResponse config) {
        if (config == null) {
            return;
        }
        this.controlConfig = config;
        try {
            this.resource.setControlConfig(config.encode());
        }
        catch (EncodingException e) {
            throw this.encodeException();
        }
    }

    public void setProductConfig() {
        this.resource.setProductConfig(ConfigResponse.EMPTY_CONFIG);
    }

    public void setMeasurementConfig() {
        this.resource.setMeasurementConfig(ConfigResponse.EMPTY_CONFIG);
    }

    public void setControlConfig() {
        this.resource.setControlConfig(ConfigResponse.EMPTY_CONFIG);
    }

    public ConfigResponse getCustomProperties() {
        return this.cprops;
    }

    public void setCustomProperties(ConfigResponse config) {
        if (config == null) {
            return;
        }
        this.cprops = config;
        try {
            this.resource.setCustomProperties(config.encode());
        }
        catch (EncodingException e) {
            throw this.encodeException();
        }
    }

    public void setCustomProperty(String key, String value) {
        if (this.cprops == null) {
            this.cprops = new ConfigResponse();
        }
        this.cprops.setValue(key, value);
        this.setCustomProperties(this.cprops);
    }

    public void setProductConfig(Map config) {
        this.setProductConfig(new ConfigResponse(config));
    }

    public void setMeasurementConfig(Map config) {
        this.setMeasurementConfig(new ConfigResponse(config));
    }

    public void setControlConfig(Map config) {
        this.setControlConfig(new ConfigResponse(config));
    }

    public void setCustomProperties(Map props) {
        this.setCustomProperties(new ConfigResponse(props));
    }

    public String toString() {
        return this.resource.toString();
    }
}

