/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.PropertyUtil;
import org.hyperic.util.PropertyUtilException;
import org.hyperic.util.file.FileUtil;
import org.hyperic.util.security.SecurityUtil;

public class PropertyEncryptionUtil {
    private static final char[] KEY_ENCRYPTION_KEY = new char[]{'S', 'e', 'c', 'u', 'r', 'i', 't', 'y', ' ', 'K', 'u', 'n', 'g', '-', 'F', 'u'};
    private static final String ENCRYPTION_KEY_PROP = "k";
    private static final String LOCK_FILE_NAME = System.getProperty("java.io.tmpdir") + "/agent.encrypt.lock";
    private static final PropertyFileLock propertyLock;
    private static final Log LOG;

    public static synchronized char[] getPropertyEncryptionKey(String fileName) throws PropertyUtilException {
        char[] encryptionKey;
        block13: {
            if (fileName == null || fileName.trim().length() < 1) {
                throw new PropertyUtilException("Invalid argument: fileName [" + fileName + "]");
            }
            File encryptionKeyFile = new File(fileName);
            if (!encryptionKeyFile.exists()) {
                throw new PropertyUtilException("The encryption key file [" + fileName + "] does not exist.");
            }
            encryptionKey = null;
            FileInputStream fis = null;
            try {
                Properties props = new Properties();
                fis = new FileInputStream(encryptionKeyFile);
                props.load(fis);
                String encryptedKey = props.getProperty(ENCRYPTION_KEY_PROP);
                if (encryptedKey != null) {
                    encryptionKey = SecurityUtil.decrypt(KEY_ENCRYPTION_KEY, encryptedKey).toCharArray();
                    break block13;
                }
                throw new PropertyUtilException("The properties encryption key is invalid.");
            }
            catch (Exception exc) {
                throw new PropertyUtilException(exc);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        return encryptionKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void ensurePropertiesEncryption(String propsFileName, String encryptionKeyFileName, Set<String> secureProps) throws PropertyUtilException {
        char[] encryptionKey;
        block15: {
            if (propsFileName == null || propsFileName.trim().length() < 1) {
                throw new PropertyUtilException("Illegal Argument: propsFileName [" + propsFileName + "]");
            }
            encryptionKey = null;
            int tries = 10;
            while (tries > 0 && !propertyLock.lock()) {
                --tries;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignore) {}
            }
            if (tries <= 0) {
                throw new PropertyUtilException(propsFileName + " is locked. can't continue.");
            }
            if (propsFileName == null || propsFileName.trim().length() < 1) {
                throw new PropertyUtilException("Invalid argument: propsFileName [" + propsFileName + "]");
            }
            if (encryptionKeyFileName == null || encryptionKeyFileName.trim().length() < 1) {
                throw new PropertyUtilException("Invalid argument: encryptionKeyFileName [" + encryptionKeyFileName + "]");
            }
            if (secureProps != null && secureProps.size() >= 1) break block15;
            SecurityUtil.clearSensitiveData(encryptionKey);
            propertyLock.unlock();
            return;
        }
        try {
            Properties props = PropertyUtil.loadProperties(propsFileName);
            boolean alreadyEncrypted = PropertyEncryptionUtil.isAlreadyEncrypted(props);
            File encryptionKeyFile = new File(encryptionKeyFileName);
            if (encryptionKeyFile.exists()) {
                encryptionKey = PropertyEncryptionUtil.getPropertyEncryptionKey(encryptionKeyFileName);
            } else {
                if (alreadyEncrypted) {
                    throw new PropertyUtilException("The properties are already encrypted but the encryption key is missing.");
                }
                encryptionKey = PropertyEncryptionUtil.createAndStorePropertyEncryptionKey(encryptionKeyFileName);
            }
            HashMap<String, String> unEncProps = new HashMap<String, String>();
            Enumeration<?> propKeys = props.propertyNames();
            while (propKeys.hasMoreElements()) {
                String key = (String)propKeys.nextElement();
                String value = props.getProperty(key);
                if (value == null || !secureProps.contains(key) || SecurityUtil.isMarkedEncrypted(value)) continue;
                unEncProps.put(key, value);
            }
            if (unEncProps.size() > 0) {
                PropertyUtil.storeProperties(propsFileName, encryptionKey, unEncProps);
            }
        }
        catch (Throwable throwable) {
            SecurityUtil.clearSensitiveData(encryptionKey);
            propertyLock.unlock();
            throw throwable;
        }
        SecurityUtil.clearSensitiveData(encryptionKey);
        propertyLock.unlock();
    }

    static synchronized char[] createAndStorePropertyEncryptionKey(String fileName) throws PropertyUtilException {
        String encryptionKey;
        if (fileName == null || fileName.trim().length() < 1) {
            throw new PropertyUtilException("Invalid argument: fileName [" + fileName + "]");
        }
        File encryptionKeyFile = new File(fileName);
        if (encryptionKeyFile.exists()) {
            throw new PropertyUtilException("There is an attempt to override encryption key file [" + fileName + "]");
        }
        FileOutputStream fos = null;
        try {
            encryptionKey = SecurityUtil.generateRandomToken();
            String encryptedKey = SecurityUtil.encrypt(KEY_ENCRYPTION_KEY, encryptionKey);
            Properties props = new Properties();
            props.put(ENCRYPTION_KEY_PROP, encryptedKey);
            fos = new FileOutputStream(fileName);
            props.store(fos, null);
            File encKeyFile = new File(fileName);
            FileUtil.setReadWriteOnlyByOwner(encKeyFile);
        }
        catch (Exception exc) {
            throw new PropertyUtilException(exc);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ignore) {}
        }
        return encryptionKey.toCharArray();
    }

    private static boolean isAlreadyEncrypted(Properties props) {
        for (Object value : props.values()) {
            if (!SecurityUtil.isMarkedEncrypted((String)value)) continue;
            return true;
        }
        return false;
    }

    static {
        File lockFile = new File(LOCK_FILE_NAME);
        lockFile.deleteOnExit();
        propertyLock = new PropertyFileLock(lockFile);
        LOG = LogFactory.getLog(PropertyEncryptionUtil.class);
    }

    private static class PropertyFileLock {
        private final File lockFile;
        private RandomAccessFile randomAccessFile = null;

        public PropertyFileLock(File lockFile) {
            this.lockFile = lockFile;
        }

        public boolean lock() {
            boolean isLockAquired = false;
            try {
                this.randomAccessFile = new RandomAccessFile(this.lockFile, "rw");
                FileLock lock = this.randomAccessFile.getChannel().tryLock();
                isLockAquired = lock != null;
            }
            catch (OverlappingFileLockException oflEx) {
                System.err.println("Couldn't acquire lock. The lock is already held by another process.\nDetails: " + oflEx.getMessage());
            }
            catch (IOException ioe) {
                System.err.println("Couldn't acquire lock. An unexpected exception caught.\nDetails: " + ioe.getMessage());
            }
            return isLockAquired;
        }

        public void unlock() {
            if (this.randomAccessFile != null) {
                try {
                    this.randomAccessFile.close();
                    this.randomAccessFile = null;
                }
                catch (IOException ioe) {
                    System.err.println("Couldn't unlock: " + ioe.getMessage());
                }
            } else {
                LOG.debug((Object)"Unlock is called without a matching lock.");
            }
        }
    }
}

