/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.math;

import java.lang.reflect.Array;

public class Average {
    public static Double average(Object values) {
        Double retVal = new Double(0.0);
        try {
            for (int i = 0; i < Array.getLength(values); ++i) {
                retVal = Average.runningAverage(retVal, Array.get(values, i), i + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public static Double weightedAverage(Object values, Object weights) {
        Double retVal = new Double(0.0);
        try {
            int i;
            float wSum = 0.0f;
            for (i = 0; i < Array.getLength(weights); ++i) {
                wSum += Array.getFloat(weights, i);
            }
            for (i = 0; i < Array.getLength(values); ++i) {
                retVal = Average.runningAverage(retVal, Array.get(values, i), i + 1, Array.getFloat(weights, i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public static Double runningAverage(Object average, Object next, int count) {
        return Average.runningAverage(average, next, count, 1.0f);
    }

    public static Double runningAverage(Object average, Object next, int count, float weight) {
        if (average == null || count == 1) {
            return new Double((double)weight * ((Number)next).doubleValue());
        }
        double nextvalue = ((Number)next).doubleValue();
        double avg = (double)(count - 1) / (double)count * ((Number)average).doubleValue() + (double)weight * (1.0 / (double)count * nextvalue);
        return new Double(avg);
    }

    private Average() {
    }
}

