/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.Who;

public class WhoLogTrackPlugin
implements Runnable {
    private LogTrackPlugin plugin;
    private Sigar sigar;
    private long lastTime;

    public WhoLogTrackPlugin(LogTrackPlugin plugin) {
        this.plugin = plugin;
        this.sigar = new Sigar();
        this.lastTime = System.currentTimeMillis();
    }

    public void shutdown() {
        this.sigar.close();
    }

    @Override
    public void run() {
        Who[] logins;
        try {
            logins = this.sigar.getWhoList();
        }
        catch (SigarException e) {
            return;
        }
        for (int i = 0; i < logins.length; ++i) {
            Who who = logins[i];
            long time = who.getTime() * 1000L;
            if (time < this.lastTime) continue;
            String msg = "login: " + who.getUser() + " " + who.getDevice();
            String host = who.getHost();
            if (host.length() != 0) {
                msg = msg + " (" + host + ")";
            }
            this.plugin.reportEvent(time, 6, "system", msg);
        }
        this.lastTime = System.currentTimeMillis();
    }
}

