/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.server;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.hyperic.hq.agent.AgentAssertionException;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentConfigException;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.hq.agent.AgentLifecycle;
import org.hyperic.hq.agent.AgentMonitorValue;
import org.hyperic.hq.agent.AgentStartupCallback;
import org.hyperic.hq.agent.AgentUpgradeManager;
import org.hyperic.hq.agent.diagnostics.AgentDiagnostics;
import org.hyperic.hq.agent.server.AgentConnectionListener;
import org.hyperic.hq.agent.server.AgentNotificationHandler;
import org.hyperic.hq.agent.server.AgentRunningException;
import org.hyperic.hq.agent.server.AgentServerHandler;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.AgentStorageException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.agent.server.AgentTransportLifecycle;
import org.hyperic.hq.agent.server.CommandDispatcher;
import org.hyperic.hq.agent.server.CommandInvokerUtil;
import org.hyperic.hq.agent.server.CommandListener;
import org.hyperic.hq.agent.server.DefaultConnectionListener;
import org.hyperic.hq.agent.server.LoggingOutputStream;
import org.hyperic.hq.agent.server.ServerHandlerLoader;
import org.hyperic.hq.agent.server.monitor.AgentMonitorException;
import org.hyperic.hq.agent.server.monitor.AgentMonitorInterface;
import org.hyperic.hq.agent.server.monitor.AgentMonitorSimple;
import org.hyperic.hq.agent.stats.AgentStatsWriter;
import org.hyperic.hq.autoinventory.SyncModeManager;
import org.hyperic.hq.bizapp.client.AgentCallbackClient;
import org.hyperic.hq.bizapp.client.PlugininventoryCallbackClient;
import org.hyperic.hq.bizapp.client.StorageProviderFetcher;
import org.hyperic.hq.product.AutoinventoryPluginManager;
import org.hyperic.hq.product.ControlPluginManager;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.LogTrackPluginManager;
import org.hyperic.hq.product.MeasurementPluginManager;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginInfo;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.util.PluginLoader;
import org.hyperic.util.security.SecurityUtil;
import org.tanukisoftware.wrapper.WrapperManager;

public class AgentDaemon
extends AgentMonitorSimple {
    public static final String NOTIFY_AGENT_UP = AgentDaemon.class.getName() + ".agentUp";
    public static final String NOTIFY_AGENT_DOWN = AgentDaemon.class.getName() + ".agentDown";
    public static final String NOTIFY_AGENT_FAILED_START = AgentDaemon.class.getName() + ".agentFailedStart";
    public static final String PROP_CERTDN = "agent.certDN";
    public static final String PROP_HOSTNAME = "agent.hostName";
    private static final String AGENT_COMMANDS_SERVER_JAR_NAME = "dcs-agent-handler-commands";
    private static final String PROP_KEYSTORE_PATH = "javax.net.ssl.keyStore";
    private static final String PROP_KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String PROP_TRUSTSTORE_PATH = "javax.net.ssl.trustStore";
    private static final String PROP_TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private static AgentDaemon mainInstance;
    private static Object mainInstanceLock;
    private final double startTime;
    private static final Log logger;
    private final ServerHandlerLoader handlerLoader;
    private final PluginLoader handlerClassLoader;
    private CommandDispatcher dispatcher;
    private AgentStorageProvider storageProvider;
    private SyncModeManager syncModeManager;
    private CommandListener listener;
    private AgentTransportLifecycle agentTransportLifecycle;
    private Vector<AgentServerHandler> serverHandlers;
    private Vector<AgentServerHandler> startedHandlers = new Vector();
    private final Hashtable<String, Vector<AgentNotificationHandler>> notifyHandlers = new Hashtable();
    private Hashtable<String, AgentMonitorInterface> monitorClients;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ProductPluginManager ppm;
    private final AgentConfig config;
    private AgentDiagnostics agentDiagnostics;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgentDaemon getMainInstance() {
        Object object = mainInstanceLock;
        synchronized (object) {
            return mainInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AgentDaemon(AgentConfig config) {
        this.handlerClassLoader = PluginLoader.create((String)"ServerHandlerLoader", (ClassLoader)this.getClass().getClassLoader());
        this.handlerLoader = new ServerHandlerLoader((ClassLoader)this.handlerClassLoader);
        this.startTime = System.currentTimeMillis();
        this.config = config;
        Object object = mainInstanceLock;
        synchronized (object) {
            if (mainInstance == null) {
                mainInstance = this;
            }
        }
    }

    public CommandDispatcher getCommandDispatcher() {
        return this.dispatcher;
    }

    public ProductPluginManager getProductPluginManager() {
        return this.ppm;
    }

    public MeasurementPluginManager getMeasurementPluginManager() {
        return this.ppm.getMeasurementPluginManager();
    }

    public AutoinventoryPluginManager getAutoinventoryPluginManager() {
        return this.ppm.getAutoinventoryPluginManager();
    }

    public ControlPluginManager getControlPluginManager() {
        return this.ppm.getControlPluginManager();
    }

    public LogTrackPluginManager getLogTrackPluginManager() {
        return this.ppm.getLogTrackPluginManager();
    }

    private static File getAgentCommandsServerJar(String libHandlersDir) throws FileNotFoundException {
        File[] jars = new File(libHandlersDir).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName();
                return name.startsWith(AgentDaemon.AGENT_COMMANDS_SERVER_JAR_NAME);
            }
        });
        if (jars == null || jars.length != 1) {
            throw new FileNotFoundException("dcs-agent-handler-commands jar is not optional");
        }
        return jars[0];
    }

    private static File[] getOtherCommandsServerJars(String libHandlersDir) {
        File[] jars = new File(libHandlersDir).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName();
                return name.endsWith(".jar") && !name.startsWith(AgentDaemon.AGENT_COMMANDS_SERVER_JAR_NAME);
            }
        });
        if (jars == null) {
            return new File[0];
        }
        return jars;
    }

    public static AgentDaemon newInstance(AgentConfig cfg) throws AgentConfigException {
        AgentDaemon res = new AgentDaemon(cfg);
        try {
            res.configure();
            AgentCallbackClient.setAgentConfig(cfg);
        }
        catch (AgentRunningException exc) {
            throw new AgentAssertionException("New agent should not be running", (Throwable)((Object)exc));
        }
        return res;
    }

    public PluginManager getPluginManager(String type) throws AgentRunningException, PluginException {
        if (!this.isRunning()) {
            throw new AgentRunningException("Plugin manager cannot be retrieved if the Agent is not running");
        }
        return this.ppm.getPluginManager(type);
    }

    public TypeInfo getTypeInfo(String type, String platformType) throws AgentRunningException, PluginException {
        if (!this.isRunning()) {
            throw new AgentRunningException("Type info cannot be retrieved if the Agent is not running");
        }
        if (platformType != null) {
            return this.ppm.getTypeInfo(platformType, type);
        }
        Map typeInfos = this.ppm.getTypeInfo(type);
        if (!MapUtils.isEmpty((Map)typeInfos)) {
            return (TypeInfo)typeInfos.values().iterator().next();
        }
        return null;
    }

    public TypeInfo getTypeInfo(String type) throws AgentRunningException, PluginException {
        return this.getTypeInfo(type, null);
    }

    public AgentStorageProvider getStorageProvider() throws AgentRunningException {
        if (!this.isRunning()) {
            throw new AgentRunningException("Storage cannot be retrieved if the Agent is not running");
        }
        return this.storageProvider;
    }

    public AgentConfig getBootConfig() {
        return this.config;
    }

    public String getCurrentAgentBundle() {
        String agentBundleHome = this.getBootConfig().getBootProperties().getProperty(AgentConfig.PROP_BUNDLEHOME[0]);
        File bundleDir = new File(agentBundleHome);
        return bundleDir.getName();
    }

    public AgentTransportLifecycle getAgentTransportLifecycle() throws AgentRunningException {
        if (!this.isRunning()) {
            throw new AgentRunningException("Agent Transport Lifecycle cannot be retrieved if the Agent is not running");
        }
        return this.agentTransportLifecycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNotifyHandler(AgentNotificationHandler handler, String msgClass) {
        Hashtable<String, Vector<AgentNotificationHandler>> hashtable = this.notifyHandlers;
        synchronized (hashtable) {
            Vector<AgentNotificationHandler> handlers = this.notifyHandlers.get(msgClass);
            if (handlers == null) {
                handlers = new Vector();
                this.notifyHandlers.put(msgClass, handlers);
            }
            handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(String msgClass, String message) {
        Hashtable<String, Vector<AgentNotificationHandler>> hashtable = this.notifyHandlers;
        synchronized (hashtable) {
            Vector<AgentNotificationHandler> handlers = this.notifyHandlers.get(msgClass);
            if (handlers == null) {
                return;
            }
            for (AgentNotificationHandler handler : handlers) {
                handler.handleNotification(msgClass, message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanup() throws AgentRunningException {
        if (this.isRunning()) {
            throw new AgentRunningException("Agent cannot be cleaned up while running");
        }
        if (this.startedHandlers != null) {
            for (int i = 0; i < this.startedHandlers.size(); ++i) {
                AgentServerHandler handler = this.startedHandlers.get(i);
                handler.shutdown();
            }
            this.serverHandlers = null;
            this.startedHandlers = null;
        }
        this.dispatcher = null;
        if (this.listener != null) {
            this.listener.cleanup();
            this.listener = null;
        }
        if (this.storageProvider != null) {
            try {
                this.storageProvider.flush();
            }
            catch (AgentStorageException exc) {
                logger.error((Object)"Failed to flush Agent storage", (Throwable)exc);
            }
            finally {
                this.storageProvider.dispose();
                this.storageProvider = null;
            }
        }
        try {
            if (this.ppm != null) {
                this.ppm.shutdown();
            }
        }
        catch (PluginException pluginException) {
            // empty catch block
        }
    }

    public static AgentStorageProvider createStorageProvider(AgentConfig cfg) throws AgentConfigException {
        AgentStorageProvider provider;
        Class<?> storageClass;
        try {
            storageClass = Class.forName(cfg.getStorageProvider());
        }
        catch (ClassNotFoundException exc) {
            throw new AgentConfigException("Storage provider not found: " + exc.getMessage());
        }
        try {
            provider = (AgentStorageProvider)storageClass.newInstance();
            provider.init(cfg);
        }
        catch (IllegalAccessException exc) {
            throw new AgentConfigException("Unable to access storage provider '" + cfg.getStorageProvider() + "': " + exc.getMessage());
        }
        catch (InstantiationException exc) {
            throw new AgentConfigException("Unable to instantiate storage provider '" + cfg.getStorageProvider() + "': " + exc.getMessage());
        }
        catch (AgentStorageException exc) {
            throw new AgentConfigException("Storage provider unable to initialize: " + exc.getMessage());
        }
        return provider;
    }

    public void configure() throws AgentRunningException, AgentConfigException {
        File agentCommandsServerJar;
        if (this.isRunning()) {
            throw new AgentRunningException("Agent cannot be configured while running");
        }
        String libHandlersLibDir = this.config.getBootProperties().getProperty(AgentConfig.PROP_LIB_HANDLERS_LIB[0]);
        File handlersLib = new File(libHandlersLibDir);
        if (handlersLib.exists()) {
            this.handlerClassLoader.addURL(handlersLib);
        }
        this.setSslSystemProperties();
        this.dispatcher = new CommandDispatcher();
        this.storageProvider = AgentDaemon.createStorageProvider(this.config);
        this.syncModeManager = new SyncModeManager(this.storageProvider);
        String platformName = this.config.getBootProperties().getProperty("platform.name");
        String currentHost = null != platformName ? platformName : GenericPlugin.getPlatformName();
        this.storageProvider.setValue(PROP_HOSTNAME, currentHost);
        this.listener = new CommandListener(this.dispatcher);
        DefaultConnectionListener defListener = new DefaultConnectionListener(this.config);
        this.setConnectionListener(defListener);
        if (this.config.isProxyServerSet()) {
            logger.info((Object)("Setting proxy server: host=" + this.config.getProxyIp() + "; port=" + this.config.getProxyPort()));
            System.setProperty("lather.proxyHost", this.config.getProxyIp());
            System.setProperty("lather.proxyPort", String.valueOf(this.config.getProxyPort()));
        }
        this.serverHandlers = new Vector();
        String libHandlersDir = this.config.getBootProperties().getProperty(AgentConfig.PROP_LIB_HANDLERS[0]);
        try {
            agentCommandsServerJar = AgentDaemon.getAgentCommandsServerJar(libHandlersDir);
        }
        catch (FileNotFoundException e) {
            throw new AgentConfigException(e.getMessage());
        }
        this.loadAgentServerHandlerJars(new File[]{agentCommandsServerJar});
        File[] otherCommandsServerJars = AgentDaemon.getOtherCommandsServerJars(libHandlersDir);
        this.loadAgentServerHandlerJars(otherCommandsServerJars);
        String certDN = this.storageProvider.getValue(PROP_CERTDN);
        if (certDN == null || certDN.length() == 0) {
            certDN = this.generateCertDN();
            this.storageProvider.setValue(PROP_CERTDN, certDN);
            try {
                this.storageProvider.flush();
            }
            catch (AgentStorageException ase) {
                throw new AgentConfigException("Error storing certdn in agent storage: " + (Object)((Object)ase));
            }
        }
    }

    private void setSslSystemProperties() throws AgentConfigException {
        String keystorePassword;
        AgentKeystoreConfig keystoreConfig = new AgentKeystoreConfig(this.config.getBootProperties());
        try {
            keystorePassword = String.valueOf(keystoreConfig.getFilePassword());
        }
        catch (IOException e) {
            throw new AgentConfigException("Couldn't set SSL system properties. Failed to get keystore password.", (Exception)e);
        }
        this.setSystemProperty(PROP_KEYSTORE_PATH, keystoreConfig.getFilePath());
        logger.info((Object)String.format("Plugins keystore set to %s", keystoreConfig.getFilePath()));
        this.setSystemProperty(PROP_KEYSTORE_PASSWORD, keystorePassword);
        logger.info((Object)String.format("Plugins truststore set to %s", keystoreConfig.getFilePath()));
        this.setSystemProperty(PROP_TRUSTSTORE_PATH, keystoreConfig.getFilePath());
        this.setSystemProperty(PROP_TRUSTSTORE_PASSWORD, keystorePassword);
    }

    private void setSystemProperty(String key, String value) {
        if (key != null && value != null) {
            System.setProperty(key, value);
        } else {
            logger.info((Object)String.format("System property of %s wasn't initialized.", key));
        }
    }

    private void loadAgentServerHandlerJars(File[] libJars) throws AgentConfigException {
        ClassLoader currentContext = Thread.currentThread().getContextClassLoader();
        JarFile jarFile = null;
        for (File libJar : libJars) {
            try {
                jarFile = new JarFile(libJar);
                Manifest manifest = jarFile.getManifest();
                String mainClass = manifest.getMainAttributes().getValue("Main-Class");
                if (mainClass != null) {
                    String jarPath = libJar.getAbsolutePath();
                    AgentServerHandler loadedHandler = this.handlerLoader.loadServerHandler(jarPath);
                    this.serverHandlers.add(loadedHandler);
                    this.dispatcher.addServerHandler(loadedHandler);
                }
                jarFile.close();
            }
            catch (Exception e) {
                throw new AgentConfigException("Failed to load '" + libJar + "': " + e.getMessage());
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        Thread.currentThread().setContextClassLoader(currentContext);
    }

    private String generateCertDN() {
        return "CAM-AGENT-" + SecurityUtil.generateRandomToken();
    }

    public String[] getMonitors() throws AgentMonitorException {
        return this.monitorClients.keySet().toArray(new String[0]);
    }

    public double getStartTime() throws AgentMonitorException {
        return this.startTime;
    }

    public double getUpTime() throws AgentMonitorException {
        return (double)System.currentTimeMillis() - this.startTime;
    }

    public double getJVMTotalMemory() throws AgentMonitorException {
        return Runtime.getRuntime().totalMemory();
    }

    public double getJVMFreeMemory() throws AgentMonitorException {
        return Runtime.getRuntime().freeMemory();
    }

    public double getNumActiveThreads() throws AgentMonitorException {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    public void registerMonitor(String monitorName, AgentMonitorInterface monitor) {
        this.monitorClients.put(monitorName, monitor);
    }

    public AgentMonitorValue[] getMonitorValues(String monitorName, String[] monitorKeys) {
        AgentMonitorInterface iface = this.monitorClients.get(monitorName);
        if (iface == null) {
            AgentMonitorValue badVal = new AgentMonitorValue();
            badVal.setErrCode(3);
            AgentMonitorValue[] res = new AgentMonitorValue[monitorKeys.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = badVal;
            }
            return res;
        }
        return iface.getMonitorValues(monitorKeys);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public SyncModeManager getSyncModeManager() {
        return this.syncModeManager;
    }

    public void die() throws AgentRunningException {
        if (!this.running.get()) {
            throw new AgentRunningException("Agent is not running");
        }
        this.listener.die();
        this.running.set(false);
        this.storageProvider.dispose();
        this.agentDiagnostics.die();
    }

    public void setConnectionListener(AgentConnectionListener newListener) throws AgentRunningException {
        this.listener.setConnectionListener(newListener);
    }

    private void restartPluginManagers() throws AgentStartException {
        try {
            Properties bootProps = this.config.getBootProperties();
            String pluginDir = bootProps.getProperty(AgentConfig.PROP_PDK_PLUGIN_DIR[0]);
            this.ppm.init();
            this.ppm.registerPlugins(pluginDir);
            logger.info((Object)"Product Plugin Manager initalized");
        }
        catch (Exception e) {
            logger.error((Object)"Error initializing plugins ", (Throwable)e);
            throw new AgentStartException("Unable to initialize plugin manager: " + e.getMessage());
        }
    }

    public void sendPluginStatusToServer(boolean resyncAgentPlugins) {
        Set pluginInfos = this.ppm.getPluginInfos();
        PluginStatusSenderThread thread = new PluginStatusSenderThread("PluginStatusSender", pluginInfos, resyncAgentPlugins, this.config);
        thread.setDaemon(true);
        thread.start();
    }

    private void startHandlers() throws AgentStartException {
        for (int i = 0; i < this.serverHandlers.size(); ++i) {
            AgentServerHandler handler = this.serverHandlers.get(i);
            try {
                handler.startup(this);
            }
            catch (AgentStartException exc) {
                logger.error((Object)("Error starting plugin " + handler), (Throwable)((Object)exc));
                throw exc;
            }
            catch (Exception exc) {
                logger.error((Object)"Unknown exception", (Throwable)exc);
                throw new AgentStartException("Error starting plugin " + handler, exc);
            }
            this.startedHandlers.add(handler);
        }
    }

    private final void postInitActions() throws AgentStartException {
        for (AgentServerHandler handler : this.startedHandlers) {
            handler.postInitActions();
        }
    }

    private void cleanTmpDir(String tmp) {
        File dir = new File(tmp);
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            try {
                file.delete();
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
    }

    private PrintStream newLogStream(String stream, Properties props) {
        Logger logger = Logger.getLogger((String)stream);
        String logLevel = props.getProperty("agent.logLevel." + stream);
        if (logLevel == null) {
            return null;
        }
        Level level = Level.toLevel((String)logLevel);
        return new PrintStream(new LoggingOutputStream((Category)logger, (Priority)level), true);
    }

    private void redirectStreams(Properties props) {
        PrintStream stream = this.newLogStream("SystemOut", props);
        if (stream != null) {
            System.setOut(stream);
        }
        if ((stream = this.newLogStream("SystemErr", props)) != null) {
            System.setErr(stream);
        }
    }

    public void start() throws AgentStartException {
        this.running.set(true);
        boolean agentStarted = false;
        try {
            logger.info((Object)("Agent starting up, bundle name=" + this.getCurrentAgentBundle()));
            Properties bootProps = this.config.getBootProperties();
            String tmpDir = bootProps.getProperty(AgentConfig.PROP_TMPDIR[0]);
            if (tmpDir != null) {
                try {
                    List updatedPlugins = AgentUpgradeManager.updatePlugins((Properties)bootProps);
                    if (!updatedPlugins.isEmpty()) {
                        logger.info((Object)("Successfully updated plugins: " + updatedPlugins));
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to update plugins", (Throwable)e);
                }
                this.cleanTmpDir(tmpDir);
                System.setProperty("java.io.tmpdir", tmpDir);
            }
            this.monitorClients = new Hashtable();
            this.registerMonitor("agent", this);
            this.registerMonitor("agent.commandListener", this.listener);
            this.redirectStreams(bootProps);
            String agentTransportLifecycleClass = "org.hyperic.hq.agent.server.AgentTransportLifecycleImpl";
            try {
                Class clazz = this.handlerClassLoader.loadClass(agentTransportLifecycleClass);
                Constructor constructor = clazz.getConstructor(AgentDaemon.class, AgentConfig.class, AgentStorageProvider.class);
                this.agentTransportLifecycle = (AgentTransportLifecycle)constructor.newInstance(this, this.getBootConfig(), this.getStorageProvider());
            }
            catch (ClassNotFoundException e) {
                throw new AgentStartException("Cannot find agent transport lifecycle class: " + agentTransportLifecycleClass);
            }
            this.ppm = new ProductPluginManager(bootProps);
            this.restartPluginManagers();
            this.startHandlers();
            this.agentTransportLifecycle.startAgentTransport();
            this.listener.setup();
            this.tryForceAgentFailure();
            logger.info((Object)"Agent started successfully");
            this.sendNotification(NOTIFY_AGENT_UP, "we're up, baby!");
            agentStarted = true;
            AgentStatsWriter statsWriter = new AgentStatsWriter(this.config);
            if (this.isStatsEnabled()) {
                statsWriter.startWriter();
            }
            this.postInitActions();
            if (this.isStatsEnabled()) {
                this.agentDiagnostics = AgentDiagnostics.getInstance();
                this.agentDiagnostics.setConfig(this.config);
                this.agentDiagnostics.start();
            }
            this.listener.listenLoop();
            this.sendNotification(NOTIFY_AGENT_DOWN, "goin' down, baby!");
            if (this.isStatsEnabled()) {
                statsWriter.stopWriter();
            }
        }
        catch (AgentStartException exc) {
            logger.error((Object)exc.getMessage(), (Throwable)((Object)exc));
            throw exc;
        }
        catch (Exception exc) {
            logger.error((Object)"Error running agent", (Throwable)exc);
            throw new AgentStartException("Error running agent: " + exc.getMessage(), exc);
        }
        catch (Throwable exc) {
            logger.error((Object)"Critical error running agent", exc);
            if (this.storageProvider != null) {
                this.storageProvider.dispose();
                this.storageProvider = null;
            }
            throw new AgentStartException("Critical shutdown");
        }
        finally {
            if (!agentStarted) {
                logger.debug((Object)"Notifying that agent startup failed");
                this.sendNotification(NOTIFY_AGENT_FAILED_START, "agent startup failed!");
            }
            if (this.agentTransportLifecycle != null) {
                this.agentTransportLifecycle.stopAgentTransport();
            }
            this.running.set(false);
            try {
                this.cleanup();
            }
            catch (AgentRunningException e) {
                logger.error((Object)e, (Throwable)((Object)e));
            }
            if (this.storageProvider != null) {
                this.storageProvider.dispose();
            }
        }
    }

    private boolean isStatsEnabled() {
        return !Boolean.getBoolean("disableStats");
    }

    private void tryForceAgentFailure() throws AgentStartException {
        String rollbackBundle = this.getBootConfig().getBootProperties().getProperty(AgentConfig.PROP_ROLLBACK_AGENT_BUNDLE_UPGRADE[0]);
        if (this.getCurrentAgentBundle().equals(rollbackBundle)) {
            throw new AgentStartException(AgentConfig.PROP_ROLLBACK_AGENT_BUNDLE_UPGRADE[0] + " property set to force rollback of agent bundle upgrade: " + rollbackBundle);
        }
    }

    public void restartGracefully() {
        logger.info((Object)"Restarting agent gracefully");
        this.agentTransportLifecycle.stopAgentTransportGracefully();
        AgentUpgradeManager.restartJVM();
    }

    public void applyPluginsChanges() throws IOException, PluginException, AgentStartException {
        logger.info((Object)"about to apply some cleanups because of plugin changes");
        this.triggerStopScanCommand();
        this.ppm.shutdown();
        this.applyPluginsChangesOnHandlers();
        AgentUpgradeManager.updatePlugins((Properties)this.config.getBootProperties());
        this.restartPluginManagers();
        this.triggerStartScanCommand();
        this.sendPluginStatusToServer(false);
    }

    private void applyPluginsChangesOnHandlers() {
        if (this.startedHandlers != null) {
            for (int i = 0; i < this.startedHandlers.size(); ++i) {
                AgentServerHandler handler = this.startedHandlers.get(i);
                handler.refreshOnPluginsChange();
            }
        }
    }

    private void triggerStopScanCommand() {
        try {
            CommandInvokerUtil.triggerStopScanCommand();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void triggerStartScanCommand() {
        try {
            CommandInvokerUtil.triggerStartScanCommand();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        mainInstanceLock = new Object();
        logger = LogFactory.getLog(AgentDaemon.class);
    }

    public static class RunnableAgent
    implements Runnable,
    AgentLifecycle {
        private final AgentConfig config;
        private AgentDaemon agent;

        public RunnableAgent(AgentConfig config) {
            this.config = config;
        }

        public void shutdown() {
            try {
                if (this.agent != null) {
                    this.agent.die();
                    this.agent.cleanup();
                }
            }
            catch (Throwable e) {
                logger.error((Object)e, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean isConfigured = false;
            try {
                this.agent = AgentDaemon.newInstance(this.config);
                isConfigured = true;
            }
            catch (Throwable e) {
                logger.error((Object)"Agent configuration failed: ", e);
            }
            finally {
                if (!isConfigured) {
                    this.cleanUpOnAgentConfigFailure(this.config);
                }
            }
            boolean isStarted = false;
            if (this.agent != null) {
                try {
                    this.agent.start();
                    isStarted = true;
                }
                catch (AgentStartException e) {
                    logger.error((Object)"Agent startup error: ", (Throwable)((Object)e));
                }
                catch (Exception e) {
                    logger.error((Object)"Agent startup failed: ", (Throwable)e);
                }
                finally {
                    if (!isStarted) {
                        this.cleanUpOnAgentStartFailure();
                    } else {
                        logger.info((Object)"Agent shut down");
                        System.exit(0);
                    }
                }
            }
        }

        private void cleanUpOnAgentConfigFailure(AgentConfig config) {
            try {
                AgentStartupCallback agentStartupCallback = new AgentStartupCallback(config);
                agentStartupCallback.onAgentStartup(false);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to callback on startup failure.", (Throwable)e);
            }
            this.cleanUpOnAgentStartFailure();
        }

        private void cleanUpOnAgentStartFailure() {
            if (!WrapperManager.isControlledByNativeWrapper()) {
                System.exit(-1);
            } else {
                this.rollbackAndRestartJVM();
            }
        }

        private void rollbackAndRestartJVM() {
            logger.info((Object)"Attempting to rollback agent bundle");
            boolean success = false;
            try {
                success = AgentUpgradeManager.rollback();
            }
            catch (IOException e) {
                logger.error((Object)"Unable to rollback agent bundle", (Throwable)e);
            }
            if (success) {
                logger.info((Object)"Rollback of agent bundle was successful");
            } else {
                logger.error((Object)"Rollback of agent bundle was not successful");
            }
            logger.info((Object)"Restarting JVM...");
            AgentUpgradeManager.restartJVM();
        }
    }

    private class PluginStatusSenderThread
    extends Thread {
        private static final int FIVE_SECONDS_IN_MILLIS = 5000;
        private static final int FIVE_MINUTES_IN_MILLIS = 300000;
        private final AgentConfig cfg;
        private final Collection<PluginInfo> plugins;
        private final boolean resyncAgentPlugins;

        public PluginStatusSenderThread(String name, Collection<PluginInfo> plugins, boolean resyncAgentPlugins, AgentConfig cfg) {
            super(name);
            this.plugins = plugins;
            this.cfg = cfg;
            this.resyncAgentPlugins = resyncAgentPlugins;
        }

        @Override
        public void run() {
            int counter = 0;
            while (true) {
                try {
                    AgentStorageProvider provider;
                    while ((provider = AgentDaemon.this.getStorageProvider()).getValue("covalent.CAMProviderURL") == null || provider.getValue("covalent.CAMAgentToken") == null) {
                        logger.debug((Object)"trying to send plugin status to the server but provider has not been setup, will sleep 5 seconds and retry");
                        Thread.sleep(5000L);
                    }
                    PlugininventoryCallbackClient client = new PlugininventoryCallbackClient(new StorageProviderFetcher(provider), this.plugins, this.resyncAgentPlugins, this.cfg);
                    logger.info((Object)"Sending plugin status to server");
                    client.sendPluginReportToServer();
                    logger.info((Object)"Successfully sent plugin status to server");
                }
                catch (Exception e) {
                    logger.warn((Object)"could not send plugin status to server, will retry:  ", (Throwable)e);
                    try {
                        if (++counter <= 3) {
                            logger.debug((Object)"sleeping for:5000");
                            Thread.sleep(5000L);
                            continue;
                        }
                        logger.debug((Object)"sleeping for:300000");
                        Thread.sleep(300000L);
                    }
                    catch (InterruptedException e2) {
                        logger.debug((Object)("interrupted:" + e2), (Throwable)e2);
                    }
                    continue;
                }
                break;
            }
        }
    }
}

