/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.server;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentAPI;
import org.hyperic.hq.agent.AgentCommand;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.autoinventory.AutoinventoryException;
import org.hyperic.hq.autoinventory.ScanConfigurationCore;
import org.hyperic.hq.autoinventory.Scanner;
import org.hyperic.hq.autoinventory.agent.AICommandsAPI;
import org.hyperic.hq.product.AutoinventoryPluginManager;
import org.hyperic.hq.product.PlatformResource;
import org.hyperic.util.config.ConfigResponse;

public class CommandInvokerUtil {
    private static final Log logger = LogFactory.getLog(CommandInvokerUtil.class);

    private static int getAICommandsAPIVersion() {
        return new AICommandsAPI().getVersion();
    }

    private static int getAgentAPIVersion() {
        return new AgentAPI().getVersion();
    }

    private static AgentCommand getAgentCommand(String commandName, AgentRemoteValue commandArg) {
        return new AgentCommand(CommandInvokerUtil.getAgentAPIVersion(), CommandInvokerUtil.getAICommandsAPIVersion(), commandName, commandArg);
    }

    private static void processRequestCommand(String commandName, AgentRemoteValue commandArg) throws AgentRemoteException {
        AgentCommand agentCommand = CommandInvokerUtil.getAgentCommand(commandName, commandArg);
        AgentDaemon.getMainInstance().getCommandDispatcher().processRequest(agentCommand, null, null);
    }

    public static void triggerCommand(String commandName, AgentRemoteValue commandArg) throws AgentRemoteException {
        try {
            logger.info((Object)("Triggering " + commandName + " command"));
            CommandInvokerUtil.processRequestCommand(commandName, commandArg);
        }
        catch (AgentRemoteException e) {
            logger.error((Object)("Failed to trigger " + commandName + " command"), (Throwable)e);
            throw e;
        }
    }

    public static void triggerStartScanCommand() throws AgentRemoteException, AutoinventoryException {
        try {
            logger.info((Object)"Triggering start scan command");
            AgentRemoteValue commandArg = new AgentRemoteValue();
            AutoinventoryPluginManager autoinventoryPluginManager = AgentDaemon.getMainInstance().getAutoinventoryPluginManager();
            PlatformResource defaultPlatformResource = Scanner.detectPlatform((AutoinventoryPluginManager)autoinventoryPluginManager, null);
            ConfigResponse defaultPlatformConfig = Scanner.getPlatformConfig((PlatformResource)defaultPlatformResource);
            ScanConfigurationCore scanConfigurationCore = new ScanConfigurationCore();
            scanConfigurationCore.setConfigResponse(defaultPlatformConfig);
            scanConfigurationCore.toAgentRemoteValue("scanConfig", commandArg);
            CommandInvokerUtil.processRequestCommand("autoinv:startScan", commandArg);
        }
        catch (AgentRemoteException e) {
            logger.error((Object)"Failed to trigger start scan command", (Throwable)e);
            throw e;
        }
        catch (AutoinventoryException e) {
            logger.error((Object)"Failed to trigger start scan command", (Throwable)e);
            throw e;
        }
    }

    public static void triggerStopScanCommand() throws AgentRemoteException {
        logger.info((Object)"Triggering stop scan command");
        CommandInvokerUtil.processRequestCommand("autoinv:stopScan", null);
    }
}

