/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.roo.support.util;

import java.io.InputStream;
import org.springframework.roo.support.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TemplateUtils {
    public static final String getTemplatePath(Class<?> clazz, String templateFilename) {
        Assert.notNull(clazz, "Owning class required");
        Assert.hasText(templateFilename, "Template filename required");
        Assert.isTrue(!templateFilename.startsWith("/"), "Template filename shouldn't start with a slash");
        return "/" + clazz.getPackage().getName().replace('.', '/') + "/" + templateFilename;
    }

    public static final InputStream getTemplate(Class<?> clazz, String templateFilename) {
        String templatePath = TemplateUtils.getTemplatePath(clazz, templateFilename);
        InputStream result = clazz.getResourceAsStream(templatePath);
        Assert.notNull(result, "Could not locate '" + templatePath + "' in classloader");
        return result;
    }
}

