/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.agent.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.AgentStorageException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.agent.server.monitor.AgentMonitorException;
import org.hyperic.hq.agent.server.monitor.AgentMonitorSimple;
import org.hyperic.hq.bizapp.client.AgentCallbackClientException;
import org.hyperic.hq.bizapp.client.MeasurementCallbackClient;
import org.hyperic.hq.bizapp.client.ProviderFetcher;
import org.hyperic.hq.bizapp.client.StorageProviderFetcher;
import org.hyperic.hq.common.SystemException;
import org.hyperic.hq.measurement.TimingVoodoo;
import org.hyperic.hq.measurement.agent.server.MeasurementSchedule;
import org.hyperic.hq.measurement.agent.server.SchedulerOffsetManager;
import org.hyperic.hq.measurement.agent.server.SendBatchResult;
import org.hyperic.hq.measurement.agent.server.Sender;
import org.hyperic.hq.measurement.agent.server.ServerTimeDiff;
import org.hyperic.hq.measurement.data.DSNList;
import org.hyperic.hq.measurement.data.MeasurementReport;
import org.hyperic.hq.measurement.data.MeasurementReportConstructor;
import org.hyperic.hq.measurement.server.session.SRN;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.util.Reference;
import org.hyperic.hq.util.properties.PropertiesUtil;
import org.hyperic.util.StringUtil;
import org.hyperic.util.encoding.Base64;

public class SenderThread
extends AgentMonitorSimple
implements Sender,
Runnable {
    private static final String PROP_METRICDUP = "agent.metricDup";
    private static final String PROP_MAXBATCHSIZE = "agent.maxBatchSize";
    private static final String PROP_METRICDEBUG = "agent.metricDebug";
    private static final long MAX_SERVERDIFF = 180000L;
    private static final int PROP_RECSIZE = 68;
    private static final int SEND_INTERVAL = 60000;
    private static final int MAX_BATCHSIZE = 500;
    private static final String MEASURENENT_LISTNAME = "measurement_spool";
    private static final String AVAILABILITY_LISTNAME = "availability_spool";
    private static final String TIMEDIFF_STORAGE_KEY = "server_agent_timediff";
    private static final long MINIMAL_TIMEDIFF_SYNC_INTERVAL = TimeUnit.SECONDS.toMillis(60L);
    private static final int MEASURENENT_MAX_RETRY_TIME = 5;
    private volatile boolean shouldDie = false;
    private final Log log = LogFactory.getLog(SenderThread.class);
    private final MeasurementCallbackClient client;
    private final AgentStorageProvider storage;
    private final LinkedList<Record> transitionQueue;
    private final AtomicBoolean regularMetricsReadyForProcess;
    private int metricDup = 0;
    private int maxBatchSize = 500;
    private final Set metricDebug;
    private final MeasurementSchedule schedule;
    private final SchedulerOffsetManager schedulerOffsetManager;
    private long serverDiff = 0L;
    private long stat_numBatchesSent = 0L;
    private long stat_totBatchSendTime = 0L;
    private long stat_totMetricsSent = 0L;
    private boolean deductServerTimeDiff;
    private boolean storedServerTimeDiff;

    SenderThread(AgentConfig bootConfig, AgentStorageProvider storage, MeasurementSchedule schedule, Properties config, SchedulerOffsetManager schedulerOffsetManager) throws AgentStartException {
        String sMetricDebug;
        String sMaxBatchSize;
        String AvailabilityInfo;
        this.storage = storage;
        this.client = this.setupClient(bootConfig);
        this.transitionQueue = new LinkedList();
        this.regularMetricsReadyForProcess = new AtomicBoolean(false);
        this.metricDebug = new HashSet();
        this.schedule = schedule;
        this.schedulerOffsetManager = schedulerOffsetManager;
        String measuementInfo = bootConfig.getBootProperties().getProperty(MEASURENENT_LISTNAME);
        if (measuementInfo != null) {
            storage.addOverloadedInfo(MEASURENENT_LISTNAME, measuementInfo);
        }
        if ((AvailabilityInfo = bootConfig.getBootProperties().getProperty(AVAILABILITY_LISTNAME)) != null) {
            storage.addOverloadedInfo(AVAILABILITY_LISTNAME, AvailabilityInfo);
        }
        try {
            this.storage.createList(MEASURENENT_LISTNAME, 68);
            this.storage.createList(AVAILABILITY_LISTNAME, 68);
        }
        catch (AgentStorageException ignore) {
            // empty catch block
        }
        String sMetricDup = bootConfig.getBootProperties().getProperty(PROP_METRICDUP);
        if (sMetricDup != null) {
            try {
                this.metricDup = Integer.parseInt(sMetricDup);
            }
            catch (NumberFormatException exc) {
                throw new AgentStartException("agent.metricDup is not a valid integer ('" + sMetricDup + "')");
            }
            this.log.info((Object)("Duplicating metrics " + this.metricDup + " times"));
        }
        if ((sMaxBatchSize = bootConfig.getBootProperties().getProperty(PROP_MAXBATCHSIZE)) != null) {
            try {
                this.maxBatchSize = Integer.parseInt(sMaxBatchSize);
            }
            catch (NumberFormatException exc) {
                throw new AgentStartException("agent.maxBatchSize is not a valid integer ('" + sMaxBatchSize + "')");
            }
        }
        if ((sMetricDebug = bootConfig.getBootProperties().getProperty(PROP_METRICDEBUG)) != null) {
            try {
                for (Object element : StringUtil.explode((String)sMetricDebug, (String)" ")) {
                    Integer metId = new Integer((String)element);
                    this.metricDebug.add(metId);
                    this.log.info((Object)("metricDebug:  Enabling special debugging for metric id=" + metId));
                }
            }
            catch (NumberFormatException exc) {
                throw new AgentStartException("agent.metricDebug must contain integers seperated by spaces");
            }
        }
        this.log.info((Object)("Maximum metric batch size set to " + this.maxBatchSize));
        this.deductServerTimeDiff = PropertiesUtil.getBooleanValue((String)config.getProperty("agent.deductServerTimeDiff"), (boolean)true);
        this.storedServerTimeDiff = false;
    }

    private MeasurementCallbackClient setupClient(AgentConfig bootConfig) throws AgentStartException {
        StorageProviderFetcher fetcher = new StorageProviderFetcher(this.storage);
        return new MeasurementCallbackClient((ProviderFetcher)fetcher, bootConfig);
    }

    void die() {
        this.shouldDie = true;
    }

    private static Record decodeRecord(String val) throws IOException {
        ByteArrayInputStream bIs = new ByteArrayInputStream(Base64.decode((String)val));
        DataInputStream dIs = new DataInputStream(bIs);
        long derivedID = dIs.readLong();
        long retTime = dIs.readLong();
        long dsnID = dIs.readLong();
        MetricValue measVal = new MetricValue(dIs.readDouble(), retTime);
        return new Record(dsnID, measVal, derivedID);
    }

    private static String encodeRecord(Record record) throws IOException {
        ByteArrayOutputStream bOs = new ByteArrayOutputStream();
        DataOutputStream dOs = new DataOutputStream(bOs);
        dOs.writeLong(record.derivedID);
        dOs.writeLong(record.data.getTimestamp());
        dOs.writeLong(record.dsnId);
        dOs.writeDouble(record.data.getValue());
        return Base64.encode((byte[])bOs.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processData(long dsnId, MetricValue data, long samplingInterval, long derivedID, boolean isAvail) {
        if (!data.equals((Object)MetricValue.NONE)) {
            this.roundDownTimeStamp(data, samplingInterval);
        }
        double val = data.getValue();
        if (this.metricDebug.contains(new Long(derivedID))) {
            this.log.info((Object)("metricDebug:  Placing DSN='" + dsnId + "' derivedID=" + derivedID + " value=" + val + " time=" + data.getTimestamp() + " into transition queue"));
        }
        LinkedList<Record> linkedList = this.transitionQueue;
        synchronized (linkedList) {
            MetricValue measVal = new MetricValue(val, data.getTimestamp());
            this.transitionQueue.add(new Record(dsnId, measVal, derivedID, isAvail));
            if (!isAvail) {
                this.regularMetricsReadyForProcess.set(true);
            }
        }
        if (this.metricDup != 0) {
            ArrayList<Record> dupeList = new ArrayList<Record>();
            long dTime = data.getTimestamp();
            for (int i = 0; i < this.metricDup; ++i) {
                MetricValue measVal = new MetricValue(val, dTime + (long)i + 1L);
                dupeList.add(new Record(dsnId, measVal, derivedID, isAvail));
            }
            LinkedList<Record> linkedList2 = this.transitionQueue;
            synchronized (linkedList2) {
                this.transitionQueue.addAll(dupeList);
            }
        }
    }

    private void roundDownTimeStamp(MetricValue data, long samplingInterval) {
        if (this.deductServerTimeDiff && Math.abs(ServerTimeDiff.getInstance().getServerTimeDiff()) > 30000L) {
            data.setTimestamp(data.getTimestamp() + ServerTimeDiff.getInstance().getServerTimeDiff());
        }
        long offset = this.schedulerOffsetManager.getSchedluerOffsetForInterval(samplingInterval);
        data.setTimestamp(TimingVoodoo.roundDownTime((long)data.getTimestamp(), (long)samplingInterval, (long)offset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTransitionQueue() {
        LinkedList<Record> linkedList = this.transitionQueue;
        synchronized (linkedList) {
            for (Record rec : this.transitionQueue) {
                try {
                    String encodedRec = SenderThread.encodeRecord(rec);
                    if (rec.isAvail) {
                        this.storage.addToList(AVAILABILITY_LISTNAME, encodedRec);
                        continue;
                    }
                    this.storage.addToList(MEASURENENT_LISTNAME, encodedRec);
                }
                catch (Exception exc) {
                    this.log.error((Object)("Unable to store data: " + exc), (Throwable)exc);
                }
            }
            this.transitionQueue.clear();
            this.regularMetricsReadyForProcess.set(false);
            try {
                this.storage.flush();
            }
            catch (Exception exc) {
                this.log.error((Object)"Unable to flush storage", (Throwable)exc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SendBatchResult sendBatch(String listName, Reference<Integer> numSent, ConnectionPolicy connectionPolicy) {
        int numUsed;
        long batchStart = 0L;
        long batchEnd = 0L;
        long lastMetricTime = 0L;
        long serverTime = 0L;
        this.processTransitionQueue();
        int numDebuggedSent = 0;
        MeasurementReportConstructor constructor = new MeasurementReportConstructor();
        boolean debug = this.log.isDebugEnabled();
        this.log.debug((Object)"Sending batch to server:");
        HashSet<Record> records = new HashSet<Record>();
        Iterator it = this.storage.getListIterator(listName);
        for (numUsed = 0; it != null && it.hasNext() && numUsed < this.maxBatchSize; ++numUsed) {
            try {
                Record r = SenderThread.decodeRecord((String)it.next());
                boolean didNotAlreadyExist = records.add(r);
                if (didNotAlreadyExist) continue;
                if (debug) {
                    this.log.debug((Object)("Dropping duplicate entry for " + r));
                }
                --numUsed;
                continue;
            }
            catch (IOException exc) {
                this.log.error((Object)("Error accessing record -- deleting: " + exc), (Throwable)exc);
            }
        }
        int num = 0;
        long firstMetricTime = Long.MAX_VALUE;
        for (Record sendBatchResult : records) {
            lastMetricTime = sendBatchResult.data.getTimestamp();
            firstMetricTime = Math.min(lastMetricTime, firstMetricTime);
            if (debug) {
                this.log.debug((Object)("    Data:  d=" + sendBatchResult.derivedID + " r=" + sendBatchResult.dsnId + " t=" + sendBatchResult.data.getTimestamp() + " v=" + sendBatchResult.data));
            }
            if (this.metricDebug.contains(new Long(sendBatchResult.derivedID))) {
                ++numDebuggedSent;
                this.log.info((Object)("metricDebug:  Pulled DSN=" + sendBatchResult.dsnId + " derivedID=" + sendBatchResult.derivedID + " value=" + sendBatchResult.data.getValue() + " from tQueue -- sending"));
            }
            constructor.addDataPoint(sendBatchResult.derivedID, sendBatchResult.dsnId, sendBatchResult.data);
            ++num;
        }
        numSent.set((Object)num);
        if (numUsed == 0) {
            return new SendBatchResult(SendBatchResult.StatusBatchResult.SUCCESS_ALL);
        }
        DSNList[] clientIds = constructor.constructDSNList();
        boolean success = false;
        try {
            boolean closeConn;
            SRN[] srnList = this.schedule.getSRNsAsArray();
            if (srnList.length == 0) {
                this.log.error((Object)"Agent does not have valid SRNs, but has metric data to send, removing measurements");
                this.removeMeasurements(numUsed, listName);
                SendBatchResult sendBatchResult = new SendBatchResult(SendBatchResult.StatusBatchResult.ERROR_ALL);
                return sendBatchResult;
            }
            if (this.log.isDebugEnabled()) {
                for (SRN element : srnList) {
                    this.log.debug((Object)("    SRN: " + element.getEntity() + "=" + element.getRevisionNumber()));
                }
            }
            MeasurementReport measurementReport = this.createMeasurementReport(clientIds, srnList);
            batchStart = this.now();
            switch (connectionPolicy) {
                case CLOSE: {
                    this.log.error((Object)"Illegal state - Force closing connection on next Request");
                    closeConn = Boolean.parseBoolean(AgentConfig.getDefaultProperties().getProperty(AgentConfig.PROP_CLOSE_HTTP_CONNECTION_BY_DEFAULT[0]));
                    break;
                }
                case KEEP_ALIVE: {
                    closeConn = false;
                    break;
                }
                case CLOSE_ON_LAST_BATCH: {
                    closeConn = !it.hasNext();
                    break;
                }
                default: {
                    closeConn = false;
                }
            }
            serverTime = this.sendReportToServer(measurementReport, closeConn);
            batchEnd = this.now();
            this.syncToServerTime(batchEnd, serverTime);
            success = true;
        }
        catch (AgentCallbackClientException exc) {
            this.log.error((Object)("Error sending measurements: " + exc.getMessage()));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)exc.getStackTrace());
            }
            if (this.shouldRetry(exc)) {
                this.log.info((Object)"retrying measurement send");
                SendBatchResult sendBatchResult = new SendBatchResult(SendBatchResult.StatusBatchResult.ERROR_BATCH, firstMetricTime);
                return sendBatchResult;
            }
        }
        finally {
            if (numDebuggedSent != 0) {
                if (success) {
                    this.log.info((Object)("metricDebug:  Successfully sent " + numDebuggedSent + " debugged metrics to " + "server"));
                } else {
                    this.log.info((Object)("metricDebug:  Server reported failure when sent " + numDebuggedSent + " debugged metrics"));
                }
            }
        }
        if (success) {
            this.removeMeasurements(numUsed, listName);
            ++this.stat_numBatchesSent;
            this.stat_totBatchSendTime += batchEnd - batchStart;
            this.stat_totMetricsSent += (long)numUsed;
            if (numUsed == this.maxBatchSize) {
                return new SendBatchResult(SendBatchResult.StatusBatchResult.SUCCESS_BATCH, lastMetricTime);
            }
            return new SendBatchResult(SendBatchResult.StatusBatchResult.SUCCESS_ALL);
        }
        return new SendBatchResult(SendBatchResult.StatusBatchResult.ERROR_ALL);
    }

    private boolean shouldRetry(AgentCallbackClientException exc) {
        return !exc.getMessage().toLowerCase().endsWith("refused") && !exc.getMessage().endsWith("Permission denied") && exc.getMessage().indexOf("Service Unavailable") == -1 && exc.getExceptionOfType(SSLPeerUnverifiedException.class) == null;
    }

    @Override
    public void ensureSyncedToServerTime() {
        if (this.storedServerTimeDiff || this.isSyncTriedRecently()) {
            return;
        }
        this.syncToServerTime();
    }

    private void syncToServerTime() {
        long agentTime = this.now();
        try {
            this.syncToServerTime(agentTime, this.requestServerTime());
        }
        catch (AgentCallbackClientException e) {
            this.log.info((Object)"Couldn't sync time difference with the server. Time difference might not be accurate until communication with the server is set.");
            this.modifyServerTimeDiff(agentTime, agentTime + this.fetchStoredServerTimeDiff());
        }
    }

    public synchronized void syncToServerTime(long agentTime, long serverTime) {
        this.modifyServerTimeDiff(agentTime, serverTime);
        this.log.debug((Object)"Synced time difference with the server.");
        if (!this.storedServerTimeDiff) {
            this.storeServerTimeDiff();
        }
    }

    private boolean isSyncTriedRecently() {
        long elapsedTimeFromSync = this.now() - ServerTimeDiff.getInstance().getLastSync();
        return elapsedTimeFromSync < MINIMAL_TIMEDIFF_SYNC_INTERVAL;
    }

    private long requestServerTime() throws AgentCallbackClientException {
        MeasurementReport report = this.createMeasurementReport(new DSNList[0], new SRN[0]);
        boolean closeConn = Boolean.parseBoolean(AgentConfig.getDefaultProperties().getProperty(AgentConfig.PROP_CLOSE_HTTP_CONNECTION_BY_DEFAULT[0]));
        return this.sendReportToServer(report, closeConn);
    }

    private long fetchStoredServerTimeDiff() {
        try {
            Long timediff = Long.valueOf(this.storage.getValue(TIMEDIFF_STORAGE_KEY));
            return timediff;
        }
        catch (NumberFormatException e) {
            this.log.warn((Object)"Couldn't get server time difference from storage.");
            return 0L;
        }
    }

    private void storeServerTimeDiff() {
        String serverTimeDiff = String.valueOf(ServerTimeDiff.getInstance().getServerTimeDiff());
        this.storage.setValue(TIMEDIFF_STORAGE_KEY, serverTimeDiff);
        try {
            this.storage.flush();
            this.log.info((Object)"Stored server time difference.");
            this.storedServerTimeDiff = true;
        }
        catch (AgentStorageException e) {
            this.log.warn((Object)"Couldn't store server time difference.");
        }
    }

    private MeasurementReport createMeasurementReport(DSNList[] clientIds, SRN[] srnList) {
        MeasurementReport report = new MeasurementReport();
        report.setClientIdList(clientIds);
        report.setSRNList(srnList);
        return report;
    }

    private long sendReportToServer(MeasurementReport report, boolean closeConn) throws AgentCallbackClientException {
        long serverTime;
        try {
            serverTime = this.client.measurementSendReport(report, closeConn);
        }
        catch (IllegalArgumentException e) {
            throw new SystemException("error sending report: " + e + ", report=" + report, (Throwable)e);
        }
        return serverTime;
    }

    private void modifyServerTimeDiff(long agentTime, long serverTime) {
        this.serverDiff = Math.abs(serverTime - agentTime);
        ServerTimeDiff.getInstance().setServerTimeDiff(serverTime - agentTime);
        ServerTimeDiff.getInstance().setLastSync(agentTime);
        if (this.serverDiff > 180000L) {
            if (serverTime < agentTime) {
                this.log.error((Object)("Agent is " + this.serverDiff / 1000L + " seconds ahead of the server.  To " + "ensure accuracy of the charting and " + "alerting make sure the agent and server " + "clocks are synchronized"));
            } else {
                this.log.error((Object)("Agent is " + this.serverDiff / 1000L + " seconds behind the server.  To " + "ensure accuracy of the charting and " + "alerting make sure the agent and server " + "clocks are synchronized"));
            }
        }
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private int removeMeasurements(int num, String listName) {
        int j;
        Iterator i = this.storage.getListIterator(listName);
        for (j = 0; i != null && i.hasNext() && j < num; ++j) {
            i.next();
            i.remove();
        }
        try {
            this.storage.flush();
        }
        catch (AgentStorageException exc) {
            this.log.error((Object)"Failed to flush agent storage", (Throwable)exc);
        }
        if (j != num) {
            this.log.error((Object)("Failed to remove " + (num - j) + "records"));
        }
        return j;
    }

    public double getNumBatchesSent() throws AgentMonitorException {
        return this.stat_numBatchesSent;
    }

    public double getTotBatchSendTime() throws AgentMonitorException {
        return this.stat_totBatchSendTime;
    }

    public double getTotMetricsSent() throws AgentMonitorException {
        return this.stat_totMetricsSent;
    }

    public double getServerOffset() throws AgentMonitorException {
        return this.serverDiff;
    }

    @Override
    public void run() {
        Calendar controlCal = Calendar.getInstance();
        controlCal.setTimeInMillis(System.currentTimeMillis());
        Calendar cal = Calendar.getInstance();
        controlCal.set(13, 5);
        while (!this.shouldDie) {
            try {
                try {
                    controlCal.add(12, 1);
                    long now = System.currentTimeMillis();
                    cal.setTimeInMillis(now + 60000L);
                    if (cal.get(12) != controlCal.get(12)) {
                        long sleeptime = controlCal.getTimeInMillis() - now;
                        if (sleeptime > 0L) {
                            Thread.sleep(controlCal.getTimeInMillis() - now);
                        }
                    } else {
                        Thread.sleep(60000L);
                    }
                }
                catch (InterruptedException exc) {
                    this.log.info((Object)"Measurement sender interrupted");
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Woke up, sending batch of metrics.");
                }
                Reference numSent = new Reference((Object)0);
                boolean closeConnByDefault = Boolean.parseBoolean(AgentConfig.getDefaultProperties().getProperty(AgentConfig.PROP_CLOSE_HTTP_CONNECTION_BY_DEFAULT[0]));
                boolean closeConnAfterAvailabilityReport = closeConnByDefault && !this.regularMetricsReadyForProcess.get();
                this.sendData(AVAILABILITY_LISTNAME, (Reference<Integer>)numSent, closeConnAfterAvailabilityReport);
                this.sendData(MEASURENENT_LISTNAME, (Reference<Integer>)numSent, closeConnByDefault);
            }
            catch (Throwable e) {
                this.log.error((Object)e.getMessage(), e);
            }
        }
    }

    private void sendData(String listName, Reference<Integer> numSent, boolean closeConnWithLastBatch) {
        long total;
        String backlogNum = "";
        ConnectionPolicy connectionPolicy = closeConnWithLastBatch ? ConnectionPolicy.CLOSE_ON_LAST_BATCH : ConnectionPolicy.KEEP_ALIVE;
        long start = System.currentTimeMillis();
        SendBatchResult result = this.sendBatch(listName, numSent, connectionPolicy);
        if (!result.isDone()) {
            long retries = 1L;
            while (!(result = this.sendBatch(listName, numSent, connectionPolicy)).isDone()) {
                long now = System.currentTimeMillis();
                long tDiff = now - result.getTimeStamp();
                String backlog = Long.toString(tDiff / 60000L);
                if (tDiff / 60000L > 1L && !backlog.equals(backlogNum)) {
                    backlogNum = backlog;
                    this.log.info((Object)(backlog + " minute(s) of metrics backlogged"));
                }
                if (this.shouldDie) {
                    this.log.info((Object)"Dying with measurements backlogged");
                    return;
                }
                if (SendBatchResult.StatusBatchResult.ERROR_BATCH.equals((Object)result.getStatus())) {
                    ++retries;
                }
                if (SendBatchResult.StatusBatchResult.SUCCESS_BATCH.equals((Object)result.getStatus())) {
                    retries = 0L;
                }
                if (retries < 5L) continue;
                this.log.info((Object)"Reached measurement report max retries - dying with measurements backlogged");
                this.sendBatch(listName, numSent, ConnectionPolicy.CLOSE);
                return;
            }
        }
        if ((total = System.currentTimeMillis() - start) > 60000L) {
            this.log.info((Object)("Agent took " + total / 1000L + " seconds to send its " + listName + " metrics to the Server."));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Agent took " + total + " ms to send its " + listName));
        }
    }

    private static class Record {
        final long dsnId;
        final long derivedID;
        final MetricValue data;
        private Long hashCode = null;
        private final boolean isAvail;

        private Record(long dsnId, MetricValue data, long derivedID, boolean isAvail) {
            this.dsnId = dsnId;
            this.data = data;
            this.derivedID = derivedID;
            this.isAvail = isAvail;
        }

        public Record(long dsnID, MetricValue measVal, long derivedID) {
            this(dsnID, measVal, derivedID, false);
        }

        public int hashCode() {
            if (this.hashCode != null) {
                return this.hashCode.intValue();
            }
            Long timestamp = new Long(this.data.getTimestamp() * 71L);
            Long mId = new Long(this.derivedID * 71L);
            this.hashCode = new Long(7 + timestamp.hashCode() * 71 + mId.hashCode() * 71);
            return this.hashCode.hashCode();
        }

        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            if (rhs instanceof Record) {
                Record r = (Record)rhs;
                return r.derivedID == this.derivedID && r.data.getTimestamp() == this.data.getTimestamp();
            }
            return false;
        }

        public String toString() {
            return "mId=" + this.derivedID + ",timestamp=" + this.data.getTimestamp() + ",value=" + this.data.getValue() + ",isAvail=" + this.isAvail;
        }
    }

    private static enum ConnectionPolicy {
        CLOSE,
        KEEP_ALIVE,
        CLOSE_ON_LAST_BATCH;

    }
}

