/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.hyperic.hq.plugin.system.ProcessData;

public class ProcessReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long pid;
    private String owner;
    private String size;
    private String resident;
    private String share;
    private String cpuTotal;
    private String cpuPerc;
    private String memPerc;
    private char state;
    private String baseName;
    private String startTime;
    private String formatedTotalDiskBytes;
    private long totalDiskBytes;
    private String diskReadBytes;
    private String diskWrittenBytes;
    private String[] args;

    public ProcessReport() {
    }

    public ProcessReport(ProcessData process) {
        this.pid = process.getPid();
        this.owner = process.getOwner();
        this.startTime = process.getFormattedStartTime();
        this.size = process.getFormattedSize();
        this.resident = process.getFormattedResident();
        this.share = process.getFormattedShare();
        this.cpuTotal = process.getFormattedCpuTotal();
        this.cpuPerc = process.getFormattedCpuPerc();
        this.memPerc = process.getFormattedMemPerc();
        this.baseName = process.getBaseName();
        this.state = process.getState();
        this.setFormatedTotalDiskBytes(process.getFormattedTotalDiskBytes());
        this.setTotalDiskBytes(process.getTotalDiskBytes());
        this.setDiskReadBytes(process.getFormattedDiskReadBytes());
        this.setDiskWrittenBytes(process.getFormattedDiskWrittenBytes());
        this.setArgs(process.getProcArgs());
    }

    public long getPid() {
        return this.pid;
    }

    public void setPid(long pid) {
        this.pid = pid;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getResident() {
        return this.resident;
    }

    public void setResident(String resident) {
        this.resident = resident;
    }

    public String getShare() {
        return this.share;
    }

    public void setShare(String share) {
        this.share = share;
    }

    public String getCpuPerc() {
        return this.cpuPerc;
    }

    public void setCpuPerc(String cpuPerc) {
        this.cpuPerc = cpuPerc;
    }

    public String getMemPerc() {
        return this.memPerc;
    }

    public void setMemPerc(String memPerc) {
        this.memPerc = memPerc;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    public String getCpuTotal() {
        return this.cpuTotal;
    }

    public void setCpuTotal(String cpuTotal) {
        this.cpuTotal = cpuTotal;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public char getState() {
        return this.state;
    }

    public void setState(char state) {
        this.state = state;
    }

    public String[] getArgs() {
        return this.args;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public String getFormatedTotalDiskBytes() {
        return this.formatedTotalDiskBytes;
    }

    public void setFormatedTotalDiskBytes(String totalDiskBytes) {
        this.formatedTotalDiskBytes = totalDiskBytes;
    }

    public String getDiskReadBytes() {
        return this.diskReadBytes;
    }

    public void setDiskReadBytes(String diskReadBytes) {
        this.diskReadBytes = diskReadBytes;
    }

    public String getDiskWrittenBytes() {
        return this.diskWrittenBytes;
    }

    public void setDiskWrittenBytes(String diskWrittenBytes) {
        this.diskWrittenBytes = diskWrittenBytes;
    }

    public long getTotalDiskBytes() {
        return this.totalDiskBytes;
    }

    public void setTotalDiskBytes(long totalDiskBytes) {
        this.totalDiskBytes = totalDiskBytes;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.pid = in.readLong();
        this.owner = in.readUTF();
        this.size = in.readUTF();
        this.resident = in.readUTF();
        this.share = in.readUTF();
        this.cpuTotal = in.readUTF();
        this.cpuPerc = in.readUTF();
        this.memPerc = in.readUTF();
        this.baseName = in.readUTF();
        this.startTime = in.readUTF();
        this.state = in.readChar();
        this.args = (String[])in.readObject();
        this.formatedTotalDiskBytes = in.readUTF();
        this.totalDiskBytes = in.readLong();
        this.diskReadBytes = in.readUTF();
        this.diskWrittenBytes = in.readUTF();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.pid);
        out.writeUTF(this.owner);
        out.writeUTF(this.size);
        out.writeUTF(this.resident);
        out.writeUTF(this.share);
        out.writeUTF(this.cpuTotal);
        out.writeUTF(this.cpuPerc);
        out.writeUTF(this.memPerc);
        out.writeUTF(this.baseName);
        out.writeUTF(this.startTime);
        out.writeChar(this.state);
        out.writeObject(this.args);
        out.writeUTF(this.formatedTotalDiskBytes);
        out.writeLong(this.totalDiskBytes);
        out.writeUTF(this.diskReadBytes);
        out.writeUTF(this.diskWrittenBytes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("pid=").append(this.pid).append(", owner=").append(this.owner).append(", size=").append(this.size).append(", resident=").append(this.resident).append(", share=").append(this.share).append(", cpuTotal=").append(this.cpuTotal).append(", cpuPerc=").append(this.cpuPerc).append(", memPerc=").append(this.memPerc).append(", baseName = ").append(this.baseName).append(", startTime = ").append(this.startTime).append(", args = ");
        for (String arg : this.args) {
            if (arg.equalsIgnoreCase("")) continue;
            sb.append(arg).append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.args);
        result = 31 * result + (this.baseName == null ? 0 : this.baseName.hashCode());
        result = 31 * result + (this.cpuPerc == null ? 0 : this.cpuPerc.hashCode());
        result = 31 * result + (this.cpuTotal == null ? 0 : this.cpuTotal.hashCode());
        result = 31 * result + (this.memPerc == null ? 0 : this.memPerc.hashCode());
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        result = 31 * result + (int)(this.pid ^ this.pid >>> 32);
        result = 31 * result + (this.resident == null ? 0 : this.resident.hashCode());
        result = 31 * result + (this.share == null ? 0 : this.share.hashCode());
        result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        result = 31 * result + this.state;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessReport other = (ProcessReport)obj;
        if (!Arrays.equals(this.args, other.args)) {
            return false;
        }
        if (this.baseName == null ? other.baseName != null : !this.baseName.equals(other.baseName)) {
            return false;
        }
        if (this.cpuPerc == null ? other.cpuPerc != null : !this.cpuPerc.equals(other.cpuPerc)) {
            return false;
        }
        if (this.cpuTotal == null ? other.cpuTotal != null : !this.cpuTotal.equals(other.cpuTotal)) {
            return false;
        }
        if (this.memPerc == null ? other.memPerc != null : !this.memPerc.equals(other.memPerc)) {
            return false;
        }
        if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
            return false;
        }
        if (this.pid != other.pid) {
            return false;
        }
        if (this.resident == null ? other.resident != null : !this.resident.equals(other.resident)) {
            return false;
        }
        if (this.share == null ? other.share != null : !this.share.equals(other.share)) {
            return false;
        }
        if (this.size == null ? other.size != null : !this.size.equals(other.size)) {
            return false;
        }
        if (this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime)) {
            return false;
        }
        return this.state == other.state;
    }
}

