/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.transport;

import java.lang.reflect.Constructor;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.transport.PollerClient;
import org.hyperic.hq.transport.util.TransportUtils;

public class AgentTransport {
    private final Object lock = new Object();
    private final PollerClient pollerClient;
    private boolean stopped;

    public AgentTransport(AgentConfig config, AgentStorageProvider storageProvider, long pollingFrequency, int asyncThreadPoolSize) throws Exception {
        this.pollerClient = this.createPollerClient(config, storageProvider, pollingFrequency, asyncThreadPoolSize);
    }

    private PollerClient createPollerClient(AgentConfig config, AgentStorageProvider storageProvider, long pollingFrequency, int i) throws ClassNotFoundException, Exception {
        Class clazz;
        try {
            clazz = TransportUtils.tryLoadUnidirectionalTransportPollerClient();
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException("Unidirectional transport is not available in .ORG");
        }
        Constructor constructor = clazz.getConstructor(AgentConfig.class, AgentStorageProvider.class, Long.TYPE, Integer.TYPE);
        return (PollerClient)constructor.newInstance(config, storageProvider, pollingFrequency, i);
    }

    public void registerService(Class<?> serviceInterface, Object serviceImpl) {
        this.pollerClient.registerService(serviceInterface, serviceImpl);
    }

    public void start() throws Exception {
        if (this.isStopped()) {
            return;
        }
        this.pollerClient.start();
    }

    public void stop() throws InterruptedException {
        this.pollerClient.stop();
        this.setStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStopped() {
        Object object = this.lock;
        synchronized (object) {
            this.stopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStopped() {
        Object object = this.lock;
        synchronized (object) {
            return this.stopped;
        }
    }

    private static class BootStrapService {
        private BootStrapService() {
        }

        void doNothing() {
        }
    }
}

