/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snmp4j.smi.OctetString;

public class ArgumentParser {
    public static final String[] TYPES = new String[]{"i", "l", "s", "o"};
    public static final int TYPE_INTEGER = 0;
    public static final int TYPE_LONG = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_OCTET_STRING = 3;
    private Map optionFormat;
    private Map parameterFormat;

    public ArgumentParser(String optionFormat, String parameterFormat) {
        this.optionFormat = ArgumentParser.parseFormat(optionFormat, false);
        this.parameterFormat = ArgumentParser.parseFormat(parameterFormat, true);
    }

    public Map getOptionFormat() {
        return this.optionFormat;
    }

    public Map getParameterFormat() {
        return this.parameterFormat;
    }

    protected static Map parseFormat(String format, boolean parameterFormat) {
        LinkedHashMap<String, ArgumentFormat> options = new LinkedHashMap<String, ArgumentFormat>();
        ArgumentFormat last = null;
        StringTokenizer st = new StringTokenizer(format, " ");
        while (st.hasMoreTokens()) {
            ArgumentFormat af;
            block19: {
                String token;
                block13: {
                    token = st.nextToken();
                    if ("..".equals(token)) {
                        if (last != null) {
                            last.vararg = true;
                            break;
                        }
                        throw new IllegalArgumentException("'..' without parameter definition");
                    }
                    last = af = new ArgumentFormat();
                    af.parameter = parameterFormat;
                    af.mandatory = token.charAt(0) != '+';
                    token = token.substring(1);
                    if (!token.endsWith("]")) break block13;
                    af.option = token.substring(0, token.indexOf(91));
                    token = token.substring(af.option.length() + 1, token.length() - 1);
                    StringTokenizer pt = new StringTokenizer(token, ",", true);
                    ArrayList<ArgumentParameter> params = new ArrayList<ArgumentParameter>();
                    String inRegex = null;
                    int i = 1;
                    while (pt.hasMoreTokens()) {
                        block16: {
                            ArgumentParameter ap;
                            String param;
                            block18: {
                                block17: {
                                    block15: {
                                        block14: {
                                            param = pt.nextToken();
                                            if (inRegex == null) break block14;
                                            param = inRegex = inRegex + param;
                                            break block15;
                                        }
                                        if (",".equals(param)) break block16;
                                    }
                                    if (param.indexOf(60) > 0) {
                                        inRegex = param;
                                    }
                                    ap = new ArgumentParameter();
                                    ap.name = "" + i;
                                    if (!param.endsWith(">")) break block17;
                                    inRegex = null;
                                    int regexPos = param.indexOf(60);
                                    ap.pattern = Pattern.compile(param.substring(regexPos + 1, param.length() - 1));
                                    param = param.substring(0, regexPos);
                                    break block18;
                                }
                                if (inRegex != null) break block16;
                            }
                            if (param.endsWith("}")) {
                                ap.type = ArgumentParser.getType(param.substring(0, param.indexOf("{")));
                                param = param.substring(param.indexOf(123) + 1, param.length() - 1);
                                int posEqual = param.indexOf(61);
                                if (posEqual >= 0) {
                                    ap.defaultValue = param.substring(posEqual + 1);
                                    ap.name = param.substring(0, posEqual);
                                } else {
                                    ap.name = param;
                                }
                            } else {
                                ap.type = ArgumentParser.getType(param);
                            }
                            params.add(ap);
                        }
                        ++i;
                    }
                    ArgumentFormat.access$802(af, params.toArray(new ArgumentParameter[params.size()]));
                    break block19;
                }
                af.option = token;
                if (af.parameter) {
                    throw new IllegalArgumentException("Parameter " + token + " has no type");
                }
            }
            options.put(af.option, af);
        }
        return options;
    }

    private static int getType(String type) {
        return Arrays.binarySearch(TYPES, type);
    }

    public Map parse(String[] args) throws ParseException {
        LinkedHashMap options = new LinkedHashMap();
        Iterator params = this.parameterFormat.values().iterator();
        ArgumentFormat lastFormat = null;
        for (int i = 0; i < args.length; ++i) {
            ArgumentFormat format;
            if (args[i].length() == 0) continue;
            if (args[i].charAt(0) == '-') {
                String option = args[i].substring(1);
                format = (ArgumentFormat)this.optionFormat.get(option);
                if (format == null) {
                    throw new ParseException("Unknown option '" + option + "' at position " + i, i);
                }
            } else {
                ArgumentFormat argumentFormat = params.hasNext() ? (ArgumentFormat)params.next() : (format = lastFormat != null && lastFormat.isVariableLength() ? lastFormat : null);
                if (format == null) {
                    throw new ParseException("Unrecognized parameter at position " + i, i);
                }
            }
            if (format.getParameters() != null && format.getParameters().length > 0) {
                int diff = format.isParameter() ? 1 : 0;
                List values = this.parseValues(args, i + (1 - diff), format);
                i += Math.max(values.size() - diff, 0);
                if (format.isVariableLength() && options.containsKey(format.getOption())) {
                    List extValues = (List)options.get(format.getOption());
                    extValues.addAll(values);
                } else {
                    this.addValues2Option(format.getOption(), values, options);
                }
            } else {
                this.addValues2Option(format.getOption(), null, options);
            }
            lastFormat = format;
        }
        while (params.hasNext()) {
            ArgumentFormat af = (ArgumentFormat)params.next();
            if (!af.isMandatory()) continue;
            throw new ArgumentParseException(-1, null, af, af.getParameters()[0]);
        }
        Iterator it = this.optionFormat.values().iterator();
        while (it.hasNext()) {
            ArgumentFormat of = (ArgumentFormat)it.next();
            if (!of.isMandatory() || options.containsKey(of.getOption())) continue;
            ArrayList<Object> defaults = new ArrayList<Object>();
            for (int i = 0; i < of.getParameters().length; ++i) {
                if (of.getParameters()[i].getDefaultValue() == null) continue;
                defaults.add(this.parseParameterValue(of.getParameters()[i], of.getParameters()[i].getDefaultValue(), of, i));
            }
            if (defaults.size() == 0) {
                throw new ArgumentParseException(-1, null, of, of.getParameters()[0]);
            }
            this.addValues2Option(of.getOption(), defaults, options);
        }
        return options;
    }

    protected void addValues2Option(String option, List values, Map options) {
        List existingValues = (List)options.get(option);
        if (existingValues != null && values != null) {
            existingValues.addAll(values);
        } else {
            options.put(option, values);
        }
    }

    protected List parseValues(String[] args, int offset, ArgumentFormat format) throws ParseException {
        int numParams = format.getParameters().length;
        ArrayList<Object> values = new ArrayList<Object>(numParams);
        for (int i = 0; i + offset < args.length && i < numParams; ++i) {
            try {
                values.add(this.parseParameterValue(format.getParameters()[i], args[i + offset], format, i + offset));
                continue;
            }
            catch (ArgumentParseException apex) {
                throw apex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                int pos = i + offset;
                throw new ArgumentParseException(pos, args[pos], format, format.getParameters()[i]);
            }
        }
        return values;
    }

    protected Object parseParameterValue(ArgumentParameter type, String value, ArgumentFormat format, int pos) throws ArgumentParseException {
        Matcher m;
        if (value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 2);
        }
        if (type.pattern != null && !(m = type.pattern.matcher(value)).matches()) {
            throw new ArgumentParseException("Value '" + value + "' for " + (format.isParameter() ? "parameter " : "option ") + format.getOption() + (format.getParameters().length > 1 ? " part " + type.getName() : "") + " does not match pattern '" + type.pattern.pattern() + "'", pos, value, format, type);
        }
        switch (type.getType()) {
            case 0: {
                return new Integer(value);
            }
            case 1: {
                return new Long(value);
            }
            case 3: {
                return OctetString.fromHexString(value, ':');
            }
        }
        return value;
    }

    public static Object getFirstValue(List optionValues) {
        if (optionValues != null && optionValues.size() > 0) {
            return optionValues.get(0);
        }
        return null;
    }

    public static Object getValue(Map args, String name, int index) {
        List values = (List)args.get(name);
        if (values != null && values.size() > index) {
            return values.get(index);
        }
        return null;
    }

    public static void main(String[] args) {
        ArgumentParser argumentparser = new ArgumentParser(System.getProperty("org.snmp4j.OptionFormat", "-o1[i{parameter1}] -o2[s,l]"), System.getProperty("org.snmp4j.ParameterFormat", "-param1[i] -param2[s<(udp|tcp):.*[/[0-9]+]?>{=udp:127.0.0.1/161}] +optParam1[l{=-100}] .."));
        System.out.println("Option format is: " + argumentparser.getOptionFormat());
        System.out.println("Parameter format is: " + argumentparser.getParameterFormat());
        Map options = null;
        try {
            options = argumentparser.parse(args);
            System.out.println(options);
        }
        catch (ParseException ex) {
            System.err.println("Failed to parse args: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static String[] selectCommand(String[] args, String optionFormat, String[][] commandSets) throws ParseException {
        ArgumentParser ap = new ArgumentParser(optionFormat, "#command[s] +following[s] ..");
        Map params = ap.parse(args);
        String command = (String)ArgumentParser.getValue(params, "command", 0);
        for (int j = 0; j < commandSets.length; ++j) {
            if (!commandSets[j][0].equals(command)) continue;
            return commandSets[j];
        }
        throw new ParseException("Command '" + command + "' not found", 0);
    }

    public static class ArgumentParseException
    extends ParseException {
        private ArgumentParameter parameterFormatDetail;
        private ArgumentFormat parameterFormat;
        private String value;

        public ArgumentParseException(int position, String value, ArgumentFormat parameterFormat, ArgumentParameter parameterFormatDetail) {
            super(value != null ? "Invalid value '" + value + "' at position " + position : "Mandatory parameter " + parameterFormat.getOption() + "(" + parameterFormatDetail.getName() + ") not specified", position);
            this.parameterFormat = parameterFormat;
            this.parameterFormatDetail = parameterFormatDetail;
            this.value = value;
        }

        public ArgumentParseException(String message, int position, String value, ArgumentFormat parameterFormat, ArgumentParameter parameterFormatDetail) {
            super(message, position);
            this.parameterFormat = parameterFormat;
            this.parameterFormatDetail = parameterFormatDetail;
            this.value = value;
        }

        public ArgumentParameter getParameterFormatDetail() {
            return this.parameterFormatDetail;
        }

        public ArgumentFormat getParameterFormat() {
            return this.parameterFormat;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class ArgumentParameter {
        private String name;
        private int type;
        private Pattern pattern;
        private String defaultValue;

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public int getType() {
            return this.type;
        }

        public String toString() {
            return "ArgumentParameter[name=" + this.name + ",type=" + this.type + ",patttern=" + (this.pattern == null ? null : this.pattern.pattern()) + ",defaultValue=" + this.defaultValue + "]";
        }
    }

    public static class ArgumentFormat {
        private String option;
        private boolean mandatory;
        private boolean parameter;
        private ArgumentParameter[] params;
        private boolean vararg;

        public boolean isMandatory() {
            return this.mandatory;
        }

        public boolean isParameter() {
            return this.parameter;
        }

        public String getOption() {
            return this.option;
        }

        public ArgumentParameter[] getParameters() {
            return this.params;
        }

        public boolean isVariableLength() {
            return this.vararg;
        }

        public String toString() {
            return "ArgumentFormat[option=" + this.option + ",parameter=" + this.parameter + ",vararg=" + this.vararg + ",mandatatory=" + this.mandatory + ",parameters=" + (this.params == null ? "<null>" : Arrays.asList(this.params).toString()) + "]";
        }

        static /* synthetic */ ArgumentParameter[] access$802(ArgumentFormat x0, ArgumentParameter[] x1) {
            x0.params = x1;
            return x1;
        }
    }
}

