/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.config;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.hyperic.util.PropertyUtil;
import org.hyperic.util.PropertyUtilException;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.EarlyExitException;
import org.hyperic.util.config.EncodingException;
import org.hyperic.util.config.InteractiveResponseBuilder;
import org.hyperic.util.config.InteractiveResponseBuilder_IOHandler;
import org.hyperic.util.config.InvalidOptionException;
import org.hyperic.util.config.InvalidOptionValueException;
import org.hyperic.util.config.SkipConfigException;

public class AutomatedResponseBuilder
extends InteractiveResponseBuilder {
    private Properties props = null;
    private String requiredProp = null;
    private boolean hasRequiredProp = false;

    public AutomatedResponseBuilder(InteractiveResponseBuilder_IOHandler io, Properties props, String requiredProp) {
        super(io);
        this.props = props;
        this.requiredProp = requiredProp;
        this.hasRequiredProp = props.getProperty(requiredProp) != null;
    }

    public AutomatedResponseBuilder(InteractiveResponseBuilder_IOHandler io, File propFile, String requiredProp) throws PropertyUtilException {
        super(io);
        this.props = PropertyUtil.loadProperties(propFile.getPath());
        this.requiredProp = requiredProp;
        this.hasRequiredProp = this.props.getProperty(requiredProp) != null;
    }

    @Override
    public ConfigResponse processConfigSchema(ConfigSchema schema) throws EncodingException, IOException, InvalidOptionException, EarlyExitException {
        if (!this.hasRequiredProp) {
            throw new SkipConfigException("skipping config due to missing required property: " + this.requiredProp);
        }
        List<ConfigOption> options = schema.getOptions();
        int nOptions = options.size();
        ConfigResponse res = new ConfigResponse(schema);
        for (int i = 0; i < nOptions; ++i) {
            ConfigOption opt = options.get(i);
            String optName = opt.getName();
            try {
                String prop = this.props.getProperty(optName);
                if (prop == null) {
                    String default1 = opt.getDefault();
                    if (opt.isOptional() && (default1 == null || default1.isEmpty())) continue;
                    res.setValue(optName, default1);
                    continue;
                }
                res.setValue(optName, prop);
                continue;
            }
            catch (InvalidOptionValueException exc) {
                this.sendToErrStream(exc.getMessage());
                throw new IllegalStateException("Error setting option  value for " + optName + ", " + "cannot continue: " + exc);
            }
        }
        return res;
    }
}

