/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.hyperic.util.file.FileUtil;
import org.hyperic.util.file.WriterHandler;

class CreateOrOverwriteWriter
extends WriterHandler {
    private final File destFile;
    private File backupFile;
    private final InputStream inStream;
    private boolean copied;
    private boolean created;

    CreateOrOverwriteWriter(File destFile, InputStream inStream) {
        this.destFile = destFile;
        this.backupFile = null;
        this.inStream = inStream;
        this.copied = false;
        this.created = false;
    }

    @Override
    public void rollback() throws IOException {
        block6: {
            block5: {
                super.rollback();
                if (this.backupFile == null) break block5;
                if (this.backupFile.renameTo(this.destFile)) break block6;
                FileInputStream inputStream = null;
                FileOutputStream outputStream = null;
                try {
                    inputStream = new FileInputStream(this.backupFile);
                    outputStream = new FileOutputStream(this.destFile);
                    FileUtil.copyStream(inputStream, outputStream);
                }
                catch (IOException exc) {
                    try {
                        this.backupFile.delete();
                        throw exc;
                    }
                    catch (Throwable throwable) {
                        CreateOrOverwriteWriter.closeStreams(inputStream, outputStream);
                        throw throwable;
                    }
                }
                CreateOrOverwriteWriter.closeStreams(inputStream, outputStream);
                break block6;
            }
            if (this.created) {
                this.destFile.delete();
            }
        }
    }

    private void setupBackup() throws IOException {
        File parentDir = this.destFile.getAbsoluteFile().getParentFile();
        if (parentDir == null) {
            throw new IOException("Unable to get the owner directory for " + this.destFile);
        }
        if (this.destFile.exists()) {
            if (!this.destFile.isFile()) {
                throw new IOException(this.destFile + " is not a regular file");
            }
            try {
                this.backupFile = File.createTempFile("fwrite", "tmp", parentDir);
            }
            catch (IOException exc) {
                this.backupFile = File.createTempFile("fwrite", "tmp");
            }
            if (!this.destFile.renameTo(this.backupFile)) {
                FileInputStream inputStream = null;
                FileOutputStream outputStream = null;
                try {
                    inputStream = new FileInputStream(this.destFile);
                    outputStream = new FileOutputStream(this.backupFile);
                    FileUtil.copyStream(inputStream, outputStream);
                    this.copied = true;
                }
                catch (IOException exc) {
                    try {
                        throw new IOException("Unable to rename " + this.destFile + " to " + this.backupFile + " for backup purposes");
                    }
                    catch (Throwable throwable) {
                        CreateOrOverwriteWriter.closeStreams(inputStream, outputStream);
                        throw throwable;
                    }
                }
                CreateOrOverwriteWriter.closeStreams(inputStream, outputStream);
            }
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.backupFile != null) {
            this.backupFile.delete();
            this.backupFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write() throws IOException {
        super.write();
        this.setupBackup();
        if (!this.copied) {
            if (!this.destFile.createNewFile()) {
                throw new IOException("Unable to create " + this.destFile);
            }
            this.created = true;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.destFile);
        try {
            IOUtils.copy((InputStream)this.inStream, (OutputStream)fileOutputStream);
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeStreams(FileInputStream inputStream, FileOutputStream outputStream) throws IOException {
        try {
            if (null != inputStream) {
                inputStream.close();
            }
        }
        finally {
            if (null != outputStream) {
                outputStream.close();
            }
        }
    }
}

