/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.ntp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.ntp.NtpResponse;

public class NtpClient {
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final int DEFAULT_PORT = 123;
    private static Log log = LogFactory.getLog((String)NtpClient.class.getName());
    private String hostname;
    private int port;
    private int timeout;

    public NtpClient(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
        this.timeout = 10000;
    }

    public NtpClient(String hostname) {
        this(hostname, 123);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected static double now() {
        return (double)System.currentTimeMillis() / 1000.0 + 2.2089888E9;
    }

    public NtpResponse getResponse() throws SocketException, UnknownHostException, IOException {
        DatagramSocket socket = new DatagramSocket();
        socket.setSoTimeout(this.timeout);
        InetAddress address = InetAddress.getByName(this.hostname);
        byte[] data = NtpResponse.getRequestBytes();
        DatagramPacket packet = new DatagramPacket(data, data.length, address, this.port);
        socket.send(packet);
        packet = new DatagramPacket(data, data.length);
        socket.receive(packet);
        NtpResponse response = NtpResponse.decodeResponse(NtpClient.now(), packet.getData());
        return response;
    }
}

