/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.pager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hyperic.util.pager.DefaultPagerProcessor;
import org.hyperic.util.pager.PageControl;
import org.hyperic.util.pager.PageList;
import org.hyperic.util.pager.PagerEventHandler;
import org.hyperic.util.pager.PagerProcessor;
import org.hyperic.util.pager.PagerProcessorExt;

public class Pager {
    public static final String DEFAULT_PROCESSOR_CLASSNAME = DefaultPagerProcessor.class.getName();
    private static final Map PAGER_PROCESSOR_MAP = Collections.synchronizedMap(new HashMap());
    private PagerProcessor _processor;
    private boolean _skipNulls = false;
    private PagerEventHandler _eventHandler;

    public Pager(PagerProcessor processor) {
        this._processor = processor;
        this._skipNulls = false;
        this._eventHandler = null;
        if (this._processor instanceof PagerProcessorExt) {
            this._skipNulls = ((PagerProcessorExt)this._processor).skipNulls();
            this._eventHandler = ((PagerProcessorExt)this._processor).getEventHandler();
        }
    }

    public static Pager getDefaultPager() {
        try {
            return Pager.getPager(DEFAULT_PROCESSOR_CLASSNAME);
        }
        catch (Exception e) {
            throw new RuntimeException("This should never happen", e);
        }
    }

    public static Pager getPager(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Pager p = (Pager)PAGER_PROCESSOR_MAP.get(className);
        if (p == null) {
            PagerProcessor processor = (PagerProcessor)Class.forName(className).newInstance();
            p = new Pager(processor);
            PAGER_PROCESSOR_MAP.put(className, p);
        }
        return p;
    }

    public PageList seek(Collection source, int pagenum, int pagesize) {
        return this.seek(source, pagenum, pagesize, null);
    }

    public PageList seek(Collection source, PageControl pc) {
        if (pc == null) {
            pc = PageControl.PAGE_ALL;
        }
        return this.seek(source, pc.getPagenum(), pc.getPagesize(), null);
    }

    public PageList seek(Collection source, PageControl pc, Object procData) {
        if (pc == null) {
            pc = PageControl.PAGE_ALL;
        }
        return this.seek(source, pc.getPagenum(), pc.getPagesize(), procData);
    }

    public PageList seek(Collection source, int pagenum, int pagesize, Object procData) {
        PageList dest = new PageList();
        dest.setTotalSize(this.seek(source, dest, pagenum, pagesize, procData));
        return dest;
    }

    public void seek(Collection source, Collection dest, int pagenum, int pagesize) {
        this.seek(source, dest, pagenum, pagesize, null);
    }

    public int seek(Collection source, Collection dest, int pagenum, int pagesize, Object procData) {
        Iterator iter = source.iterator();
        int size = source.size();
        if (pagesize == -1 || pagenum == -1) {
            pagenum = 0;
            pagesize = Integer.MAX_VALUE;
        }
        int i = 0;
        for (int currentPage = 0; iter.hasNext() && currentPage < pagenum; currentPage += ++i % pagesize == 0 ? 1 : 0) {
            iter.next();
        }
        if (this._eventHandler != null) {
            this._eventHandler.init();
        }
        if (this._skipNulls) {
            while (iter.hasNext()) {
                Object elt = this._processor instanceof PagerProcessorExt ? ((PagerProcessorExt)this._processor).processElement(iter.next(), procData) : this._processor.processElement(iter.next());
                if (elt == null) {
                    --size;
                    continue;
                }
                if (dest.size() < pagesize) {
                    dest.add(elt);
                    continue;
                }
                if (procData != null) continue;
                break;
            }
        } else {
            while (iter.hasNext() && dest.size() < pagesize) {
                dest.add(this._processor.processElement(iter.next()));
            }
        }
        if (this._eventHandler != null) {
            this._eventHandler.cleanup();
        }
        return size;
    }

    public PageList seekAll(Collection source, int pagenum, int pagesize, Object procData) {
        PageList dest = new PageList();
        dest.setTotalSize(this.seekAll(source, dest, pagenum, pagesize, procData));
        return dest;
    }

    public int seekAll(Collection source, Collection dest, int pagenum, int pagesize, Object procData) {
        Object elt;
        Iterator iter = source.iterator();
        int size = source.size();
        if (pagesize == -1 || pagenum == -1) {
            pagenum = 0;
            pagesize = Integer.MAX_VALUE;
        }
        int i = 0;
        for (int currentPage = 0; iter.hasNext() && currentPage < pagenum; currentPage += i != 0 && i % pagesize == 0 ? 1 : 0) {
            Object ret = null;
            ret = this._processor instanceof PagerProcessorExt ? ((PagerProcessorExt)this._processor).processElement(iter.next(), procData) : this._processor.processElement(iter.next());
            if (ret == null) continue;
            ++i;
        }
        if (this._eventHandler != null) {
            this._eventHandler.init();
        }
        if (this._skipNulls) {
            while (iter.hasNext()) {
                elt = this._processor instanceof PagerProcessorExt ? ((PagerProcessorExt)this._processor).processElement(iter.next(), procData) : this._processor.processElement(iter.next());
                if (elt == null) {
                    --size;
                    continue;
                }
                if (dest.size() >= pagesize) continue;
                dest.add(elt);
            }
        } else {
            while (iter.hasNext()) {
                elt = this._processor.processElement(iter.next());
                if (dest.size() >= pagesize) continue;
                dest.add(elt);
            }
        }
        if (this._eventHandler != null) {
            this._eventHandler.cleanup();
        }
        return size;
    }

    public PageList processAll(PageList source) {
        PageList dest = new PageList();
        int size = source.getTotalSize();
        Iterator it = source.iterator();
        while (it.hasNext()) {
            Object elt = this._processor.processElement(it.next());
            if (elt == null) {
                --size;
                continue;
            }
            dest.add(elt);
        }
        dest.setTotalSize(size);
        return dest;
    }

    public Object processOne(Object one) {
        return this._processor.processElement(one);
    }
}

