/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.schedule;

public class ScheduledItem {
    private Object obj;
    private long interval;
    private long nextTime;
    private boolean repeat;
    private long id;
    private long offset;

    ScheduledItem(Object obj, long interval, long offset, boolean prev, boolean repeat, long id) {
        this.obj = obj;
        this.interval = interval;
        this.repeat = repeat;
        this.id = id;
        this.offset = offset;
        this.nextTime = prev ? ScheduledItem.getScheduledTimePrev(interval, offset) : ScheduledItem.getScheduledTime(interval, offset);
    }

    public static long getScheduledTimePrev(long interval, long offset) {
        long currentTime = System.currentTimeMillis();
        long next = currentTime - currentTime % interval + offset;
        if (next > currentTime) {
            next -= interval;
        }
        return next;
    }

    public static long getScheduledTime(long interval, long offset) {
        long currentTime = System.currentTimeMillis();
        long next = currentTime - currentTime % interval + offset;
        if (next < currentTime) {
            next += interval;
        }
        return next;
    }

    public Object getObj() {
        return this.obj;
    }

    public long getInterval() {
        return this.interval;
    }

    public long getNextTime() {
        return this.nextTime;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public long getId() {
        return this.id;
    }

    public void stepNextTime() {
        long curTime = System.currentTimeMillis();
        this.nextTime += this.interval;
        if (this.nextTime < curTime) {
            this.nextTime = ScheduledItem.getScheduledTime(this.interval, this.offset);
        }
    }
}

